varying vec2 vtc;

uniform sampler2D tex;
uniform sampler2D texNormal;
uniform float cutoff;

// The width of the image we are downscaling by 2 (NOT divided by 2!)
uniform float width;
uniform float height;

void main(void)
{
	// TODO: We could use alpha here as well to combine with cutoff...

	//float tglow = texture2D(texNormal, gl_FragCoord.xy*vec2(width, height)).a;

	float dx = 0.5 / width;
	float dy = 0.5 / height;

	vec2 d = vec2(dx,dy);

	// Right now we are evaluating at the center point of the LARGE square. I think the code below is correct but how do I know?

	// Box filter (since we have no mipmaps we do it manually)
	vec4 c0 = texture2D(tex, vtc + d * vec2(-1.0,-1.0))*texture2D(texNormal, vtc+d*vec2(-1.0,-1.0)).a;
	vec4 c1 = texture2D(tex, vtc + d * vec2( 1.0,-1.0))*texture2D(texNormal, vtc+d*vec2(1.0,-1.0)).a;
	vec4 c2 = texture2D(tex, vtc + d * vec2(-1.0, 1.0))*texture2D(texNormal, vtc+d*vec2(-1.0,1.0)).a;
	vec4 c3 = texture2D(tex, vtc + d * vec2( 1.0, 1.0))*texture2D(texNormal, vtc+d*vec2(1.0,1.0)).a;

	vec4 c = (c0+c1+c2+c3)*0.25;

	gl_FragColor = c;
}
