/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;

public class PImage
implements PConstants,
Cloneable {
    public int format;
    public int[] pixels;
    public int width;
    public int height;
    public PApplet parent;
    protected HashMap<Object, Object> cacheMap;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    private int blurRadius;
    private int blurKernelSize;
    private int[] blurKernel;
    private int[][] blurMult;
    static byte[] TIFF_HEADER = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 9, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 3, 0, 0, 0, 122, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 3, 0, 1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 8};
    static final String TIFF_ERROR = "Error: Processing can only read its own TIFF files.";
    protected String[] saveImageFormats;

    public PImage() {
        this.format = 2;
    }

    public PImage(int n, int n2) {
        this.init(n, n2, 1);
    }

    public PImage(int n, int n2, int n3) {
        this.init(n, n2, n3);
    }

    public void init(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.pixels = new int[n * n2];
        this.format = n3;
    }

    protected void checkAlpha() {
        if (this.pixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            if ((this.pixels[i] & 0xFF000000) == -16777216) continue;
            this.format = 2;
            break;
        }
    }

    public PImage(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            this.pixels = new int[this.width * this.height];
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.getDataElements(0, 0, this.width, this.height, this.pixels);
        } else {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.format = 1;
    }

    public Image getImage() {
        this.loadPixels();
        int n = this.format == 1 ? 1 : 2;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, n);
        WritableRaster writableRaster = bufferedImage.getRaster();
        writableRaster.setDataElements(0, 0, this.width, this.height, this.pixels);
        return bufferedImage;
    }

    public void setCache(Object object, Object object2) {
        if (this.cacheMap == null) {
            this.cacheMap = new HashMap();
        }
        this.cacheMap.put(object, object2);
    }

    public Object getCache(Object object) {
        if (this.cacheMap == null) {
            return null;
        }
        return this.cacheMap.get(object);
    }

    public void removeCache(Object object) {
        if (this.cacheMap != null) {
            this.cacheMap.remove(object);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void loadPixels() {
    }

    public void updatePixels() {
        this.updatePixelsImpl(0, 0, this.width, this.height);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.updatePixelsImpl(n, n2, n3, n4);
    }

    protected void updatePixelsImpl(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (!this.modified) {
            this.mx1 = n;
            this.mx2 = n5;
            this.my1 = n2;
            this.my2 = n6;
            this.modified = true;
        } else {
            if (n < this.mx1) {
                this.mx1 = n;
            }
            if (n > this.mx2) {
                this.mx2 = n;
            }
            if (n2 < this.my1) {
                this.my1 = n2;
            }
            if (n2 > this.my2) {
                this.my2 = n2;
            }
            if (n5 < this.mx1) {
                this.mx1 = n5;
            }
            if (n5 > this.mx2) {
                this.mx2 = n5;
            }
            if (n6 < this.my1) {
                this.my1 = n6;
            }
            if (n6 > this.my2) {
                this.my2 = n6;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PImage pImage = (PImage)super.clone();
        pImage.pixels = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pImage.pixels, 0, this.pixels.length);
        return pImage;
    }

    public void resize(int n, int n2) {
        this.loadPixels();
        if (n <= 0 && n2 <= 0) {
            this.width = 0;
            this.height = 0;
            this.pixels = new int[0];
        } else {
            float f;
            if (n == 0) {
                f = (float)n2 / (float)this.height;
                n = (int)((float)this.width * f);
            } else if (n2 == 0) {
                f = (float)n / (float)this.width;
                n2 = (int)((float)this.height * f);
            }
            PImage pImage = new PImage(n, n2, this.format);
            pImage.copy(this, 0, 0, this.width, this.height, 0, 0, n, n2);
            this.width = n;
            this.height = n2;
            this.pixels = pImage.pixels;
        }
        this.updatePixels();
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        switch (this.format) {
            case 1: {
                return this.pixels[n2 * this.width + n] | 0xFF000000;
            }
            case 2: {
                return this.pixels[n2 * this.width + n];
            }
            case 4: {
                return this.pixels[n2 * this.width + n] << 24 | 0xFFFFFF;
            }
        }
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        return this.getImpl(n, n2, n3, n4);
    }

    protected PImage getImpl(int n, int n2, int n3, int n4) {
        PImage pImage = new PImage(n3, n4, this.format);
        pImage.parent = this.parent;
        int n5 = n2 * this.width + n;
        int n6 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            System.arraycopy(this.pixels, n5, pImage.pixels, n6, n3);
            n5 += this.width;
            n6 += n3;
        }
        return pImage;
    }

    public PImage get() {
        try {
            PImage pImage = (PImage)this.clone();
            pImage.cacheMap = null;
            return pImage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.pixels[n2 * this.width + n] = n3;
        this.updatePixelsImpl(n, n2, n + 1, n2 + 1);
    }

    public void set(int n, int n2, PImage pImage) {
        int n3 = 0;
        int n4 = 0;
        int n5 = pImage.width;
        int n6 = pImage.height;
        if (n < 0) {
            n3 -= n;
            n5 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 -= n2;
            n6 += n2;
            n2 = 0;
        }
        if (n + n5 > this.width) {
            n5 = this.width - n;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.setImpl(n, n2, n3, n4, n5, n6, pImage);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        int n7 = n4 * pImage.width + n3;
        int n8 = n2 * this.width + n;
        for (int i = n4; i < n4 + n6; ++i) {
            System.arraycopy(pImage.pixels, n7, this.pixels, n8, n5);
            n7 += pImage.width;
            n8 += this.width;
        }
        this.updatePixelsImpl(n3, n4, n3 + n5, n4 + n6);
    }

    public void mask(int[] nArray) {
        this.loadPixels();
        if (nArray.length != this.pixels.length) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = (nArray[i] & 0xFF) << 24 | this.pixels[i] & 0xFFFFFF;
        }
        this.format = 2;
        this.updatePixels();
    }

    public void mask(PImage pImage) {
        this.mask(pImage.pixels);
    }

    public void filter(int n) {
        this.loadPixels();
        switch (n) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                if (this.format == 4) {
                    for (int i = 0; i < this.pixels.length; ++i) {
                        int n2 = 255 - this.pixels[i];
                        this.pixels[i] = 0xFF000000 | n2 << 16 | n2 << 8 | n2;
                    }
                    this.format = 1;
                    break;
                }
                for (int i = 0; i < this.pixels.length; ++i) {
                    int n3 = this.pixels[i];
                    int n4 = 77 * (n3 >> 16 & 0xFF) + 151 * (n3 >> 8 & 0xFF) + 28 * (n3 & 0xFF) >> 8;
                    this.pixels[i] = n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4;
                }
                break;
            }
            case 13: {
                int n5 = 0;
                while (n5 < this.pixels.length) {
                    int n6 = n5++;
                    this.pixels[n6] = this.pixels[n6] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 14: {
                int n7 = 0;
                while (n7 < this.pixels.length) {
                    int n8 = n7++;
                    this.pixels[n8] = this.pixels[n8] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
            case 17: {
                this.dilate(true);
                break;
            }
            case 18: {
                this.dilate(false);
            }
        }
        this.updatePixels();
    }

    public void filter(int n, float f) {
        this.loadPixels();
        switch (n) {
            case 11: {
                if (this.format == 4) {
                    this.blurAlpha(f);
                    break;
                }
                if (this.format == 2) {
                    this.blurARGB(f);
                    break;
                }
                this.blurRGB(f);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int n2 = (int)f;
                if (n2 < 2 || n2 > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int n3 = n2 - 1;
                for (int i = 0; i < this.pixels.length; ++i) {
                    int n4 = this.pixels[i] >> 16 & 0xFF;
                    int n5 = this.pixels[i] >> 8 & 0xFF;
                    int n6 = this.pixels[i] & 0xFF;
                    n4 = (n4 * n2 >> 8) * 255 / n3;
                    n5 = (n5 * n2 >> 8) * 255 / n3;
                    n6 = (n6 * n2 >> 8) * 255 / n3;
                    this.pixels[i] = 0xFF000000 & this.pixels[i] | n4 << 16 | n5 << 8 | n6;
                }
                break;
            }
            case 16: {
                int n7 = (int)(f * 255.0f);
                for (int i = 0; i < this.pixels.length; ++i) {
                    int n8 = Math.max((this.pixels[i] & 0xFF0000) >> 16, Math.max((this.pixels[i] & 0xFF00) >> 8, this.pixels[i] & 0xFF));
                    this.pixels[i] = this.pixels[i] & 0xFF000000 | (n8 < n7 ? 0 : 0xFFFFFF);
                }
                break;
            }
            case 17: {
                throw new RuntimeException("Use filter(ERODE) instead of filter(ERODE, param)");
            }
            case 18: {
                throw new RuntimeException("Use filter(DILATE) instead of filter(DILATE, param)");
            }
        }
        this.updatePixels();
    }

    protected void buildBlurKernel(float f) {
        int n = (int)(f * 3.5f);
        int n2 = n < 1 ? 1 : (n = n < 248 ? n : 248);
        if (this.blurRadius != n) {
            int[] nArray;
            int n3;
            this.blurRadius = n;
            this.blurKernelSize = 1 + this.blurRadius << 1;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            int n4 = n - 1;
            for (n3 = 1; n3 < n; ++n3) {
                int n5;
                this.blurKernel[n4] = n5 = n4 * n4;
                this.blurKernel[n + n3] = n5;
                nArray = this.blurMult[n + n3];
                int[] nArray2 = this.blurMult[n4--];
                for (int i = 0; i < 256; ++i) {
                    nArray[i] = nArray2[i] = n5 * i;
                }
            }
            int n6 = this.blurKernel[n] = n * n;
            nArray = this.blurMult[n];
            for (n3 = 0; n3 < 256; ++n3) {
                nArray[n3] = n6 * n3;
            }
        }
    }

    protected void blurAlpha(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int[] nArray = new int[this.pixels.length];
        int n9 = 0;
        this.buildBlurKernel(f);
        for (n8 = 0; n8 < this.height; ++n8) {
            for (n7 = 0; n7 < this.width; ++n7) {
                n6 = 0;
                n5 = 0;
                n4 = n7 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n4 < this.width; ++n4, ++n2) {
                    int n10 = this.pixels[n4 + n9];
                    int[] nArray2 = this.blurMult[n2];
                    n5 += nArray2[n10 & 0xFF];
                    n6 += this.blurKernel[n2];
                }
                n = n9 + n7;
                nArray[n] = n5 / n6;
            }
            n9 += this.width;
        }
        n9 = 0;
        int n11 = -this.blurRadius;
        int n12 = n11 * this.width;
        for (n8 = 0; n8 < this.height; ++n8) {
            for (n7 = 0; n7 < this.width; ++n7) {
                n6 = 0;
                n5 = 0;
                if (n11 < 0) {
                    n3 = n = -n11;
                    n4 = n7;
                } else {
                    if (n11 >= this.height) break;
                    n3 = 0;
                    n = n11;
                    n4 = n7 + n12;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n < this.height; ++n2) {
                    int[] nArray3 = this.blurMult[n2];
                    n5 += nArray3[nArray[n4]];
                    n6 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                }
                this.pixels[n7 + n9] = n5 / n6;
            }
            n9 += this.width;
            n12 += this.width;
            ++n11;
        }
    }

    protected void blurRGB(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int[] nArray = new int[this.pixels.length];
        int[] nArray2 = new int[this.pixels.length];
        int[] nArray3 = new int[this.pixels.length];
        int n11 = 0;
        this.buildBlurKernel(f);
        for (n10 = 0; n10 < this.height; ++n10) {
            for (n9 = 0; n9 < this.width; ++n9) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n9 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n4 < this.width; ++n4, ++n2) {
                    int n12 = this.pixels[n4 + n11];
                    int[] nArray4 = this.blurMult[n2];
                    n7 += nArray4[(n12 & 0xFF0000) >> 16];
                    n6 += nArray4[(n12 & 0xFF00) >> 8];
                    n5 += nArray4[n12 & 0xFF];
                    n8 += this.blurKernel[n2];
                }
                n = n11 + n9;
                nArray[n] = n7 / n8;
                nArray2[n] = n6 / n8;
                nArray3[n] = n5 / n8;
            }
            n11 += this.width;
        }
        n11 = 0;
        int n13 = -this.blurRadius;
        int n14 = n13 * this.width;
        for (n10 = 0; n10 < this.height; ++n10) {
            for (n9 = 0; n9 < this.width; ++n9) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                if (n13 < 0) {
                    n3 = n = -n13;
                    n4 = n9;
                } else {
                    if (n13 >= this.height) break;
                    n3 = 0;
                    n = n13;
                    n4 = n9 + n14;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n < this.height; ++n2) {
                    int[] nArray5 = this.blurMult[n2];
                    n7 += nArray5[nArray[n4]];
                    n6 += nArray5[nArray2[n4]];
                    n5 += nArray5[nArray3[n4]];
                    n8 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                }
                this.pixels[n9 + n11] = 0xFF000000 | n7 / n8 << 16 | n6 / n8 << 8 | n5 / n8;
            }
            n11 += this.width;
            n14 += this.width;
            ++n13;
        }
    }

    protected void blurARGB(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = this.pixels.length;
        int[] nArray = new int[n12];
        int[] nArray2 = new int[n12];
        int[] nArray3 = new int[n12];
        int[] nArray4 = new int[n12];
        int n13 = 0;
        this.buildBlurKernel(f);
        for (n11 = 0; n11 < this.height; ++n11) {
            for (n10 = 0; n10 < this.width; ++n10) {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = n10 - this.blurRadius;
                if (n4 < 0) {
                    n3 = -n4;
                    n4 = 0;
                } else {
                    if (n4 >= this.width) break;
                    n3 = 0;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n4 < this.width; ++n4, ++n2) {
                    int n14 = this.pixels[n4 + n13];
                    int[] nArray5 = this.blurMult[n2];
                    n8 += nArray5[(n14 & 0xFF000000) >>> 24];
                    n7 += nArray5[(n14 & 0xFF0000) >> 16];
                    n6 += nArray5[(n14 & 0xFF00) >> 8];
                    n5 += nArray5[n14 & 0xFF];
                    n9 += this.blurKernel[n2];
                }
                n = n13 + n10;
                nArray4[n] = n8 / n9;
                nArray[n] = n7 / n9;
                nArray2[n] = n6 / n9;
                nArray3[n] = n5 / n9;
            }
            n13 += this.width;
        }
        n13 = 0;
        int n15 = -this.blurRadius;
        int n16 = n15 * this.width;
        for (n11 = 0; n11 < this.height; ++n11) {
            for (n10 = 0; n10 < this.width; ++n10) {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                if (n15 < 0) {
                    n3 = n = -n15;
                    n4 = n10;
                } else {
                    if (n15 >= this.height) break;
                    n3 = 0;
                    n = n15;
                    n4 = n10 + n16;
                }
                for (n2 = n3; n2 < this.blurKernelSize && n < this.height; ++n2) {
                    int[] nArray6 = this.blurMult[n2];
                    n8 += nArray6[nArray4[n4]];
                    n7 += nArray6[nArray[n4]];
                    n6 += nArray6[nArray2[n4]];
                    n5 += nArray6[nArray3[n4]];
                    n9 += this.blurKernel[n2];
                    ++n;
                    n4 += this.width;
                }
                this.pixels[n10 + n13] = n8 / n9 << 24 | n7 / n9 << 16 | n6 / n9 << 8 | n5 / n9;
            }
            n13 += this.width;
            n16 += this.width;
            ++n15;
        }
    }

    protected void dilate(boolean bl) {
        int n = 0;
        int n2 = this.pixels.length;
        int[] nArray = new int[n2];
        if (!bl) {
            while (n < n2) {
                int n3 = n;
                int n4 = n + this.width;
                while (n < n4) {
                    int n5;
                    int n6 = n5 = this.pixels[n];
                    int n7 = n - 1;
                    int n8 = n + 1;
                    int n9 = n - this.width;
                    int n10 = n + this.width;
                    if (n7 < n3) {
                        n7 = n;
                    }
                    if (n8 >= n4) {
                        n8 = n;
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n10 >= n2) {
                        n10 = n;
                    }
                    int n11 = this.pixels[n9];
                    int n12 = this.pixels[n7];
                    int n13 = this.pixels[n10];
                    int n14 = this.pixels[n8];
                    int n15 = 77 * (n6 >> 16 & 0xFF) + 151 * (n6 >> 8 & 0xFF) + 28 * (n6 & 0xFF);
                    int n16 = 77 * (n12 >> 16 & 0xFF) + 151 * (n12 >> 8 & 0xFF) + 28 * (n12 & 0xFF);
                    int n17 = 77 * (n14 >> 16 & 0xFF) + 151 * (n14 >> 8 & 0xFF) + 28 * (n14 & 0xFF);
                    int n18 = 77 * (n11 >> 16 & 0xFF) + 151 * (n11 >> 8 & 0xFF) + 28 * (n11 & 0xFF);
                    int n19 = 77 * (n13 >> 16 & 0xFF) + 151 * (n13 >> 8 & 0xFF) + 28 * (n13 & 0xFF);
                    if (n16 > n15) {
                        n5 = n12;
                        n15 = n16;
                    }
                    if (n17 > n15) {
                        n5 = n14;
                        n15 = n17;
                    }
                    if (n18 > n15) {
                        n5 = n11;
                        n15 = n18;
                    }
                    if (n19 > n15) {
                        n5 = n13;
                        n15 = n19;
                    }
                    nArray[n++] = n5;
                }
            }
        } else {
            while (n < n2) {
                int n20 = n;
                int n21 = n + this.width;
                while (n < n21) {
                    int n22;
                    int n23 = n22 = this.pixels[n];
                    int n24 = n - 1;
                    int n25 = n + 1;
                    int n26 = n - this.width;
                    int n27 = n + this.width;
                    if (n24 < n20) {
                        n24 = n;
                    }
                    if (n25 >= n21) {
                        n25 = n;
                    }
                    if (n26 < 0) {
                        n26 = 0;
                    }
                    if (n27 >= n2) {
                        n27 = n;
                    }
                    int n28 = this.pixels[n26];
                    int n29 = this.pixels[n24];
                    int n30 = this.pixels[n27];
                    int n31 = this.pixels[n25];
                    int n32 = 77 * (n23 >> 16 & 0xFF) + 151 * (n23 >> 8 & 0xFF) + 28 * (n23 & 0xFF);
                    int n33 = 77 * (n29 >> 16 & 0xFF) + 151 * (n29 >> 8 & 0xFF) + 28 * (n29 & 0xFF);
                    int n34 = 77 * (n31 >> 16 & 0xFF) + 151 * (n31 >> 8 & 0xFF) + 28 * (n31 & 0xFF);
                    int n35 = 77 * (n28 >> 16 & 0xFF) + 151 * (n28 >> 8 & 0xFF) + 28 * (n28 & 0xFF);
                    int n36 = 77 * (n30 >> 16 & 0xFF) + 151 * (n30 >> 8 & 0xFF) + 28 * (n30 & 0xFF);
                    if (n33 < n32) {
                        n22 = n29;
                        n32 = n33;
                    }
                    if (n34 < n32) {
                        n22 = n31;
                        n32 = n34;
                    }
                    if (n35 < n32) {
                        n22 = n28;
                        n32 = n35;
                    }
                    if (n36 < n32) {
                        n22 = n30;
                        n32 = n36;
                    }
                    nArray[n++] = n22;
                }
            }
        }
        System.arraycopy(nArray, 0, this.pixels, 0, n2);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.blend(this, n, n2, n3, n4, n5, n6, n7, n8, 0);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, 0);
    }

    public static int blendColor(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n2;
            }
            case 1: {
                return PImage.blend_blend(n, n2);
            }
            case 2: {
                return PImage.blend_add_pin(n, n2);
            }
            case 4: {
                return PImage.blend_sub_pin(n, n2);
            }
            case 8: {
                return PImage.blend_lightest(n, n2);
            }
            case 16: {
                return PImage.blend_darkest(n, n2);
            }
            case 32: {
                return PImage.blend_difference(n, n2);
            }
            case 64: {
                return PImage.blend_exclusion(n, n2);
            }
            case 128: {
                return PImage.blend_multiply(n, n2);
            }
            case 256: {
                return PImage.blend_screen(n, n2);
            }
            case 1024: {
                return PImage.blend_hard_light(n, n2);
            }
            case 2048: {
                return PImage.blend_soft_light(n, n2);
            }
            case 512: {
                return PImage.blend_overlay(n, n2);
            }
            case 4096: {
                return PImage.blend_dodge(n, n2);
            }
            case 8192: {
                return PImage.blend_burn(n, n2);
            }
        }
        return 0;
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.blend(this, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n + n3;
        int n11 = n2 + n4;
        int n12 = n5 + n7;
        int n13 = n6 + n8;
        this.loadPixels();
        if (pImage == this) {
            if (this.intersect(n, n2, n10, n11, n5, n6, n12, n13)) {
                this.blit_resize(this.get(n, n2, n10 - n, n11 - n2), 0, 0, n10 - n - 1, n11 - n2 - 1, this.pixels, this.width, this.height, n5, n6, n12, n13, n9);
            } else {
                this.blit_resize(pImage, n, n2, n10, n11, this.pixels, this.width, this.height, n5, n6, n12, n13, n9);
            }
        } else {
            pImage.loadPixels();
            this.blit_resize(pImage, n, n2, n10, n11, this.pixels, this.width, this.height, n5, n6, n12, n13, n9);
        }
        this.updatePixels();
    }

    private boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10 = n3 - n + 1;
        int n11 = n4 - n2 + 1;
        int n12 = n7 - n5 + 1;
        int n13 = n8 - n6 + 1;
        if (n5 < n) {
            if ((n12 += n5 - n) > n10) {
                n12 = n10;
            }
        } else {
            n9 = n10 + n - n5;
            if (n12 > n9) {
                n12 = n9;
            }
        }
        if (n6 < n2) {
            if ((n13 += n6 - n2) > n11) {
                n13 = n11;
            }
        } else {
            n9 = n11 + n2 - n6;
            if (n13 > n9) {
                n13 = n9;
            }
        }
        return n12 > 0 && n13 > 0;
    }

    private void blit_resize(PImage pImage, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        block103: {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            block102: {
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 >= pImage.width) {
                    n3 = pImage.width - 1;
                }
                if (n4 >= pImage.height) {
                    n4 = pImage.height - 1;
                }
                int n17 = n3 - n;
                int n18 = n4 - n2;
                n16 = n9 - n7;
                n15 = n10 - n8;
                boolean bl = true;
                if (!bl) {
                    ++n17;
                    ++n18;
                }
                if (n16 <= 0 || n15 <= 0 || n17 <= 0 || n18 <= 0 || n7 >= n5 || n8 >= n6 || n >= pImage.width || n2 >= pImage.height) {
                    return;
                }
                n14 = (int)((float)n17 / (float)n16 * 32768.0f);
                n13 = (int)((float)n18 / (float)n15 * 32768.0f);
                this.srcXOffset = n7 < 0 ? -n7 * n14 : n * 32768;
                int n19 = this.srcYOffset = n8 < 0 ? -n8 * n13 : n2 * 32768;
                if (n7 < 0) {
                    n16 += n7;
                    n7 = 0;
                }
                if (n8 < 0) {
                    n15 += n8;
                    n8 = 0;
                }
                n16 = PImage.low(n16, n5 - n7);
                n15 = PImage.low(n15, n6 - n8);
                n12 = n8 * n5 + n7;
                this.srcBuffer = pImage.pixels;
                if (!bl) break block102;
                this.iw = pImage.width;
                this.iw1 = pImage.width - 1;
                this.ih1 = pImage.height - 1;
                switch (n11) {
                    case 1: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_blend(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 2: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_add_pin(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 4: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_sub_pin(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 8: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_lightest(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 16: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_darkest(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 0: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = this.filter_bilinear();
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 32: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_difference(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 64: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_exclusion(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 128: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_multiply(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 256: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_screen(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 512: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_overlay(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 1024: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_hard_light(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 2048: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_soft_light(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 4096: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_dodge(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break block103;
                    }
                    case 8192: {
                        for (int i = 0; i < n15; ++i) {
                            this.filter_new_scanline();
                            for (int j = 0; j < n16; ++j) {
                                nArray[n12 + j] = PImage.blend_burn(nArray[n12 + j], this.filter_bilinear());
                                this.sX += n14;
                            }
                            n12 += n5;
                            this.srcYOffset += n13;
                        }
                        break;
                    }
                }
                break block103;
            }
            switch (n11) {
                case 1: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_blend(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_add_pin(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_sub_pin(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 8: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_lightest(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 16: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_darkest(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 0: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = this.srcBuffer[this.sY + (this.sX >> 15)];
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 32: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_difference(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 64: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_exclusion(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 128: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_multiply(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 256: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_screen(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 512: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_overlay(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 1024: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_hard_light(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 2048: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_soft_light(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 4096: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_dodge(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
                case 8192: {
                    for (int i = 0; i < n15; ++i) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * pImage.width;
                        for (int j = 0; j < n16; ++j) {
                            nArray[n12 + j] = PImage.blend_burn(nArray[n12 + j], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += n14;
                        }
                        n12 += n5;
                        this.srcYOffset += n13;
                    }
                    break;
                }
            }
        }
    }

    private void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - this.fracV;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.low((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private int filter_bilinear() {
        this.fracU = this.sX & Short.MAX_VALUE;
        this.ifU = Short.MAX_VALUE - this.fracU;
        this.ul = this.ifU * this.ifV >> 15;
        this.ll = this.ifU * this.fracV >> 15;
        this.ur = this.fracU * this.ifV >> 15;
        this.lr = this.fracU * this.fracV >> 15;
        this.u1 = this.sX >> 15;
        this.u2 = PImage.low(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = this.ul * ((this.cUL & 0xFF0000) >> 16) + this.ll * ((this.cLL & 0xFF0000) >> 16) + this.ur * ((this.cUR & 0xFF0000) >> 16) + this.lr * ((this.cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        this.g = this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) >>> 15 & 0xFF00;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 15;
        this.a = this.ul * ((this.cUL & 0xFF000000) >>> 24) + this.ll * ((this.cLL & 0xFF000000) >>> 24) + this.ur * ((this.cUR & 0xFF000000) >>> 24) + this.lr * ((this.cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return this.a | this.r | this.g | this.b;
    }

    private static int low(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static int high(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static int peg(int n) {
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    private static int mix(int n, int n2, int n3) {
        return n + ((n2 - n) * n3 >> 8);
    }

    private static int blend_blend(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, n2 & 0xFF0000, n3) & 0xFF0000 | PImage.mix(n & 0xFF00, n2 & 0xFF00, n3) & 0xFF00 | PImage.mix(n & 0xFF, n2 & 0xFF, n3);
    }

    private static int blend_add_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.low((n & 0xFF0000) + ((n2 & 0xFF0000) >> 8) * n3, 0xFF0000) & 0xFF0000 | PImage.low((n & 0xFF00) + ((n2 & 0xFF00) >> 8) * n3, 65280) & 0xFF00 | PImage.low((n & 0xFF) + ((n2 & 0xFF) * n3 >> 8), 255);
    }

    private static int blend_sub_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high((n & 0xFF0000) - ((n2 & 0xFF0000) >> 8) * n3, 65280) & 0xFF0000 | PImage.high((n & 0xFF00) - ((n2 & 0xFF00) >> 8) * n3, 255) & 0xFF00 | PImage.high((n & 0xFF) - ((n2 & 0xFF) * n3 >> 8), 0);
    }

    private static int blend_lightest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.high(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3) & 0xFF0000 | PImage.high(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3) & 0xFF00 | PImage.high(n & 0xFF, (n2 & 0xFF) * n3 >> 8);
    }

    private static int blend_darkest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.mix(n & 0xFF0000, PImage.low(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3), n3) & 0xFF0000 | PImage.mix(n & 0xFF00, PImage.low(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3), n3) & 0xFF00 | PImage.mix(n & 0xFF, PImage.low(n & 0xFF, (n2 & 0xFF) * n3 >> 8), n3);
    }

    private static int blend_difference(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 > n7 ? n4 - n7 : n7 - n4;
        int n11 = n5 > n8 ? n5 - n8 : n8 - n5;
        int n12 = n6 > n9 ? n6 - n9 : n9 - n6;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_exclusion(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 + n7 - (n4 * n7 >> 7);
        int n11 = n5 + n8 - (n5 * n8 >> 7);
        int n12 = n6 + n9 - (n6 * n9 >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_multiply(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 * n7 >> 8;
        int n11 = n5 * n8 >> 8;
        int n12 = n6 * n9 >> 8;
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_screen(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = 255 - ((255 - n4) * (255 - n7) >> 8);
        int n11 = 255 - ((255 - n5) * (255 - n8) >> 8);
        int n12 = 255 - ((255 - n6) * (255 - n9) >> 8);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_overlay(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n4 < 128 ? n4 * n7 >> 7 : 255 - ((255 - n4) * (255 - n7) >> 7);
        int n11 = n5 < 128 ? n5 * n8 >> 7 : 255 - ((255 - n5) * (255 - n8) >> 7);
        int n12 = n6 < 128 ? n6 * n9 >> 7 : 255 - ((255 - n6) * (255 - n9) >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_hard_light(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 < 128 ? n4 * n7 >> 7 : 255 - ((255 - n4) * (255 - n7) >> 7);
        int n11 = n8 < 128 ? n5 * n8 >> 7 : 255 - ((255 - n5) * (255 - n8) >> 7);
        int n12 = n9 < 128 ? n6 * n9 >> 7 : 255 - ((255 - n6) * (255 - n9) >> 7);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_soft_light(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = (n4 * n7 >> 7) + (n4 * n4 >> 8) - (n4 * n4 * n7 >> 15);
        int n11 = (n5 * n8 >> 7) + (n5 * n5 >> 8) - (n5 * n5 * n8 >> 15);
        int n12 = (n6 * n9 >> 7) + (n6 * n6 >> 8) - (n6 * n6 * n9 >> 15);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_dodge(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 == 255 ? 255 : PImage.peg((n4 << 8) / (255 - n7));
        int n11 = n8 == 255 ? 255 : PImage.peg((n5 << 8) / (255 - n8));
        int n12 = n9 == 255 ? 255 : PImage.peg((n6 << 8) / (255 - n9));
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    private static int blend_burn(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 == 0 ? 0 : 255 - PImage.peg((255 - n4 << 8) / n7);
        int n11 = n8 == 0 ? 0 : 255 - PImage.peg((255 - n5 << 8) / n8);
        int n12 = n9 == 0 ? 0 : 255 - PImage.peg((255 - n6 << 8) / n9);
        return PImage.low(((n & 0xFF000000) >>> 24) + n3, 255) << 24 | PImage.peg(n4 + ((n10 - n4) * n3 >> 8)) << 16 | PImage.peg(n5 + ((n11 - n5) * n3 >> 8)) << 8 | PImage.peg(n6 + ((n12 - n6) * n3 >> 8));
    }

    protected static PImage loadTIFF(byte[] byArray) {
        if (byArray[42] != byArray[102] || byArray[43] != byArray[103]) {
            System.err.println(TIFF_ERROR);
            return null;
        }
        int n = (byArray[114] & 0xFF) << 24 | (byArray[115] & 0xFF) << 16 | (byArray[116] & 0xFF) << 8 | byArray[117] & 0xFF;
        int n2 = (byArray[30] & 0xFF) << 8 | byArray[31] & 0xFF;
        int n3 = (byArray[42] & 0xFF) << 8 | byArray[43] & 0xFF;
        if (n != n2 * n3 * 3) {
            System.err.println("Error: Processing can only read its own TIFF files. (" + n2 + ", " + n3 + ")");
            return null;
        }
        for (int i = 0; i < TIFF_HEADER.length; ++i) {
            if (i == 30 || i == 31 || i == 42 || i == 43 || i == 102 || i == 103 || i == 114 || i == 115 || i == 116 || i == 117 || byArray[i] == TIFF_HEADER[i]) continue;
            System.err.println("Error: Processing can only read its own TIFF files. (" + i + ")");
            return null;
        }
        PImage pImage = new PImage(n2, n3, 1);
        int n4 = 768;
        n /= 3;
        for (int i = 0; i < n; ++i) {
            pImage.pixels[i] = 0xFF000000 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
        }
        return pImage;
    }

    protected boolean saveTIFF(OutputStream outputStream) {
        try {
            byte[] byArray = new byte[768];
            System.arraycopy(TIFF_HEADER, 0, byArray, 0, TIFF_HEADER.length);
            byArray[30] = (byte)(this.width >> 8 & 0xFF);
            byArray[31] = (byte)(this.width & 0xFF);
            byArray[42] = byArray[102] = (byte)(this.height >> 8 & 0xFF);
            byArray[43] = byArray[103] = (byte)(this.height & 0xFF);
            int n = this.width * this.height * 3;
            byArray[114] = (byte)(n >> 24 & 0xFF);
            byArray[115] = (byte)(n >> 16 & 0xFF);
            byArray[116] = (byte)(n >> 8 & 0xFF);
            byArray[117] = (byte)(n & 0xFF);
            outputStream.write(byArray);
            for (int i = 0; i < this.pixels.length; ++i) {
                outputStream.write(this.pixels[i] >> 16 & 0xFF);
                outputStream.write(this.pixels[i] >> 8 & 0xFF);
                outputStream.write(this.pixels[i] & 0xFF);
            }
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected boolean saveTGA(OutputStream outputStream) {
        byte[] byArray = new byte[18];
        if (this.format == 4) {
            byArray[2] = 11;
            byArray[16] = 8;
            byArray[17] = 40;
        } else if (this.format == 1) {
            byArray[2] = 10;
            byArray[16] = 24;
            byArray[17] = 32;
        } else if (this.format == 2) {
            byArray[2] = 10;
            byArray[16] = 32;
            byArray[17] = 40;
        } else {
            throw new RuntimeException("Image format not recognized inside save()");
        }
        byArray[12] = (byte)(this.width & 0xFF);
        byArray[13] = (byte)(this.width >> 8);
        byArray[14] = (byte)(this.height & 0xFF);
        byArray[15] = (byte)(this.height >> 8);
        try {
            int n;
            outputStream.write(byArray);
            int n2 = this.height * this.width;
            int[] nArray = new int[128];
            if (this.format == 4) {
                int n3;
                for (n = 0; n < n2; n += n3) {
                    int n4;
                    int n5;
                    boolean bl = false;
                    n3 = 1;
                    nArray[0] = n5 = this.pixels[n] & 0xFF;
                    while (n + n3 < n2) {
                        if (n5 != (this.pixels[n + n3] & 0xFF) || n3 == 128) {
                            bl = n3 > 1;
                            break;
                        }
                        ++n3;
                    }
                    if (bl) {
                        outputStream.write(0x80 | n3 - 1);
                        outputStream.write(n5);
                        continue;
                    }
                    n3 = 1;
                    while (n + n3 < n2) {
                        n4 = this.pixels[n + n3] & 0xFF;
                        if ((n5 == n4 || n3 >= 128) && n3 >= 3) {
                            if (n5 != n4) break;
                            n3 -= 2;
                            break;
                        }
                        nArray[n3] = n5 = n4;
                        ++n3;
                    }
                    outputStream.write(n3 - 1);
                    for (n4 = 0; n4 < n3; ++n4) {
                        outputStream.write(nArray[n4]);
                    }
                }
            } else {
                while (n < n2) {
                    int n6;
                    boolean bl = false;
                    nArray[0] = n6 = this.pixels[n];
                    int n7 = 1;
                    while (n + n7 < n2) {
                        if (n6 != this.pixels[n + n7] || n7 == 128) {
                            bl = n7 > 1;
                            break;
                        }
                        ++n7;
                    }
                    if (bl) {
                        outputStream.write(0x80 | n7 - 1);
                        outputStream.write(n6 & 0xFF);
                        outputStream.write(n6 >> 8 & 0xFF);
                        outputStream.write(n6 >> 16 & 0xFF);
                        if (this.format == 2) {
                            outputStream.write(n6 >>> 24 & 0xFF);
                        }
                    } else {
                        int n8;
                        n7 = 1;
                        while (n + n7 < n2) {
                            if ((n6 == this.pixels[n + n7] || n7 >= 128) && n7 >= 3) {
                                if (n6 != this.pixels[n + n7]) break;
                                n7 -= 2;
                                break;
                            }
                            nArray[n7] = n6 = this.pixels[n + n7];
                            ++n7;
                        }
                        outputStream.write(n7 - 1);
                        if (this.format == 2) {
                            for (n8 = 0; n8 < n7; ++n8) {
                                n6 = nArray[n8];
                                outputStream.write(n6 & 0xFF);
                                outputStream.write(n6 >> 8 & 0xFF);
                                outputStream.write(n6 >> 16 & 0xFF);
                                outputStream.write(n6 >>> 24 & 0xFF);
                            }
                        } else {
                            for (n8 = 0; n8 < n7; ++n8) {
                                n6 = nArray[n8];
                                outputStream.write(n6 & 0xFF);
                                outputStream.write(n6 >> 8 & 0xFF);
                                outputStream.write(n6 >> 16 & 0xFF);
                            }
                        }
                    }
                    n += n7;
                }
            }
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected void saveImageIO(String string) throws IOException {
        try {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, this.format == 2 ? 2 : 1);
            bufferedImage.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
            File file = new File(string);
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("image save failed.");
        }
    }

    public void save(String string) {
        Object object;
        boolean bl = false;
        File file = new File(string);
        if (!file.isAbsolute()) {
            if (this.parent != null) {
                string = this.parent.savePath(string);
            } else {
                object = "PImage.save() requires an absolute path. Use createImage(), or pass savePath() to save().";
                PGraphics.showException((String)object);
            }
        }
        this.loadPixels();
        try {
            object = null;
            if (this.saveImageFormats == null) {
                this.saveImageFormats = ImageIO.getWriterFormatNames();
            }
            if (this.saveImageFormats != null) {
                for (int i = 0; i < this.saveImageFormats.length; ++i) {
                    if (!string.endsWith("." + this.saveImageFormats[i])) continue;
                    this.saveImageIO(string);
                    return;
                }
            }
            if (string.toLowerCase().endsWith(".tga")) {
                object = new BufferedOutputStream(new FileOutputStream(string), 32768);
                bl = this.saveTGA((OutputStream)object);
            } else {
                if (!string.toLowerCase().endsWith(".tif") && !string.toLowerCase().endsWith(".tiff")) {
                    string = string + ".tif";
                }
                object = new BufferedOutputStream(new FileOutputStream(string), 32768);
                bl = this.saveTIFF((OutputStream)object);
            }
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        if (!bl) {
            throw new RuntimeException("Error while saving image.");
        }
    }
}

