#include <QtGui/QApplication>

#include "Song.h"
#include "TitleScreen.h"
#include "VuvuzelaHero.h"

#ifdef SDLAUDIO
    #include "SDLSupport.h"
    
    //Necessary on Windows
    #ifdef main
        #undef main
    #endif
#endif


int main(int argc, char** argv)
{
    QApplication app(argc, argv);
    
    Song::loadCache();
    
#ifdef SDLAUDIO
    if(!initializeSDLAudio()){
        QMessageBox::warning(0, "Vuvuzela Hero", "Failed to initialize SDL audio output, please see console output for details");
        return -1;
    }
#endif
    
    VuvuzelaHero vuvuzelaHero;
    
    //TODO: We need settings dialog or something similar
    vuvuzelaHero.setFixedSize(QSize(1024, 600));
    vuvuzelaHero.show();
    if(!vuvuzelaHero.initialize()){
        vuvuzelaHero.close();
        QMessageBox::warning(0, "Vuvuzela Hero", "Initialization failed, please see console output for details");
        return -1;
    }
    TitleScreen* ts = new TitleScreen();
    vuvuzelaHero.setScene(ts);
    
    return app.exec();
}
