#ifndef Vuvuzela_H
#define Vuvuzela_H

#include <QtCore>

#ifndef SDLAUDIO
    #include <phonon/audiooutput.h>
    #include <phonon/mediaobject.h>
    #include <phonon/volumefadereffect.h>
#else
    #include "SDLSupport.h"
#endif

class Vuvuzela : public QObject
{
Q_OBJECT
public:
    Vuvuzela();
    ~Vuvuzela();
    
public slots:
    void play(int note);
    void delayedStop(int ms = 50);
    void stop();
    
protected slots:
    void aboutToFinish();
    
private:
    #ifndef SDLAUDIO
    Phonon::MediaObject* m_object;
    Phonon::AudioOutput* m_output;
    Phonon::Path m_path;
    #else
    SDLAudioObject* m_audios[4];
    #endif
    
    int m_note;
};

#endif // Vuvuzela_H