#include "Song.h"

#include <QtCore>

bool Song::loadFile(QString& filename)
{
    beats.clear();
    
    QFile file(filename);
    
    if(!file.open(QIODevice::ReadOnly)){
        qErrnoWarning("Failed to open file '%s'",filename.toStdString().c_str());
        return false;
    }
    
    int line_n = 1;
    
    QTextStream stream ( &file );
    QString line = stream.readLine();
    while(line.length() > 0){
        QStringList list = line.split(" ");
        if(list.size() > 1){
            QString key = list[0];
            if(key == "NAME"){
                list.erase(list.begin());
                name = list.join(" ");
            } else if(key == "BPM"){
                bpm = list[1].toInt();
            } else if(key == "DIFFICULTY"){
                QString value = list[1];
                if(value == "EASY")
                    difficulty = EASY;
                else if(value == "MEDIUM")
                    difficulty = MEDIUM;
                else if(value == "HARD")
                    difficulty = HARD;
                else if(value == "INSANE")
                    difficulty = INSANE;
                else {
                    qDebug() << "Syntax error in " << filename << "on line " << line_n;
                    goto fail;
                }
            } else {
                qDebug() << "Syntax error in " << filename << "on line " << line_n;
                goto fail;
            }
        } else {
            int note = line.toInt();
            if(note < 0 || note > 4){
                qDebug() << "Syntax error in " << filename << "on line " << line_n;
                goto fail;
            }
            
            beats.append(note);
        }
        ++line_n;
        
        line = stream.readLine();
    }
    if(beats.size() == 0)
        beats.append(0);
    
    this->filename = filename;
    
    file.close();
    return true;
    
fail:
    file.close();
    return false;
}

bool Song::saveFile()
{
    QFile file(filename);
    
    if(!file.open(QIODevice::WriteOnly)){
        qErrnoWarning("Failed to open file '%s'",filename.toStdString().c_str());
        return false;
    }
    QTextStream stream(&file);
    
    stream << "NAME " << name;
    endl(stream);
    
    stream << "BPM " << bpm;
    endl(stream);
    
    QString diff;
    switch(difficulty){
    case EASY:
        diff = "EASY";
        break;
    case MEDIUM:
        diff = "MEDIUM";
        break;
    case HARD:
        diff = "HARD";
        break;
    case INSANE:
        diff = "INSANE";
        break;
    }
    stream << "DIFFICULTY " << diff;
    endl(stream);
    
    QList<int>::iterator it = beats.begin();
    while(it != beats.end()){
        stream << *it;
        endl(stream);
        ++it;
    }
    
    return true;
}

void Song::loadCache()
{
    qDebug() << "Loading song cache";
    QDirIterator it("songs/");
    while (it.hasNext()) {
        //qDebug() << it.next();
        QString filename = it.next();
        if(filename.endsWith(".song")){
            Song song;
            if(song.loadFile(filename)){
                qDebug() << "Song " << song.name << " loaded";
                if(cache.size() == 0)
                    cache.append(song);
                else {
                    QList<Song>::iterator sit = cache.begin();
                    while(sit != cache.end()){
                        if(sit->difficulty > song.difficulty)
                            break;
                        ++sit;
                    }
                    cache.insert(sit, song);
                }
            }
        }
    }
}


QList<Song>Song::cache;