#ifndef MainMenu_H
#define MainMenu_H

#include <QtGui>

#include "BGSpinner.h"
#include "SceneBase.h"

class MainMenu : public SceneBase
{
Q_OBJECT
public:
    MainMenu(BGSpinner* spinner = new BGSpinner());
    ~MainMenu();
    
    void start();
    void stop();

public slots:
    virtual void keyPressEvent(QKeyEvent*);
    virtual void paint(QSize size);
    
protected slots:
    void timeout();
    
private:
    QTimer m_timer;
    QTime m_time;
    BGSpinner* m_spinner;
    
    int m_selected;
    
    enum Item { START_GAME, SONG_EDITOR, EXIT };
    
    void startItem(Item item);
    QString itemToText(Item item);
    
    QList<Item>m_items;
};

#endif // MainMenu_H