#include "Game.h"

#include "MainMenu.h"

#include "VuvuzelaHero.h"

#include <phonon/audiooutput.h>

Game::Game() : m_beat_succeeded(true), m_score(0), m_combo(0), m_missHilight(false), m_factorHilight(false), m_ask_exit(false)
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
}


Game::~Game()
{

}

void Game::start()
{
    beat = -10;
    m_timer.start(20);
    m_spinner.start();
}

void Game::stop()
{

}

void Game::timeout()
{
    vuvuzelaHero->updateGL();
    
    if(m_ask_exit)
        return;
    
    beat += 20/1000.0/60.0 * song->bpm;
    
    //We are finished, gtfo
    if(floor(beat) == song->beats.size() + 9){
        vuvuzelaHero->setScene(new MainMenu());
        return;
    }
    
    if(beat > song->beats.size()){
        m_vuvuzela.delayedStop();
        note = 0;
    }
    
    if(beat > 0 && beat < song->beats.size()){
        int& current_note = song->beats[(int)floor(beat)];
        //int& last_note = (beat > 1 ? song->beats[(int)floor(beat) - 1] : current_note);
        int& next_note = (beat < song->beats.size() - 2 ? song->beats[(int)floor(beat) + 1] : current_note);
        
        //We are closer to the next beat than current one
        if(m_lastbeat - floor(m_lastbeat) < .5 && beat - floor(beat) >= .5){
            
            //Beat failed, that it sure
            if(!m_beat_succeeded){
                if(m_combo > 0){
                    m_combo = 0;
                    m_missHilight = true;
                    QTimer::singleShot(1000, this, SLOT(stopHilight()));
                }
                qDebug() << "failed beat";
            }
            
            if(next_note == 0 || note == next_note)
                m_beat_succeeded = true;
            else
                m_beat_succeeded = false;
        }
        
        //Beat changed
        if(floor(beat) > floor(m_lastbeat)){
            
            //Wrong note playing
            if(current_note != note && note > 0){
                m_vuvuzela.delayedStop();
                note = 0;
            }
        }
        
        if(current_note > 0 && note == current_note){
            m_score += (beat - m_lastbeat) * 100 * factor();
            
        }
    }
    
    m_lastbeat = beat;
}

void Game::stopHilight()
{
    m_factorHilight = false;
    m_missHilight = false;
}

int Game::factor(){
    return (m_combo + 10) / 10;
}

void Game::keyPressEvent(QKeyEvent* e)
{
    if(e->isAutoRepeat())
        return;
    
    if(m_ask_exit && e->key() == Qt::Key_Y){
        vuvuzelaHero->setScene(new MainMenu());
        return;
    }
    if(m_ask_exit){
        m_ask_exit = false;
        return;
    }
    
    if(e->key() == Qt::Key_Escape){
        m_ask_exit = true;
        return;
    }

    int oldnote = note;
    if(e->key() == Qt::Key_1)
        note = 1;
    if(e->key() == Qt::Key_2 && song->difficulty > Song::EASY)
        note = 2;
    if(e->key() == Qt::Key_3 && song->difficulty > Song::MEDIUM)
        note = 3;
    if(e->key() == Qt::Key_4 && song->difficulty > Song::HARD)
        note = 4;
    
    if(note != oldnote && floor(beat) < song->beats.size() - 1)
        noteSwitch(oldnote);
}

void Game::keyReleaseEvent(QKeyEvent* e)
{
    if(e->isAutoRepeat())
        return;
    
    if(m_ask_exit)
        return;
    
    if(floor(beat) >= song->beats.size())
        return;
    
    if((e->key() == Qt::Key_1 && note == 1)
    || (e->key() == Qt::Key_2 && note == 2)
    || (e->key() == Qt::Key_3 && note == 3)
    || (e->key() == Qt::Key_4 && note == 4)){
        int oldnote = note;
        note = 0;
        noteSwitch(oldnote);
    }
}

void Game::paint(QSize size)
{
    /*switch(note){
    case 0:
        glClearColor(0.9, 0.4, 0.0, 1.0);
        break;
    case 1:
        glClearColor(0.0, 1.0, 0.0, 1.0);
        break;
    case 2:
        glClearColor(0.0, 0.0, 1.0, 1.0);
        break;
    case 3:
        glClearColor(1.0, 0.0, 0.0, 1.0);
        break;
    case 4:
        glClearColor(1.0, 1.0, 0.0, 1.0);
        break;
    }*/
    
    glClearColor(0.9, 0.4, 0.0, 1.0);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    
    m_spinner.paint(size);
    
    paintField(size);
    
    glColor3f(0.8,1,1);
    
    QPainter p;
    p.begin(vuvuzelaHero);
    
    p.setFont(QFont("Sans", 30, QFont::Bold));
    p.setPen(QPen(QColor(200,120,0)));
    
    QString score;
    QTextStream stream(&score);
    stream << m_score;
    
    vuvuzelaHero->drawText(p, QPoint(size.width() - p.fontMetrics().width("000000000"), p.fontMetrics().height()), score);
    
    QString combo;
    stream.setString(&combo);
    stream << m_combo << " hit";
    
    p.setFont(QFont("Sans", 30, QFont::Bold));
    
    vuvuzelaHero->drawText(p, QPoint(10, p.fontMetrics().height()), combo);
    
    
    QString factorstr;
    stream.setString(&factorstr);
    stream << factor() << "x";
    
    p.setFont(QFont("Sans", 30, QFont::Bold));
    
    vuvuzelaHero->drawText(p, QPoint(10, p.fontMetrics().height() * 2 + 10), factorstr);
    
        
    p.setFont(QFont("Sans", 60, QFont::Bold));
    
    if(m_missHilight){
        
        int x = size.width() / 2 - p.fontMetrics().width("MISSED") / 2;
        int y = 100;
        
        vuvuzelaHero->drawText(p, QPoint(x,y), "MISSED");

    } else if(m_factorHilight){
        
        vuvuzelaHero->drawText(p, QPoint(size.width() / 2 - p.fontMetrics().width(factorstr) / 2, 100), factorstr);
    }
    
    if(m_ask_exit){
        p.fillRect(QRect(0,0,size.width(),size.height()),QBrush(QColor(0,0,0,200)));
        vuvuzelaHero->drawText(p, QPoint(size.width() / 2 - p.fontMetrics().width("Really Quit? (y)") / 2, 
                                         size.height() / 2 - p.fontMetrics().height() / 2), "Really Quit? (y)");
    }
    
    p.end();
}

void Game::noteSwitch(int oldnote){
    
    if(beat < 0 ||beat > song->beats.size() - 1){
        note = 0;
        m_vuvuzela.stop();
        return;
    }
    
    int& current_note = song->beats[(int)floor(beat)];
    int& last_note = (floor(beat) > 0 ? song->beats[(int)floor(beat) - 1] : current_note);
    int& next_note = (beat < song->beats.size() - 2 ? song->beats[(int)floor(beat) + 1] : current_note);
    
    int32_t beatoffset = (beat - round(beat)) * (60.0 / song->bpm) * 1000;
    
    //Not changed
    if(note == oldnote)
        return;
    
    if(note > song->difficulty){
        note = 0;
    }
    
    //qDebug() << beatoffset << note << last_note << current_note << next_note;
    
    //Obviously we won't play anything when nothing should be played
    if((beatoffset > 0 ? current_note : next_note) == 0){
        note = 0;
    }
    
    //Trying to start longer stroke in the middle, no good
    if(current_note == last_note){
        note = 0;
    }
    
    //Incorrect note
    if(note > 0 && note != (beatoffset > 0 ? current_note : next_note)){
        note = 0;
    }
    
    //No note selected or wrong note
    if(note == 0){
        m_vuvuzela.delayedStop();
        
        //If longer stroke, break it
        if(current_note != 0 && next_note == current_note){
            m_beat_succeeded = false;
        }
        return;
    }
    
    int oldfactor = factor();
    ++m_combo;
    if(factor() > oldfactor){
        m_factorHilight = true;
        QTimer::singleShot(1000, this, SLOT(stopHilight()));
    }
    
    m_vuvuzela.play(note);
    
    m_score += 100 * factor();
    
    m_beat_succeeded = true;
}






#include "Game.moc"