#include "BGSpinner.h"


BGSpinner::BGSpinner() : m_rotation(0)
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
}
BGSpinner::~BGSpinner()
{
}

void BGSpinner::paint(QSize size){
    glDisable(GL_DEPTH_TEST);
    
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glOrtho(-1.0 * (size.width()/(double)size.height()), 1.0 * (size.width()/(double)size.height()), 0.0, 2.0, -1.0, 1.0);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    glEnable(GL_BLEND);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    glRotated(m_rotation, 0, 0, 1);
    
    bool darklast = false;
    
    for(double i = 0; i < 360; i += 22.5){
      
    
      if(darklast){
        glColor4f(1.0, .68, 0.0, .2);
        darklast = false;
      } else {
        glColor4f(0.66, 0.5, 0.0, .2);
        darklast = true;
      }
      
      glPushMatrix();
      
      glRotatef(i, 0, 0, 1);
      
      glBegin(GL_TRIANGLES);

      glVertex2f(0,0);
      glVertex2f(0.8,4);
      glVertex2f(-0.8,4);

      glEnd();
      
      glPopMatrix();

    }
    glDisable(GL_BLEND);
}


void BGSpinner::start(){
    m_timer.start(25);
}

void BGSpinner::stop(){
}

void BGSpinner::timeout(){
    m_rotation -= .25;
}

#include "BGSpinner.moc"