uniform vec4 lightVector;
/*

void main( void )
{
	bool hastangents=true;

    vec3 tangent;						//don't care about normal, just about tangent
    vec3 vnormal;
    vec3 color;
    
    if(!hastangents)
    {
		tangent.x = 0.0;
		tangent.y = 1.0;
		tangent.z = 0.0;
		//get a normal across the surface, in direction of tmp norm, let's try that:
		vec3 n2 = cross( tangent, gl_Normal );
		tangent = normalize( cross( gl_Normal, n2 ) );
    }else
    {
		gl_TexCoord[0]  = gl_MultiTexCoord0;
		tangent.x = gl_TexCoord[0].x;
		tangent.y = gl_TexCoord[0].y;
		tangent.z = gl_TexCoord[0].z;
		tangent = normalize(tangent);
    }

    
	// Transform the tangent/normal vector using only the rotational portion of the 
	// full inverse model-view matrix.
	tangent = gl_NormalMatrix * tangent;
	vnormal = gl_NormalMatrix * gl_Normal;
    
	// Compute world-space position and
	// Create a normalized vector pointing from vertex to eye
	
	vec4 worldSpacePos =  gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
	vec4 vertToEye = normalize( worldSpacePos );

	//
	// This is where we use our texture as a look up table for anisotropic 
	// lighting.
	//
	// h = normalize(l + e)
	vec3 halfAngle = normalize( vertToEye + lightVector );
	
	gl_TexCoord[0].x = .5+ .49* dot(lightVector, tangent);
	gl_TexCoord[0].y = .5- .49* dot(halfAngle , tangent);

	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_Position.x += vnormal.x/8.0;
	gl_Position.y += vnormal.y/8.0;
	gl_Position.z += vnormal.z/8.0;

	lightVector.z = 0.0-lightVector.z;		//HACK, cuz our fustrum is inversed
	
	gl_FrontColor = gl_Color * max(.0 ,1. * dot(lightVector, vnormal));		//and we add some shadows to it :)
	
	//add fresnel
	{
		float f = 1.0+ dot(vertToEye, vnormal);		//[-1..0/.1] -> [0..1/.2]
		f*=f;
		gl_FrontColor += gl_Color * f;
	}
}
*/

//-----------------------------------------

vec3 vnormal;
vec4 vertToEye;


void addFresnel()
{
	vec4 white=vec4(1,1,1,1);
	
	float f = 1.0+ dot(vertToEye, vnormal);		//[-1..0/.1] -> [0..1/.2]
	f*=f;
	gl_FrontColor += white * f;
}

void addLighting()
{
	vec4 lv = lightVector;
//	lv.z = 0.0-lv.z;		//HACK, cuz our fustrum is inversed
	
	vec4 white=vec4(1,1,1,1);
	
	gl_FrontColor = white * max(.0 ,1. * dot(lv, vnormal));		//and we add some shadows to it :)
}


void main()
{
    vec3 tangent;						//don't care about normal, just about tangent
    
    tangent = gl_Color.rgb;
	tangent = normalize(tangent);
	
	// Transform the tangent/normal vector using only the rotational portion of the 
	// full inverse model-view matrix.
	tangent = gl_NormalMatrix * tangent;
	vnormal = gl_NormalMatrix * gl_Normal;
    
	// Compute world-space position and
	// Create a normalized vector pointing from vertex to eye
	
	vec4 worldSpacePos =  gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
	vertToEye = normalize( worldSpacePos );

	// This is where we use our texture as a look up table for anisotropic 
	// lighting.	h = normalize(l + e)
	
	vec4 lv = lightVector;
//	lv.z = 0.0-lv.z;		//HACK, cuz our fustrum is inversed
	vec3 halfAngle = normalize( vertToEye + lv );
	
	gl_TexCoord[1].x = .5+ 0.49* dot(lightVector, tangent);
	gl_TexCoord[1].y = .5- 0.49* dot(halfAngle , tangent);
	

	//--for texture 0------
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;


	addLighting();
//	addFresnel();
}