uniform vec4 eyePosition;
uniform vec4 lightVector;

void main( void )
{
	bool hastangents=false;

    vec3 tangent;						//don't care about normal, just about tangent
    vec3 vnormal;
    
    if(!hastangents)
    {
		tangent.x = 0.0;
		tangent.y = 1.0;
		tangent.z = 0.0;
	    
		//get a normal across the surface, in direction of tmp norm, let's try that:
		vec3 n2 = cross( tangent, gl_Normal );
		tangent = normalize( cross( gl_Normal, n2 ) );
    }else
    {
		tangent.x = gl_TexCoord[0].x;
		tangent.y = gl_TexCoord[0].y;
		tangent.z = gl_TexCoord[0].z;
    }
    
	// Transform the tangent/normal vector using only the rotational portion of the 
	// full inverse model-view matrix.
    tangent = gl_NormalMatrix * tangent;
	vnormal = gl_NormalMatrix * gl_Normal;
    
	//HACK: our cam has inverted Z so we gotta do this to look rigt
	vnormal.z = -vnormal.z;
	
    vec4 worldNormal;
    worldNormal.x = tangent.x;
    worldNormal.y = tangent.y;
    worldNormal.z = tangent.z;
    worldNormal.w = 0.0;

	// Compute world-space position
	vec4 worldSpacePos = gl_ModelViewMatrix * gl_Vertex;

	// Create a normalized vector pointing from vertex to eye
	vec4 vertToEye = normalize( eyePosition - worldSpacePos );

	// h = normalize(l + e)
	vec4 halfAngle = normalize( vertToEye + lightVector );

	//
	// This is where we use our texture as a look up table for anisotropic 
	// lighting.
	//

	vec4 lv3;
	lv3.x = lightVector.x;
	lv3.y = lightVector.y;
	lv3.z = lightVector.z;
	
	lv3 = gl_ModelViewMatrix * lv3;
	lv3.z= -lv3.z;

	gl_TexCoord[0].x = .5+ .49* dot(lv3, worldNormal);
	gl_TexCoord[0].y = .5+ .49* -dot(halfAngle , worldNormal);

	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    gl_FrontColor = gl_Color * 2* dot(lv3, vnormal);		//and we add some shadows to it :)
}
