uniform vec4 lightVector;

vec3 vnormal;
vec4 vertToEye;

void addLighting()
{
	vec4 lv = lightVector;
	
	vec4 white=vec4(1,1,1,1);
	
	gl_FrontColor = white * max(.0 ,1. * dot(-lv.xyz, vnormal));		//and we add some shadows to it :)
}


void main()
{
    vec3 tangent;						//don't care about normal, just about tangent
    
    tangent = gl_Color.rgb;
	tangent = normalize(tangent);
	
	// Transform the tangent/normal vector using only the rotational portion of the 
	// full inverse model-view matrix.
	tangent = gl_NormalMatrix * tangent;
	vnormal = gl_NormalMatrix * gl_Normal;
    
	// Compute world-space position and
	// Create a normalized vector pointing from vertex to eye
	
	vec4 worldSpacePos =  gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
	vertToEye = normalize( worldSpacePos );

	// This is where we use our texture as a look up table for anisotropic 
	// lighting.	h = normalize(l + e)
	
	vec4 halfAngle = normalize( lightVector + vertToEye );
	
	gl_TexCoord[1].x = .5+ 0.49* dot( lightVector.xyz, tangent );
	gl_TexCoord[1].y = .5+ 0.49* dot(   halfAngle.xyz, tangent );
	

	//--for texture 0------
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;


	addLighting();
}