/*
 * Decompiled with CFR 0.152.
 */
package org.jouvieje.Fmod.Misc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jouvieje.Fmod.Misc.BufferUtilsJNI;
import org.jouvieje.Fmod.Misc.Pointer;
import org.jouvieje.Fmod.Misc.PointerUtilsJNI;
import org.jouvieje.Fmod.Misc.SizeOfPrimitive;

public class BufferUtils
implements SizeOfPrimitive {
    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static CharBuffer newCharBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 2);
        return byteBuffer.asCharBuffer();
    }

    public static ShortBuffer newShortBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 2);
        return byteBuffer.asShortBuffer();
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 8);
        return byteBuffer.asLongBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asFloatBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 8);
        return byteBuffer.asDoubleBuffer();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = BufferUtils.newByteBuffer(byteBuffer.capacity());
        byteBuffer.rewind();
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = BufferUtils.newShortBuffer(shortBuffer.capacity());
        shortBuffer.rewind();
        shortBuffer2.put(shortBuffer);
        return shortBuffer2;
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = BufferUtils.newIntBuffer(intBuffer.capacity());
        intBuffer.rewind();
        intBuffer2.put(intBuffer);
        return intBuffer2;
    }

    public static LongBuffer copyLongBuffer(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = BufferUtils.newLongBuffer(longBuffer.capacity());
        longBuffer.rewind();
        longBuffer2.put(longBuffer);
        return longBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = BufferUtils.newFloatBuffer(floatBuffer.capacity());
        floatBuffer.rewind();
        floatBuffer2.put(floatBuffer);
        return floatBuffer2;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = BufferUtils.newDoubleBuffer(doubleBuffer.capacity());
        doubleBuffer.rewind();
        doubleBuffer2.put(doubleBuffer);
        return doubleBuffer2;
    }

    public static int getCapacityInBytes(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return buffer.capacity();
        }
        if (buffer instanceof CharBuffer) {
            return buffer.capacity() * 2;
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.capacity() * 2;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.capacity() * 4;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.capacity() * 8;
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.capacity() * 4;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.capacity() * 8;
        }
        return -1;
    }

    public static int getPositionInBytes(Buffer buffer) {
        if (buffer != null) {
            if (buffer instanceof ByteBuffer) {
                return buffer.position();
            }
            if (buffer instanceof CharBuffer) {
                return buffer.position() * 2;
            }
            if (buffer instanceof ShortBuffer) {
                return buffer.position() * 2;
            }
            if (buffer instanceof IntBuffer) {
                return buffer.position() * 4;
            }
            if (buffer instanceof LongBuffer) {
                return buffer.position() * 8;
            }
            if (buffer instanceof FloatBuffer) {
                return buffer.position() * 4;
            }
            if (buffer instanceof DoubleBuffer) {
                return buffer.position() * 8;
            }
        }
        return -1;
    }

    public static String toString(ByteBuffer byteBuffer) {
        long l = BufferUtilsJNI.getBufferAddress(byteBuffer, BufferUtils.getPositionInBytes(byteBuffer));
        return l == 0L ? null : PointerUtilsJNI.Pointer_toString(l);
    }

    public static String toString(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.position(n3 + n);
        byteBuffer.get(byArray, 0, n2);
        byteBuffer.rewind();
        byteBuffer.position(n3);
        return new String(byArray);
    }

    public static void putString(ByteBuffer byteBuffer, String string) {
        byteBuffer.put(string.getBytes());
        BufferUtilsJNI.writeNullTerminal(byteBuffer, BufferUtils.getPositionInBytes(byteBuffer));
    }

    public static Pointer toPointer(Buffer buffer) {
        long l = BufferUtilsJNI.getBufferAddress(buffer, BufferUtils.getPositionInBytes(buffer));
        return l == 0L ? null : new Pointer(l);
    }
}

