/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Math;
import idx3d.idx3d_Matrix;

public class idx3d_Vector {
    public float x;
    public float y;
    public float z;
    public float r;
    public float theta;

    public static idx3d_Vector vectorProduct(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3, idx3d_Vector idx3d_Vector4) {
        return idx3d_Vector.vectorProduct(idx3d_Vector.sub(idx3d_Vector3, idx3d_Vector2), idx3d_Vector.sub(idx3d_Vector4, idx3d_Vector2));
    }

    public static idx3d_Vector random(float f) {
        return new idx3d_Vector(f * idx3d_Math.random(), f * idx3d_Math.random(), f * idx3d_Math.random());
    }

    public idx3d_Vector normalize() {
        float f = this.length();
        if (f == 0.0f) {
            return this;
        }
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public void buildCylindric() {
        this.r = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        this.theta = (float)Math.atan2(this.x, this.y);
    }

    public String toString() {
        return new String("<vector x=" + this.x + " y=" + this.y + " z=" + this.z + ">\r\n");
    }

    public void buildCartesian() {
        this.x = this.r * idx3d_Math.cos(this.theta);
        this.y = this.r * idx3d_Math.sin(this.theta);
    }

    public static idx3d_Vector add(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3) {
        return new idx3d_Vector(idx3d_Vector2.x + idx3d_Vector3.x, idx3d_Vector2.y + idx3d_Vector3.y, idx3d_Vector2.z + idx3d_Vector3.z);
    }

    public idx3d_Vector() {
    }

    public idx3d_Vector(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public static float len(idx3d_Vector idx3d_Vector2) {
        return (float)Math.sqrt(idx3d_Vector2.x * idx3d_Vector2.x + idx3d_Vector2.y * idx3d_Vector2.y + idx3d_Vector2.z * idx3d_Vector2.z);
    }

    public static float angle(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3) {
        idx3d_Vector2.normalize();
        idx3d_Vector3.normalize();
        return idx3d_Vector2.x * idx3d_Vector3.x + idx3d_Vector2.y * idx3d_Vector3.y + idx3d_Vector2.z * idx3d_Vector3.z;
    }

    public idx3d_Vector reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public static idx3d_Vector sub(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3) {
        return new idx3d_Vector(idx3d_Vector2.x - idx3d_Vector3.x, idx3d_Vector2.y - idx3d_Vector3.y, idx3d_Vector2.z - idx3d_Vector3.z);
    }

    public static idx3d_Vector getNormal(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3) {
        return idx3d_Vector.vectorProduct(idx3d_Vector2, idx3d_Vector3).normalize();
    }

    public static idx3d_Vector getNormal(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3, idx3d_Vector idx3d_Vector4) {
        return idx3d_Vector.vectorProduct(idx3d_Vector2, idx3d_Vector3, idx3d_Vector4).normalize();
    }

    public idx3d_Vector transform(idx3d_Matrix idx3d_Matrix2) {
        float f = this.x * idx3d_Matrix2.m00 + this.y * idx3d_Matrix2.m01 + this.z * idx3d_Matrix2.m02 + idx3d_Matrix2.m03;
        float f2 = this.x * idx3d_Matrix2.m10 + this.y * idx3d_Matrix2.m11 + this.z * idx3d_Matrix2.m12 + idx3d_Matrix2.m13;
        float f3 = this.x * idx3d_Matrix2.m20 + this.y * idx3d_Matrix2.m21 + this.z * idx3d_Matrix2.m22 + idx3d_Matrix2.m23;
        return new idx3d_Vector(f, f2, f3);
    }

    public idx3d_Vector getClone() {
        return new idx3d_Vector(this.x, this.y, this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static idx3d_Vector scale(float f, idx3d_Vector idx3d_Vector2) {
        return new idx3d_Vector(f * idx3d_Vector2.x, f * idx3d_Vector2.y, f * idx3d_Vector2.z);
    }

    public static idx3d_Vector vectorProduct(idx3d_Vector idx3d_Vector2, idx3d_Vector idx3d_Vector3) {
        return new idx3d_Vector(idx3d_Vector2.y * idx3d_Vector3.z - idx3d_Vector3.y * idx3d_Vector2.z, idx3d_Vector2.z * idx3d_Vector3.x - idx3d_Vector3.z * idx3d_Vector2.x, idx3d_Vector2.x * idx3d_Vector3.y - idx3d_Vector3.x * idx3d_Vector2.y);
    }
}

