/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Object;
import idx3d.idx3d_Scene;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class idx3d_3ds_Importer {
    private int currentJunkId;
    private int nextJunkOffset;
    private idx3d_Scene scene;
    private String currentObjectName;
    private idx3d_Object currentObject;
    private boolean endOfStream;

    public void importFromURL(URL uRL, idx3d_Scene idx3d_Scene2) throws IOException {
        this.importFromStream(uRL.openStream(), idx3d_Scene2);
    }

    private float readFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(this.readInt(inputStream));
    }

    private int readShort(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8;
    }

    private void readPointList(InputStream inputStream) throws IOException {
        int n = this.readShort(inputStream);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readShort(inputStream);
            int n4 = this.readShort(inputStream);
            int n5 = this.readShort(inputStream);
            this.readShort(inputStream);
            this.currentObject.addTriangle(this.currentObject.vertex(n3), this.currentObject.vertex(n4), this.currentObject.vertex(n5));
            ++n2;
        }
    }

    private void readNextJunk(InputStream inputStream) throws IOException {
        this.readJunkHeader(inputStream);
        if (this.currentJunkId == 15677) {
            return;
        }
        if (this.currentJunkId == 16384) {
            this.currentObjectName = this.readString(inputStream);
            System.out.println(">> Importing object: " + this.currentObjectName);
            return;
        }
        if (this.currentJunkId == 16640) {
            this.currentObject = new idx3d_Object();
            this.scene.addObject(this.currentObjectName, this.currentObject);
            return;
        }
        if (this.currentJunkId == 16656) {
            this.readVertexList(inputStream);
            return;
        }
        if (this.currentJunkId == 16672) {
            this.readPointList(inputStream);
            return;
        }
        if (this.currentJunkId == 16704) {
            this.readMappingCoordinates(inputStream);
            return;
        }
        this.skipJunk(inputStream);
    }

    private void skipJunk(InputStream inputStream) throws IOException, OutOfMemoryError {
        int n = 0;
        while (n < this.nextJunkOffset - 6 && !this.endOfStream) {
            this.endOfStream = inputStream.read() < 0;
            ++n;
        }
    }

    private void readVertexList(InputStream inputStream) throws IOException {
        int n = this.readShort(inputStream);
        int n2 = 0;
        while (n2 < n) {
            float f = this.readFloat(inputStream);
            float f2 = this.readFloat(inputStream);
            float f3 = this.readFloat(inputStream);
            this.currentObject.addVertex(f, -f2, f3);
            ++n2;
        }
    }

    private void readJunkHeader(InputStream inputStream) throws IOException {
        this.currentJunkId = this.readShort(inputStream);
        this.nextJunkOffset = this.readInt(inputStream);
        this.endOfStream = this.currentJunkId < 0;
    }

    private void readMappingCoordinates(InputStream inputStream) throws IOException {
        int n = this.readShort(inputStream);
        int n2 = 0;
        while (n2 < n) {
            this.currentObject.vertex((int)n2).u = this.readFloat(inputStream);
            this.currentObject.vertex((int)n2).v = this.readFloat(inputStream);
            ++n2;
        }
    }

    private int readInt(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importFromStream(InputStream inputStream, idx3d_Scene idx3d_Scene2) {
        System.out.println(">> Importing scene from 3ds stream ...");
        this.scene = idx3d_Scene2;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            this.readJunkHeader(bufferedInputStream);
            if (this.currentJunkId != 19789) {
                System.out.println("Error: This is no valid 3ds file.");
                return;
            }
            while (true) {
                if (this.endOfStream) {
                    return;
                }
                this.readNextJunk(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private String readString(InputStream inputStream) throws IOException {
        byte by;
        String string = new String();
        while ((by = (byte)inputStream.read()) != 0) {
            string = string + (char)by;
        }
        return string;
    }
}

