/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Win32DisplayPeerInfo;
import org.lwjgl.opengl.Win32PbufferPeerInfo;

final class Win32Display
implements DisplayImplementation {
    private static Win32DisplayPeerInfo peer_info;

    Win32Display() {
    }

    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        this.nCreateWindow(mode, fullscreen, x, y);
        peer_info.initDC();
    }

    private native void nCreateWindow(DisplayMode var1, boolean var2, int var3, int var4) throws LWJGLException;

    public native void destroyWindow();

    public native void switchDisplayMode(DisplayMode var1) throws LWJGLException;

    public native void resetDisplayMode();

    public native int getGammaRampLength();

    public native void setGammaRamp(FloatBuffer var1) throws LWJGLException;

    public native String getAdapter();

    public native String getVersion();

    public native DisplayMode init() throws LWJGLException;

    public native void setTitle(String var1);

    public native boolean isCloseRequested();

    public native boolean isVisible();

    public native boolean isActive();

    public native boolean isDirty();

    public PeerInfo createPeerInfo(PixelFormat pixel_format) throws LWJGLException {
        peer_info = new Win32DisplayPeerInfo(pixel_format);
        return peer_info;
    }

    public void update() {
        this.nUpdate();
        if (this.didMaximize()) {
            try {
                if (Display.getContext().isCurrent()) {
                    Display.getContext().makeCurrent();
                }
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Exception occurred while trying to make context current: " + e);
            }
        }
    }

    private native void nUpdate();

    private native boolean didMaximize();

    public native void reshape(int var1, int var2, int var3, int var4);

    public native DisplayMode[] getAvailableDisplayModes() throws LWJGLException;

    public native boolean hasWheel();

    public native int getButtonCount();

    public native void createMouse() throws LWJGLException;

    public native void destroyMouse();

    public native void pollMouse(IntBuffer var1, ByteBuffer var2);

    public native int readMouse(IntBuffer var1, int var2);

    public native void grabMouse(boolean var1);

    public int getNativeCursorCapabilities() {
        return 1;
    }

    public native void setCursorPosition(int var1, int var2);

    public native void setNativeCursor(Object var1) throws LWJGLException;

    public native int getMinCursorSize();

    public native int getMaxCursorSize();

    public native void createKeyboard() throws LWJGLException;

    public native void destroyKeyboard();

    public native void pollKeyboard(ByteBuffer var1);

    public native int readKeyboard(IntBuffer var1, int var2);

    public native int isStateKeySet(int var1);

    public native ByteBuffer nCreateCursor(int var1, int var2, int var3, int var4, int var5, IntBuffer var6, int var7, IntBuffer var8, int var9) throws LWJGLException;

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        return this.nCreateCursor(width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
    }

    public native void destroyCursor(Object var1);

    public int getPbufferCapabilities() {
        try {
            return this.nGetPbufferCapabilities(new PixelFormat(0, 0, 0, 0, 0, 0, 0, 0, false));
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred while determining pbuffer capabilities: " + e);
            return 0;
        }
    }

    private native int nGetPbufferCapabilities(PixelFormat var1) throws LWJGLException;

    public boolean isBufferLost(PeerInfo handle) {
        return ((Win32PbufferPeerInfo)handle).isBufferLost();
    }

    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) throws LWJGLException {
        return new Win32PbufferPeerInfo(width, height, pixel_format, pixelFormatCaps, pBufferAttribs);
    }

    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        ((Win32PbufferPeerInfo)handle).setPbufferAttrib(attrib, value);
    }

    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        ((Win32PbufferPeerInfo)handle).bindTexImageToPbuffer(buffer);
    }

    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        ((Win32PbufferPeerInfo)handle).releaseTexImageFromPbuffer(buffer);
    }
}

