/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.ReferencesStack;
import org.lwjgl.opengl.StateStack;
import org.lwjgl.opengl.Util;

final class StateTracker {
    private final StateStack vbo_array_stack;
    private final StateStack vbo_element_stack;
    private final StateStack pbo_pack_stack;
    private final StateStack pbo_unpack_stack;
    private final ReferencesStack references_stack;
    private final StateStack attrib_stack;

    StateTracker() {
        int stack_size = Math.max(1, Util.glGetInteger(3387));
        this.vbo_array_stack = new StateStack(stack_size, 0);
        this.vbo_element_stack = new StateStack(stack_size, 0);
        this.pbo_pack_stack = new StateStack(stack_size, 0);
        this.pbo_unpack_stack = new StateStack(stack_size, 0);
        this.references_stack = new ReferencesStack(stack_size);
        this.attrib_stack = new StateStack(stack_size, 0);
    }

    static void popAttrib() {
        if ((StateTracker.getClientAttribStack().popState() & 2) != 0) {
            StateTracker.getVBOArrayStack().popState();
            StateTracker.getVBOElementStack().popState();
            StateTracker.getPBOPackStack().popState();
            StateTracker.getPBOUnpackStack().popState();
            StateTracker.getReferencesStack().popState();
        }
    }

    static void pushAttrib(int mask) {
        StateTracker.getClientAttribStack().pushState();
        StateTracker.getClientAttribStack().setState(mask);
        if ((mask & 2) != 0) {
            StateTracker.getVBOArrayStack().pushState();
            StateTracker.getVBOElementStack().pushState();
            StateTracker.getPBOPackStack().pushState();
            StateTracker.getPBOUnpackStack().pushState();
            StateTracker.getReferencesStack().pushState();
        }
    }

    static void deleteBuffers(IntBuffer buffers) {
        for (int i = buffers.position(); i < buffers.limit(); ++i) {
            int buffer_handle = buffers.get(i);
            if (StateTracker.getVBOArrayStack().getState() == buffer_handle) {
                StateTracker.getVBOArrayStack().setState(0);
            }
            if (StateTracker.getVBOElementStack().getState() == buffer_handle) {
                StateTracker.getVBOElementStack().setState(0);
            }
            if (StateTracker.getPBOPackStack().getState() == buffer_handle) {
                StateTracker.getPBOPackStack().setState(0);
            }
            if (StateTracker.getPBOUnpackStack().getState() != buffer_handle) continue;
            StateTracker.getPBOUnpackStack().setState(0);
        }
    }

    static void bindBuffer(int target, int buffer) {
        switch (target) {
            case 34962: {
                StateTracker.getVBOArrayStack().setState(buffer);
                break;
            }
            case 34963: {
                StateTracker.getVBOElementStack().setState(buffer);
                break;
            }
            case 35051: {
                StateTracker.getPBOPackStack().setState(buffer);
                break;
            }
            case 35052: {
                StateTracker.getPBOUnpackStack().setState(buffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported VBO target " + target);
            }
        }
    }

    static StateStack getVBOArrayStack() {
        return GLContext.getCapabilities().tracker.vbo_array_stack;
    }

    static StateStack getVBOElementStack() {
        return GLContext.getCapabilities().tracker.vbo_element_stack;
    }

    static StateStack getPBOPackStack() {
        return GLContext.getCapabilities().tracker.pbo_pack_stack;
    }

    static StateStack getPBOUnpackStack() {
        return GLContext.getCapabilities().tracker.pbo_unpack_stack;
    }

    static ReferencesStack getReferencesStack() {
        return GLContext.getCapabilities().tracker.references_stack;
    }

    private static StateStack getClientAttribStack() {
        return GLContext.getCapabilities().tracker.attrib_stack;
    }
}

