/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.util;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public final class Log {
    public static PrintStream out = System.out;
    private static boolean verbose = true;
    private static boolean forcedVerbose = false;
    private static final String forceVerboseProperty = "org.newdawn.slick.forceVerboseLog";
    private static final String forceVerbosePropertyOnValue = "true";

    private Log() {
    }

    public static void setVerbose(boolean v) {
        if (forcedVerbose) {
            return;
        }
        verbose = v;
    }

    public static void checkVerboseLogSetting() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String val = System.getProperty(Log.forceVerboseProperty);
                if (val != null && val.equalsIgnoreCase(Log.forceVerbosePropertyOnValue)) {
                    Log.setForcedVerboseOn();
                }
                return null;
            }
        });
    }

    public static void setForcedVerboseOn() {
        forcedVerbose = true;
        verbose = true;
    }

    public static void error(String message, Throwable e) {
        Log.error(message);
        Log.error(e);
    }

    public static void error(Throwable e) {
        out.println(new Date() + " ERROR:" + e.getMessage());
        e.printStackTrace(out);
    }

    public static void error(String message) {
        out.println(new Date() + " ERROR:" + message);
    }

    public static void warn(String message) {
        out.println(new Date() + " WARN:" + message);
    }

    public static void info(String message) {
        if (verbose || forcedVerbose) {
            out.println(new Date() + " INFO:" + message);
        }
    }

    public static void debug(String message) {
        if (verbose || forcedVerbose) {
            out.println(new Date() + " DEBUG:" + message);
        }
    }
}

