/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tiled;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TiledMap {
    private static byte[] baseCodes;
    protected int width;
    protected int height;
    protected int tileWidth;
    protected int tileHeight;
    protected String tilesLocation;
    protected Properties props;
    protected ArrayList tileSets = new ArrayList();
    protected ArrayList layers = new ArrayList();

    public TiledMap(String ref) throws SlickException {
        ref = ref.replace('\\', '/');
        this.load(ResourceLoader.getResourceAsStream(ref), ref.substring(0, ref.lastIndexOf("/")));
    }

    public TiledMap(String ref, String tileSetsLocation) throws SlickException {
        this.load(ResourceLoader.getResourceAsStream(ref), tileSetsLocation);
    }

    public TiledMap(InputStream in) throws SlickException {
        this.load(in, "");
    }

    public TiledMap(InputStream in, String tileSetsLocation) throws SlickException {
        this.load(in, tileSetsLocation);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileId(int x, int y, int layerIndex) {
        Layer layer = (Layer)this.layers.get(layerIndex);
        return layer.getTileID(x, y);
    }

    public void setTileId(int x, int y, int layerIndex, int tileid) {
        Layer layer = (Layer)this.layers.get(layerIndex);
        layer.setTileID(x, y, tileid);
    }

    public String getMapProperty(String propertyName, String def) {
        if (this.props == null) {
            return def;
        }
        return this.props.getProperty(propertyName, def);
    }

    public String getLayerProperty(int layerIndex, String propertyName, String def) {
        Layer layer = (Layer)this.layers.get(layerIndex);
        if (layer == null || layer.props == null) {
            return def;
        }
        return layer.props.getProperty(propertyName, def);
    }

    public String getTileProperty(int tileID, String propertyName, String def) {
        if (tileID == 0) {
            return def;
        }
        TileSet set = this.findTileSet(tileID);
        Properties props = set.getProperties(tileID);
        if (props == null) {
            return def;
        }
        return props.getProperty(propertyName, def);
    }

    public void render(int x, int y) {
        this.render(x, y, 0, 0, this.width, this.height, false);
    }

    public void render(int x, int y, int sx, int sy, int width, int height) {
        this.render(x, y, sx, sy, width, height, false);
    }

    public void render(int x, int y, int sx, int sy, int width, int height, int l, boolean lineByLine) {
        Layer layer = (Layer)this.layers.get(l);
        for (int ty = 0; ty < height; ++ty) {
            layer.render(x, y, sx, sy, width, ty, lineByLine);
        }
    }

    public void render(int x, int y, int sx, int sy, int width, int height, boolean lineByLine) {
        for (int ty = 0; ty < height; ++ty) {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.get(i);
                layer.render(x, y, sx, sy, width, ty, lineByLine);
            }
        }
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    private void load(InputStream in, String tileSetsLocation) throws SlickException {
        this.tilesLocation = tileSetsLocation;
        try {
            NodeList properties;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element docElement = doc.getDocumentElement();
            String orient = docElement.getAttribute("orientation");
            if (!orient.equals("orthogonal")) {
                throw new SlickException("Only orthogonal maps supported, found: " + orient);
            }
            this.width = Integer.parseInt(docElement.getAttribute("width"));
            this.height = Integer.parseInt(docElement.getAttribute("height"));
            this.tileWidth = Integer.parseInt(docElement.getAttribute("tilewidth"));
            this.tileHeight = Integer.parseInt(docElement.getAttribute("tileheight"));
            Element propsElement = (Element)docElement.getElementsByTagName("properties").item(0);
            if (propsElement != null && (properties = propsElement.getElementsByTagName("property")) != null) {
                this.props = new Properties();
                for (int p = 0; p < properties.getLength(); ++p) {
                    Element propElement = (Element)properties.item(p);
                    String name = propElement.getAttribute("name");
                    String value = propElement.getAttribute("value");
                    this.props.setProperty(name, value);
                }
            }
            TileSet tileSet = null;
            TileSet lastSet = null;
            NodeList setNodes = docElement.getElementsByTagName("tileset");
            for (int i = 0; i < setNodes.getLength(); ++i) {
                Element current = (Element)setNodes.item(i);
                tileSet = new TileSet(current);
                tileSet.index = i;
                if (lastSet != null) {
                    lastSet.setLimit(tileSet.firstGID - 1);
                }
                lastSet = tileSet;
                this.tileSets.add(tileSet);
            }
            NodeList layerNodes = docElement.getElementsByTagName("layer");
            int i = 0;
            while (i < layerNodes.getLength()) {
                Element current = (Element)layerNodes.item(i);
                Layer layer = new Layer(current);
                layer.index = i++;
                this.layers.add(layer);
            }
        }
        catch (Exception e) {
            Log.error(e);
            throw new SlickException("Failed to parse tilemap", e);
        }
    }

    private TileSet findTileSet(int gid) {
        for (int i = 0; i < this.tileSets.size(); ++i) {
            TileSet set = (TileSet)this.tileSets.get(i);
            if (!set.contains(gid)) continue;
            return set;
        }
        throw new RuntimeException("Global tile id " + gid + " not found");
    }

    protected void renderedLine(int visualY, int mapY, int layer) {
    }

    private byte[] decodeBase64(char[] data) {
        int temp = data.length;
        for (int ix = 0; ix < data.length; ++ix) {
            if (data[ix] <= '\u00ff' && baseCodes[data[ix]] >= 0) continue;
            --temp;
        }
        int len = temp / 4 * 3;
        if (temp % 4 == 3) {
            len += 2;
        }
        if (temp % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            int value;
            int n = value = data[ix] > '\u00ff' ? -1 : baseCodes[data[ix]];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new RuntimeException("Data length appears to be wrong (wrote " + index + " should be " + out.length + ")");
        }
        return out;
    }

    static {
        int i;
        baseCodes = new byte[256];
        for (i = 0; i < 256; ++i) {
            TiledMap.baseCodes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            TiledMap.baseCodes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            TiledMap.baseCodes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            TiledMap.baseCodes[i] = (byte)(52 + i - 48);
        }
        TiledMap.baseCodes[43] = 62;
        TiledMap.baseCodes[47] = 63;
    }

    protected class Layer {
        public int index;
        public String name;
        public int[][][] data;
        public int width;
        public int height;
        public Properties props;

        public Layer(Element element) throws SlickException {
            NodeList properties;
            this.name = element.getAttribute("name");
            this.width = Integer.parseInt(element.getAttribute("width"));
            this.height = Integer.parseInt(element.getAttribute("height"));
            this.data = new int[this.width][this.height][3];
            Element propsElement = (Element)element.getElementsByTagName("properties").item(0);
            if (propsElement != null && (properties = propsElement.getElementsByTagName("property")) != null) {
                this.props = new Properties();
                for (int p = 0; p < properties.getLength(); ++p) {
                    Element propElement = (Element)properties.item(p);
                    String name = propElement.getAttribute("name");
                    String value = propElement.getAttribute("value");
                    this.props.setProperty(name, value);
                }
            }
            Element dataNode = (Element)element.getElementsByTagName("data").item(0);
            String encoding = dataNode.getAttribute("encoding");
            String compression = dataNode.getAttribute("compression");
            if (encoding.equals("base64") && compression.equals("gzip")) {
                try {
                    Node cdata = dataNode.getFirstChild();
                    char[] enc = cdata.getNodeValue().trim().toCharArray();
                    byte[] dec = TiledMap.this.decodeBase64(enc);
                    GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(dec));
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            int tileId = 0;
                            tileId |= is.read();
                            tileId |= is.read() << 8;
                            tileId |= is.read() << 16;
                            if ((tileId |= is.read() << 24) == 0) {
                                this.data[x][y][0] = -1;
                                this.data[x][y][1] = 0;
                                this.data[x][y][2] = 0;
                                continue;
                            }
                            TileSet set = TiledMap.this.findTileSet(tileId);
                            this.data[x][y][0] = set.index;
                            this.data[x][y][1] = tileId - set.firstGID;
                            this.data[x][y][2] = tileId;
                        }
                    }
                }
                catch (IOException e) {
                    Log.error(e);
                    throw new SlickException("Unable to decode base 64 block");
                }
            } else {
                throw new SlickException("Unsupport tiled map type: " + encoding + "," + compression + " (only gzip base64 supported)");
            }
        }

        public int getTileID(int x, int y) {
            return this.data[x][y][2];
        }

        public void setTileID(int x, int y, int tile) {
            if (tile == 0) {
                this.data[x][y][0] = -1;
                this.data[x][y][1] = 0;
                this.data[x][y][2] = 0;
            } else {
                TileSet set = TiledMap.this.findTileSet(tile);
                this.data[x][y][0] = set.index;
                this.data[x][y][1] = tile - set.firstGID;
                this.data[x][y][2] = tile;
            }
        }

        public void render(int x, int y, int sx, int sy, int width, int ty, boolean lineByLine) {
            for (int tileset = 0; tileset < TiledMap.this.tileSets.size(); ++tileset) {
                TileSet set = null;
                for (int tx = 0; tx < width; ++tx) {
                    if (sx + tx < 0 || sy + ty < 0 || sx + tx >= this.width || sy + ty >= this.height || this.data[sx + tx][sy + ty][0] != tileset) continue;
                    if (set == null) {
                        set = (TileSet)TiledMap.this.tileSets.get(tileset);
                        set.tiles.startUse();
                    }
                    int sheetX = set.getTileX(this.data[sx + tx][sy + ty][1]);
                    int sheetY = set.getTileY(this.data[sx + tx][sy + ty][1]);
                    set.tiles.renderInUse(x + tx * set.tileWidth, y + ty * set.tileHeight, sheetX, sheetY);
                }
                if (lineByLine) {
                    if (set != null) {
                        set.tiles.endUse();
                        set = null;
                    }
                    TiledMap.this.renderedLine(ty, ty + sy, this.index);
                }
                if (set == null) continue;
                set.tiles.endUse();
            }
        }
    }

    protected class TileSet {
        public int index;
        public String name;
        public int firstGID;
        public int lastGID = Integer.MAX_VALUE;
        public int tileWidth;
        public int tileHeight;
        public SpriteSheet tiles;
        public int tilesAcross;
        public int tilesDown;
        private HashMap props = new HashMap();

        public TileSet(Element element) throws SlickException {
            this.name = element.getAttribute("name");
            this.firstGID = Integer.parseInt(element.getAttribute("firstgid"));
            String source = element.getAttribute("source");
            if (source != null && !source.equals("")) {
                try {
                    Element docElement;
                    InputStream in = ResourceLoader.getResourceAsStream(TiledMap.this.tilesLocation + "/" + source);
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(in);
                    element = docElement = doc.getDocumentElement();
                }
                catch (Exception e) {
                    Log.error(e);
                    throw new SlickException("Unable to load or parse sourced tileset: " + TiledMap.this.tilesLocation + "/" + source);
                }
            }
            this.tileWidth = Integer.parseInt(element.getAttribute("tilewidth"));
            this.tileHeight = Integer.parseInt(element.getAttribute("tileheight"));
            int spacing = 0;
            String sv = element.getAttribute("spacing");
            if (sv != null && !sv.equals("")) {
                spacing = Integer.parseInt(sv);
            }
            NodeList list = element.getElementsByTagName("image");
            Element imageNode = (Element)list.item(0);
            String ref = imageNode.getAttribute("source");
            Color trans = null;
            String t = imageNode.getAttribute("trans");
            if (t != null && t.length() > 0) {
                int c = Integer.parseInt(t, 16);
                trans = new Color(c);
            }
            Image image = new Image(TiledMap.this.tilesLocation + "/" + ref, true, 2, trans);
            this.tiles = new SpriteSheet(image, this.tileWidth, this.tileHeight, spacing);
            this.tilesAcross = this.tiles.getWidth() / (this.tileWidth + spacing);
            this.tilesDown = this.tiles.getHeight() / (this.tileHeight + spacing);
            NodeList pElements = element.getElementsByTagName("tile");
            for (int i = 0; i < pElements.getLength(); ++i) {
                Element tileElement = (Element)pElements.item(i);
                int id = Integer.parseInt(tileElement.getAttribute("id"));
                id += this.firstGID;
                Properties tileProps = new Properties();
                Element propsElement = (Element)tileElement.getElementsByTagName("properties").item(0);
                NodeList properties = propsElement.getElementsByTagName("property");
                for (int p = 0; p < properties.getLength(); ++p) {
                    Element propElement = (Element)properties.item(p);
                    String name = propElement.getAttribute("name");
                    String value = propElement.getAttribute("value");
                    tileProps.setProperty(name, value);
                }
                this.props.put(new Integer(id), tileProps);
            }
        }

        public Properties getProperties(int globalID) {
            return (Properties)this.props.get(new Integer(globalID));
        }

        public int getTileX(int id) {
            return id % this.tilesAcross;
        }

        public int getTileY(int id) {
            return id / this.tilesAcross;
        }

        public void setLimit(int limit) {
            this.lastGID = limit;
        }

        public boolean contains(int gid) {
            return gid >= this.firstGID && gid <= this.lastGID;
        }
    }
}

