/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.geom;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Triangulator;
import org.newdawn.slick.opengl.Texture;

public class Polygon {
    private Triangulator tris = new Triangulator();
    private boolean updated;
    private ArrayList points = new ArrayList();

    public Polygon() {
    }

    public Polygon(float[] xpoints, float[] ypoints) {
        if (xpoints.length == ypoints.length) {
            for (int i = 0; i < xpoints.length; ++i) {
                this.addPoint(xpoints[i], ypoints[i]);
            }
        } else {
            throw new RuntimeException("xpoints array must be the same length as ypoints array");
        }
    }

    public Polygon(float[][] points) {
        for (int i = 0; i < points.length; ++i) {
            this.addPoint(points[i][0], points[i][1]);
        }
    }

    public void addPoint(float x, float y) {
        this.points.add(new float[]{x, y});
        this.tris.addPolyPoint(x, y);
        this.updated = true;
    }

    public boolean hasVertex(float x, float y) {
        for (int i = 0; i < this.points.size(); ++i) {
            float[] pt = (float[])this.points.get(i);
            if (pt[0] != x || pt[1] != y) continue;
            return true;
        }
        return false;
    }

    public Polygon getScaled(float offset) {
        Polygon result = new Polygon();
        float[] p1 = (float[])this.points.get(0);
        float[] p2 = (float[])this.points.get(1);
        boolean clockwise = p2[0] > p1[0] || p1[1] > p2[1];
        for (int i = 0; i < this.points.size(); ++i) {
            int pi = i - 1 < 0 ? this.points.size() - 1 : i - 1;
            int ni = i + 1 > this.points.size() - 1 ? 0 : i + 1;
            float[] p = (float[])this.points.get(pi);
            float[] c = (float[])this.points.get(i);
            float[] n = (float[])this.points.get(ni);
            float dx1 = c[0] - p[0];
            float dy1 = c[1] - p[1];
            float l1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
            float dx2 = n[0] - c[0];
            float dy2 = n[1] - c[1];
            float l2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
            float dx = (dx1 /= l1) + (dx2 /= l2);
            float dy = (dy1 /= l1) + (dy2 /= l2);
            float l = (float)Math.sqrt(dx * dx + dy * dy);
            float px = c[0] - (dy /= l) * offset;
            float py = c[1] + (dx /= l) * offset;
            if (offset < 0.0f && !this.contains(px, py)) {
                px = c[0] + dy * offset;
                py = c[1] - dx * offset;
            }
            if (offset > 0.0f && this.contains(px, py)) {
                px = c[0] + dy * offset;
                py = c[1] - dx * offset;
            }
            result.addPoint(px, py);
        }
        return result;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public float[] getPoint(int index) {
        return (float[])this.points.get(index);
    }

    public void fill(Graphics g) {
        if (this.updated) {
            this.tris.triangulate();
            this.updated = false;
        }
        Texture.bindNone();
        GL11.glBegin((int)4);
        int count = this.tris.getTriangleCount();
        for (int i = 0; i < count; ++i) {
            float[] pt = this.tris.getTrianglePoint(i, 0);
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
            pt = this.tris.getTrianglePoint(i, 1);
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
            pt = this.tris.getTrianglePoint(i, 2);
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
        }
        GL11.glEnd();
    }

    public void texture(Graphics g, Image image, float scale) {
        if (this.updated) {
            this.tris.triangulate();
            this.updated = false;
        }
        image.bind();
        GL11.glBegin((int)4);
        int count = this.tris.getTriangleCount();
        for (int i = 0; i < count; ++i) {
            float[] pt = this.tris.getTrianglePoint(i, 0);
            GL11.glTexCoord2f((float)(pt[0] * scale), (float)(pt[1] * scale));
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
            pt = this.tris.getTrianglePoint(i, 1);
            GL11.glTexCoord2f((float)(pt[0] * scale), (float)(pt[1] * scale));
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
            pt = this.tris.getTrianglePoint(i, 2);
            GL11.glTexCoord2f((float)(pt[0] * scale), (float)(pt[1] * scale));
            GL11.glVertex3f((float)pt[0], (float)pt[1], (float)0.0f);
        }
        GL11.glEnd();
    }

    public boolean contains(float x, float y) {
        if (this.updated) {
            this.tris.triangulate();
            this.updated = false;
        }
        int count = this.tris.getTriangleCount();
        for (int i = 0; i < count; ++i) {
            if (!this.inTriangle(i, x, y)) continue;
            return true;
        }
        return false;
    }

    private boolean inTriangle(int triangle, float x, float y) {
        boolean sideB;
        float[] a = this.tris.getTrianglePoint(triangle, 0);
        float[] b = this.tris.getTrianglePoint(triangle, 1);
        float[] c = this.tris.getTrianglePoint(triangle, 2);
        boolean sideA = (b[1] - a[1]) * (x - a[0]) - (b[0] - a[0]) * (y - a[1]) > 0.0f;
        boolean bl = sideB = (c[1] - b[1]) * (x - b[0]) - (c[0] - b[0]) * (y - b[1]) > 0.0f;
        if (sideA != sideB) {
            return false;
        }
        boolean sideC = (a[1] - c[1]) * (x - c[0]) - (a[0] - c[0]) * (y - c[1]) > 0.0f;
        return sideA == sideC;
    }
}

