/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Polygon;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.util.FastTrig;
import org.newdawn.slick.util.Log;

public class Graphics {
    private static final int DEFAULT_SEGMENTS = 50;
    protected static Graphics currentGraphics = null;
    private Font font;
    private Font defaultFont;
    private Color currentColor = Color.white;
    protected int screenWidth;
    protected int screenHeight;
    private boolean pushed;
    private Rectangle clip;
    private DoubleBuffer worldClip = BufferUtils.createDoubleBuffer((int)4);
    private ByteBuffer readBuffer = BufferUtils.createByteBuffer((int)4);

    public Graphics(int width, int height) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Graphics.this.defaultFont = new AngelCodeFont("org/newdawn/slick/data/default.fnt", "org/newdawn/slick/data/default_00.tga");
                }
                catch (SlickException e) {
                    Log.error(e);
                }
                return null;
            }
        });
        this.font = this.defaultFont;
        this.screenWidth = width;
        this.screenHeight = height;
    }

    private void predraw() {
        if (currentGraphics != this) {
            if (currentGraphics != null) {
                currentGraphics.disable();
            }
            currentGraphics = this;
            currentGraphics.enable();
        }
    }

    private void postdraw() {
    }

    protected void enable() {
    }

    public void flush() {
        if (currentGraphics == this) {
            currentGraphics.disable();
            currentGraphics = null;
        }
    }

    protected void disable() {
    }

    public Font getFont() {
        return this.font;
    }

    public void setBackground(Color color) {
        this.predraw();
        GL11.glClearColor((float)color.r, (float)color.g, (float)color.b, (float)1.0f);
        this.postdraw();
    }

    public Color getBackground() {
        this.predraw();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)3106, (FloatBuffer)buffer);
        this.postdraw();
        return new Color(buffer);
    }

    public void clear() {
        this.predraw();
        GL11.glClear((int)16384);
        this.postdraw();
    }

    public void resetTransform() {
        if (this.pushed) {
            this.predraw();
            GL11.glPopMatrix();
            this.pushed = false;
            this.postdraw();
        }
    }

    private void checkPush() {
        if (!this.pushed) {
            this.predraw();
            GL11.glPushMatrix();
            this.pushed = true;
            this.postdraw();
        }
    }

    public void scale(float sx, float sy) {
        this.checkPush();
        this.predraw();
        GL11.glScalef((float)sx, (float)sy, (float)0.0f);
        this.postdraw();
    }

    public void rotate(float rx, float ry, float ang) {
        this.checkPush();
        this.predraw();
        this.translate(rx, ry);
        GL11.glRotatef((float)ang, (float)0.0f, (float)0.0f, (float)1.0f);
        this.translate(-rx, -ry);
        this.postdraw();
    }

    public void translate(float x, float y) {
        this.checkPush();
        this.predraw();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        this.postdraw();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void resetFont() {
        this.font = this.defaultFont;
    }

    public void setColor(Color color) {
        this.currentColor = color;
        this.predraw();
        color.bind();
        this.postdraw();
    }

    public Color getColor() {
        return new Color(this.currentColor);
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        this.predraw();
        this.currentColor.bind();
        Texture.bindNone();
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        this.postdraw();
    }

    public void fill(Polygon poly) {
        if (poly.getPointCount() < 3) {
            return;
        }
        this.predraw();
        this.currentColor.bind();
        Texture.bindNone();
        poly.fill(this);
        this.postdraw();
    }

    public void draw(Polygon poly) {
        if (poly.getPointCount() < 3) {
            return;
        }
        this.predraw();
        this.currentColor.bind();
        Texture.bindNone();
        GL11.glBegin((int)3);
        for (int i = 0; i < poly.getPointCount(); ++i) {
            float[] pt = poly.getPoint(i);
            GL11.glVertex2f((float)pt[0], (float)pt[1]);
        }
        float[] pt = poly.getPoint(0);
        GL11.glVertex2f((float)pt[0], (float)pt[1]);
        GL11.glEnd();
        this.postdraw();
    }

    public void draw(Rectangle rect) {
        this.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void fill(Rectangle rect) {
        this.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void draw(Circle circle) {
        this.drawOval((int)(circle.getX() - circle.getRadius()), (int)(circle.getY() - circle.getRadius()), (int)(circle.getRadius() * 2.0f), (int)(circle.getRadius() * 2.0f));
    }

    public void fill(Circle circle) {
        this.fillOval((int)(circle.getX() - circle.getRadius()), (int)(circle.getY() - circle.getRadius()), (int)(circle.getRadius() * 2.0f), (int)(circle.getRadius() * 2.0f));
    }

    public void drawRect(float x1, float y1, float width, float height) {
        this.predraw();
        Texture.bindNone();
        this.currentColor.bind();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)(x1 + width + 1.0f), (float)y1);
        GL11.glVertex2f((float)(x1 + width), (float)(y1 + height));
        GL11.glVertex2f((float)x1, (float)(y1 + height));
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glEnd();
        this.postdraw();
    }

    public void clearClip() {
        this.clip = null;
        this.predraw();
        GL11.glDisable((int)3089);
        this.postdraw();
    }

    public void setWorldClip(int x, int y, int width, int height) {
        GL11.glEnable((int)12288);
        this.worldClip.put(1.0).put(0.0).put(0.0).put(-x).flip();
        GL11.glClipPlane((int)12288, (DoubleBuffer)this.worldClip);
        GL11.glEnable((int)12289);
        this.worldClip.put(-1.0).put(0.0).put(0.0).put(x + width).flip();
        GL11.glClipPlane((int)12289, (DoubleBuffer)this.worldClip);
        GL11.glEnable((int)12290);
        this.worldClip.put(0.0).put(1.0).put(0.0).put(-y).flip();
        GL11.glClipPlane((int)12290, (DoubleBuffer)this.worldClip);
        GL11.glEnable((int)12291);
        this.worldClip.put(0.0).put(-1.0).put(0.0).put(y + height).flip();
        GL11.glClipPlane((int)12291, (DoubleBuffer)this.worldClip);
    }

    public void clearWorldClip() {
        GL11.glDisable((int)12288);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12291);
    }

    public void setClip(int x, int y, int width, int height) {
        this.predraw();
        GL11.glEnable((int)3089);
        this.clip = new Rectangle(x, y, width, height);
        GL11.glScissor((int)x, (int)(this.screenHeight - y - height), (int)width, (int)height);
        this.postdraw();
    }

    public void setClip(Rectangle rect) {
        if (rect == null) {
            this.clearClip();
            return;
        }
        this.setClip((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public Rectangle getClip() {
        return this.clip;
    }

    public void fillRect(float x, float y, float width, float height, Image pattern, float offX, float offY) {
        int cols = (int)Math.ceil(width / (float)pattern.getWidth()) + 2;
        int rows = (int)Math.ceil(height / (float)pattern.getHeight()) + 2;
        Rectangle preClip = this.getClip();
        this.setClip((int)x, (int)y, (int)width, (int)height);
        this.predraw();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                pattern.draw((float)(c * pattern.getWidth()) + x - offX, (float)(r * pattern.getHeight()) + y - offY);
            }
        }
        this.postdraw();
        this.setClip(preClip);
    }

    public void fillRect(float x1, float y1, float width, float height) {
        this.predraw();
        Texture.bindNone();
        this.currentColor.bind();
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)(x1 + width), (float)y1);
        GL11.glVertex2f((float)(x1 + width), (float)(y1 + height));
        GL11.glVertex2f((float)x1, (float)(y1 + height));
        GL11.glEnd();
        this.postdraw();
    }

    public void drawOval(float x1, float y1, float width, float height) {
        this.drawOval(x1, y1, width, height, 50);
    }

    public void drawOval(float x1, float y1, float width, float height, int segments) {
        this.drawArc(x1, y1, width, height, segments, 0.0f, 360.0f);
    }

    public void drawArc(float x1, float y1, float width, float height, float start, float end) {
        this.drawArc(x1, y1, width, height, 50, start, end);
    }

    public void drawArc(float x1, float y1, float width, float height, int segments, float start, float end) {
        this.predraw();
        Texture.bindNone();
        this.currentColor.bind();
        while (end < start) {
            end += 360.0f;
        }
        float cx = x1 + width / 2.0f;
        float cy = y1 + height / 2.0f;
        GL11.glBegin((int)3);
        int step = 360 / segments;
        for (int a = (int)start; a < (int)(end + (float)step); a += step) {
            float ang = a;
            if (ang > end) {
                ang = end;
            }
            float x = (float)((double)cx + FastTrig.cos(Math.toRadians(ang)) * (double)width / 2.0);
            float y = (float)((double)cy + FastTrig.sin(Math.toRadians(ang)) * (double)height / 2.0);
            GL11.glVertex2f((float)x, (float)y);
        }
        GL11.glEnd();
        this.postdraw();
    }

    public void fillOval(float x1, float y1, float width, float height) {
        this.fillOval(x1, y1, width, height, 50);
    }

    public void fillOval(float x1, float y1, float width, float height, int segments) {
        this.fillArc(x1, y1, width, height, segments, 0.0f, 360.0f);
    }

    public void fillArc(float x1, float y1, float width, float height, float start, float end) {
        this.fillArc(x1, y1, width, height, 50, start, end);
    }

    public void fillArc(float x1, float y1, float width, float height, int segments, float start, float end) {
        this.predraw();
        Texture.bindNone();
        this.currentColor.bind();
        while (end < start) {
            end += 360.0f;
        }
        float cx = x1 + width / 2.0f;
        float cy = y1 + height / 2.0f;
        GL11.glBegin((int)6);
        int step = 360 / segments;
        GL11.glVertex2f((float)cx, (float)cy);
        for (int a = (int)start; a < (int)(end + (float)step); a += step) {
            float ang = a;
            if (ang > end) {
                ang = end;
            }
            float x = (float)((double)cx + FastTrig.cos(Math.toRadians(ang)) * (double)width / 2.0);
            float y = (float)((double)cy + FastTrig.sin(Math.toRadians(ang)) * (double)height / 2.0);
            GL11.glVertex2f((float)x, (float)y);
        }
        GL11.glEnd();
        this.postdraw();
    }

    public void setLineWidth(float width) {
        this.predraw();
        GL11.glLineWidth((float)width);
        this.postdraw();
    }

    public void resetLineWidth() {
        this.predraw();
        GL11.glLineWidth((float)1.0f);
        this.postdraw();
    }

    public void setAntiAlias(boolean anti) {
        this.predraw();
        if (anti) {
            GL11.glEnable((int)2848);
            GL11.glEnable((int)2881);
        } else {
            GL11.glDisable((int)2848);
            GL11.glDisable((int)2881);
        }
        this.postdraw();
    }

    public void drawString(String str, float x, float y) {
        this.predraw();
        this.font.drawString(x, y, str, this.currentColor);
        this.postdraw();
    }

    public void drawImage(Image image, float x, float y, Color col) {
        this.predraw();
        image.draw(x, y, col);
        this.currentColor.bind();
        this.postdraw();
    }

    public void drawImage(Image image, float x, float y) {
        this.predraw();
        this.drawImage(image, x, y, Color.white);
        this.currentColor.bind();
        this.postdraw();
    }

    public void copyArea(Image target, int x, int y) {
        int format = target.getTexture().hasAlpha() ? 6408 : 6407;
        target.bind();
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)format, (int)x, (int)(this.screenHeight - (y + target.getHeight())), (int)target.getTexture().getTextureWidth(), (int)target.getTexture().getTextureHeight(), (int)0);
        target.ensureInverted();
    }

    private int translate(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public Color getPixel(int x, int y) {
        GL11.glReadPixels((int)x, (int)(this.screenHeight - y), (int)1, (int)1, (int)6408, (int)5121, (ByteBuffer)this.readBuffer);
        return new Color(this.translate(this.readBuffer.get(0)), this.translate(this.readBuffer.get(1)), this.translate(this.readBuffer.get(2)), this.translate(this.readBuffer.get(3)));
    }
}

