/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.util.ArrayList;
import org.lwjgl.Sys;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.util.Log;

public class Animation {
    private ArrayList frames = new ArrayList();
    private int currentFrame = -1;
    private long nextChange = 0L;
    private boolean stopped = false;
    private long timeLeft;
    private float speed = 1.0f;
    private int stopAt = -2;
    private long lastUpdate;
    private boolean firstUpdate = true;
    private boolean autoUpdate = true;
    private int direction = 1;
    private boolean pingPong;

    public Animation() {
        this(true);
    }

    public Animation(Image[] frames, int duration) {
        this(frames, duration, true);
    }

    public Animation(Image[] frames, int[] durations) {
        this(frames, durations, true);
    }

    public Animation(boolean autoUpdate) {
        this.currentFrame = 0;
        this.autoUpdate = autoUpdate;
    }

    public Animation(Image[] frames, int duration, boolean autoUpdate) {
        for (int i = 0; i < frames.length; ++i) {
            this.addFrame(frames[i], duration);
        }
        this.currentFrame = 0;
        this.autoUpdate = autoUpdate;
    }

    public Animation(Image[] frames, int[] durations, boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        if (frames.length != durations.length) {
            throw new RuntimeException("There must be one duration per frame");
        }
        for (int i = 0; i < frames.length; ++i) {
            this.addFrame(frames[i], durations[i]);
        }
        this.currentFrame = 0;
    }

    public Animation(SpriteSheet frames, int duration) {
        this(frames, 0, 0, frames.getHorizontalCount() - 1, frames.getVerticalCount() - 1, true, duration, true);
    }

    public Animation(SpriteSheet frames, int x1, int y1, int x2, int y2, boolean horizontalScan, int duration, boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        if (horizontalScan) {
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    this.addFrame(frames.getSprite(x, y), duration);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    this.addFrame(frames.getSprite(x, y), duration);
                }
            }
        }
    }

    public void setAutoUpdate(boolean auto) {
        this.autoUpdate = auto;
    }

    public void setPingPong(boolean pingPong) {
        this.pingPong = pingPong;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setSpeed(float spd) {
        if (this.speed >= 0.0f) {
            this.speed = spd;
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void stop() {
        if (this.frames.size() == 0) {
            return;
        }
        this.timeLeft = this.nextChange;
        this.stopped = true;
    }

    public void start() {
        if (!this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.stopped = false;
        this.nextChange = this.timeLeft;
    }

    public void restart() {
        if (!this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.stopped = false;
        this.currentFrame = 0;
        this.nextChange = (int)((float)((Frame)this.frames.get((int)0)).duration / this.speed);
    }

    public void addFrame(Image frame, int duration) {
        if (duration == 0) {
            Log.error("Invalid duration: " + duration);
            throw new RuntimeException("Invalid duration: " + duration);
        }
        this.frames.add(new Frame(frame, duration));
        this.currentFrame = 0;
    }

    public void draw() {
        this.draw(0, 0);
    }

    public void draw(int x, int y) {
        this.draw(x, y, ((Frame)this.frames.get((int)this.currentFrame)).image.getWidth(), ((Frame)this.frames.get((int)this.currentFrame)).image.getHeight());
    }

    public void draw(int x, int y, Color filter) {
        this.draw(x, y, ((Frame)this.frames.get((int)this.currentFrame)).image.getWidth(), ((Frame)this.frames.get((int)this.currentFrame)).image.getHeight(), filter);
    }

    public void draw(int x, int y, int width, int height) {
        this.draw(x, y, width, height, Color.white);
    }

    public void draw(int x, int y, int width, int height, Color col) {
        if (this.frames.size() == 0) {
            return;
        }
        if (this.autoUpdate) {
            long now = this.getTime();
            long delta = now - this.lastUpdate;
            if (this.firstUpdate) {
                delta = 0L;
                this.firstUpdate = false;
            }
            this.lastUpdate = now;
            this.nextFrame(delta);
        }
        Frame frame = (Frame)this.frames.get(this.currentFrame);
        frame.image.draw(x, y, width, height, col);
    }

    public void updateNoDraw() {
        if (this.autoUpdate) {
            long now = this.getTime();
            long delta = now - this.lastUpdate;
            if (this.firstUpdate) {
                delta = 0L;
                this.firstUpdate = false;
            }
            this.lastUpdate = now;
            this.nextFrame(delta);
        }
    }

    public void update(long delta) {
        this.nextFrame(delta);
    }

    public int getFrame() {
        return this.currentFrame;
    }

    private void nextFrame(long delta) {
        if (this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.nextChange -= delta;
        while (this.nextChange < 0L && this.currentFrame != this.stopAt) {
            this.currentFrame = (this.currentFrame + this.direction) % this.frames.size();
            if (this.pingPong && (this.currentFrame == 0 || this.currentFrame == this.frames.size() - 1)) {
                this.direction = -this.direction;
            }
            int realDuration = (int)((float)((Frame)this.frames.get((int)this.currentFrame)).duration / this.speed);
            this.nextChange += (long)realDuration;
        }
        if (this.currentFrame == this.stopAt) {
            this.stopped = true;
        }
    }

    private long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void stopAt(int frameIndex) {
        this.stopAt = frameIndex;
    }

    public String toString() {
        String res = "[Animation (" + this.frames.size() + ") ";
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.get(i);
            res = res + frame.duration + ",";
        }
        res = res + "]";
        return res;
    }

    private class Frame {
        public Image image;
        public int duration;

        public Frame(Image image, int duration) {
            this.image = image;
            this.duration = duration;
        }
    }
}

