/*
 * Decompiled with CFR 0.152.
 */
package owl.states;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import owl.OwlGame;
import owl.utils.HighscoreIO;
import owl.utils.Score;
import owl.utils.UnavailableScoreSystemException;

public class ScoreState
extends BasicGameState {
    private Image bg;
    public static final int ID = 4;
    private Font font;
    private StateBasedGame game;
    HighscoreIO io;
    Score[] scores;
    private String scoresUnavailable;
    private long scoreTime;
    private boolean refreshScore;
    private Image logo;

    public int getID() {
        return 4;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.bg = new Image("images/backgrounds/background.png");
        this.game = game;
        this.io = ((OwlGame)game).getHighscoreIO();
        this.logo = new Image("images/highscores.png");
        try {
            this.scores = this.io.getTopTen();
            this.scoreTime = System.currentTimeMillis();
        }
        catch (UnavailableScoreSystemException e) {
            this.scores = null;
            this.scoresUnavailable = "The highscore system is not available at the moment. Try again later.";
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.bg.draw(-100.0f, -100.0f, 1224.0f, 968.0f);
        g.setColor(Color.black);
        Rectangle rect = new Rectangle(50.0f, 150.0f, 924.0f, 568.0f);
        g.fill(rect);
        g.setColor(Color.white);
        this.font = new AngelCodeFont("fonts/font.fnt", "fonts/font.tga");
        g.setFont(this.font);
        this.logo.draw(150.0f, -40.0f);
        g.drawString("Name", 200.0f, 150.0f);
        g.drawString("Score", 700.0f, 150.0f);
        if (this.scores != null) {
            int locationY = 200;
            Score[] scoreArray = this.scores;
            int n = 0;
            int n2 = scoreArray.length;
            while (n < n2) {
                Score s = scoreArray[n];
                if (s != null) {
                    g.drawString(s.getName(), 200.0f, (float)locationY);
                    g.drawString("" + s.getScore(), 700.0f, (float)locationY);
                    locationY += 30;
                }
                ++n;
            }
            g.drawString("Press R to reload the scores", 200.0f, (float)(locationY += 50));
            g.drawString("Time since last reload " + (System.currentTimeMillis() - this.scoreTime) / 1000L + " seconds", 200.0f, (float)(locationY += 20));
        } else {
            g.drawString(this.scoresUnavailable, 200.0f, 250.0f);
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (System.currentTimeMillis() - this.scoreTime > 30000000L || this.refreshScore) {
            Score[] oldscores = this.scores;
            try {
                this.scores = this.io.getTopTen();
                this.refreshScore = false;
                this.scoreTime = System.currentTimeMillis();
            }
            catch (UnavailableScoreSystemException e) {
                if (oldscores != null) {
                    this.scores = oldscores;
                }
                this.scoresUnavailable = "The highscore system is not available at the moment. Try again later.";
            }
        }
    }

    public void keyPressed(int key, char c) {
        if (key == 1) {
            this.game.enterState(1, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
        } else if (key == 19) {
            this.refreshScore = true;
        }
    }
}

