/*
 * Decompiled with CFR 0.152.
 */
package owl.states;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.gui.BasicComponent;
import org.newdawn.slick.gui.ComponentListener;
import org.newdawn.slick.gui.GUIContext;
import org.newdawn.slick.gui.TextField;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import owl.OwlGame;
import owl.gameobjects.Cloud;
import owl.gameobjects.CloudMaker;
import owl.gameobjects.Owl;
import owl.utils.HighscoreIO;
import owl.utils.Score;
import owl.utils.UnavailableScoreSystemException;

public class GameState
extends BasicGameState
implements ComponentListener {
    private Sound jump;
    private Sound die;
    private Sound land;
    private Sound eat;
    private Sound flap;
    private Sound walk1;
    private Sound walk2;
    public static final int ID = 2;
    private Image background;
    private Owl player;
    CloudMaker cloudmaker;
    private GameContainer container;
    private Font font;
    private StateBasedGame game;
    private boolean paused;
    private boolean scoreSent;
    private String scoreStatus;
    private int score;
    private int time;
    private Rectangle topBar;
    private Image grass;
    private TextField nameField;
    private String name;
    private SpriteSheet cata;
    private long lastPlayedTime;
    private boolean walk1LastPlayed;

    public int getID() {
        return 2;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.background = new Image("images/backgrounds/background.png");
        this.player = new Owl();
        this.container = container;
        this.game = game;
        this.cloudmaker = new CloudMaker();
        this.time = 0;
        this.score = 0;
        this.scoreSent = false;
        this.paused = false;
        this.font = new AngelCodeFont("fonts/font.fnt", "fonts/font.tga");
        this.nameField = new TextField((GUIContext)container, this.font, 150, 410, 500, 35, (ComponentListener)this);
        this.scoreStatus = "Enter your name above and press enter to send your score.";
        this.topBar = new Rectangle(0.0f, 0.0f, 1024.0f, 70.0f);
        this.cata = new SpriteSheet("images/sprites/catapult.png", 114, 39);
        this.grass = new Image("images/textures/grass.png");
        this.jump = new Sound("sounds/jump.wav");
        this.walk1 = new Sound("sounds/walk1.wav");
        this.walk2 = new Sound("sounds/walk1.wav");
        this.die = new Sound("sounds/die.wav");
        this.eat = new Sound("sounds/eat.aif");
        this.flap = new Sound("sounds/flap.wav");
        this.land = new Sound("sounds/land.wav");
        this.lastPlayedTime = System.currentTimeMillis();
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.background.draw(-100.0f, -100.0f, 1224.0f, 968.0f);
        this.cloudmaker.drawClouds(g);
        this.player.draw(g);
        g.setFont(this.font);
        g.setColor(Color.darkGray);
        g.fill(this.topBar);
        int i = 0;
        while (i < 18) {
            this.grass.draw((float)(59 * i), 708.0f);
            ++i;
        }
        g.setColor(Color.white);
        g.drawString("Time: " + this.time / 1000, 0.0f, 10.0f);
        g.drawString("Fatness: " + this.player.getWeight() + " kg", 400.0f, 10.0f);
        g.drawString("Score: " + this.score, 850.0f, 10.0f);
        if (!this.player.isStarted()) {
            g.drawString("Press spacebar to launch the owl up in the air!", 100.0f, 500.0f);
            this.cata.getSprite(0, 0).draw(50.0f, 669.0f);
        } else {
            this.cata.getSprite(1, 0).draw(50.0f, 669.0f);
        }
        if (this.player.isDead()) {
            g.setColor(Color.black);
            Rectangle gameOver = new Rectangle(100.0f, 300.0f, 800.0f, 300.0f);
            g.fill(gameOver);
            g.setColor(Color.white);
            g.drawString("GAME OVER", 150.0f, 320.0f);
            g.drawString("You survived for " + this.time / 1000 + " seconds. YEY!", 150.0f, 350.0f);
            g.drawString("You got a score of " + this.score + " points. YEY!", 150.0f, 380.0f);
            this.nameField.render((GUIContext)container, g);
            g.drawString("Click inside the textfield above with your mouse to activate it.", 150.0f, 440.0f);
            g.drawString(this.scoreStatus, 150.0f, 500.0f);
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (!this.player.isDead()) {
            Cloud c;
            this.cloudmaker.update(delta);
            if (this.player.isStarted()) {
                Input input = container.getInput();
                if (input.isKeyDown(205) || input.isKeyDown(203)) {
                    if (input.isKeyDown(203)) {
                        this.player.moveLeft();
                    }
                    if (input.isKeyDown(205)) {
                        this.player.moveRight();
                    }
                    if (System.currentTimeMillis() - this.lastPlayedTime > 300L) {
                        this.lastPlayedTime = System.currentTimeMillis();
                        if (!(this.walk1.playing() || this.walk2.playing() || this.player.isInAir())) {
                            if (this.walk1LastPlayed) {
                                this.walk2.play();
                                this.walk1LastPlayed = false;
                            } else {
                                this.walk1.play();
                                this.walk1LastPlayed = true;
                            }
                        }
                    }
                } else {
                    this.player.stopMoving();
                }
            }
            if (this.player.isInAir()) {
                if (this.player.getY() > 650.0f) {
                    this.die.play();
                    this.player.die();
                }
                if (this.player.getSpeedy() >= 0.0f && (c = this.cloudmaker.checkLandsOnCloud(this.player)) != null) {
                    this.land.play(2.0f, 0.3f);
                    this.player.land(c);
                }
            } else {
                c = this.player.getIsStandingOn();
                if (c != null) {
                    if (c.getFood() != null && this.player.collides(c.getFood())) {
                        this.player.eat();
                        this.eat.play();
                    }
                    if (c.collides(this.player)) {
                        if (c.getY() < this.player.getY()) {
                            this.player.fallOff();
                        } else {
                            this.player.getIsStandingOn().dissolve();
                            if (this.player.getIsStandingOn().isEmpty()) {
                                this.player.fallOff();
                            }
                        }
                    } else {
                        this.player.fallOff();
                    }
                }
            }
            this.player.update(delta);
            if (this.player.isStarted() && !this.player.isDead()) {
                this.score = this.player.getWeight() * 2 + this.time / 10000;
                this.time += delta;
            }
        }
    }

    public void keyPressed(int key, char c) {
        if (key == 1) {
            this.leave(this.container, this.game);
            this.game.enterState(1, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
        } else if (key == 25) {
            this.paused = !this.paused;
        } else if (key == 57 && !this.player.isDead()) {
            if (this.player.isStarted()) {
                if (!this.player.isInAir()) {
                    this.jump.play();
                } else if (!this.flap.playing()) {
                    this.flap.play();
                }
                this.player.jumpOrFly();
            } else {
                this.player.throwOwl();
            }
        }
    }

    public void leave(GameContainer container, StateBasedGame game) {
        try {
            this.init(container, game);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public void componentActivated(BasicComponent source) {
        if (source == this.nameField) {
            this.name = this.nameField.getText();
            if (this.scoreSent) {
                this.scoreStatus = "Score is already sent...";
            } else if (this.name.length() > 25) {
                this.scoreStatus = "Too long name, use a shorter one";
            } else {
                HighscoreIO io = ((OwlGame)this.game).getHighscoreIO();
                try {
                    io.sendScore(new Score(this.name, this.score));
                    this.scoreSent = true;
                    this.scoreStatus = "Your score of " + this.score + " points has been sent.";
                }
                catch (UnavailableScoreSystemException e) {
                    this.scoreStatus = "The score system is unavailable at the moment.";
                }
            }
        }
    }
}

