/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.X11OffscreenGLContext;
import com.sun.opengl.impl.x11.XVisualInfo;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11OffscreenGLDrawable
extends X11GLDrawable {
    private long pixmap;
    private boolean isDoubleBuffered;
    private int width;
    private int height;

    public X11OffscreenGLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(gLCapabilities, gLCapabilitiesChooser);
    }

    public GLContext createContext(GLContext gLContext) {
        return new X11OffscreenGLContext(this, gLContext);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (this.pixmap != 0L) {
            this.destroy();
        }
        this.create();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create() {
        this.display = X11GLDrawableFactory.getDisplayConnection();
        XVisualInfo xVisualInfo = this.chooseVisual(false);
        int n = xVisualInfo.depth();
        this.lockToolkit();
        try {
            int n2 = GLX.DefaultScreen(this.display);
            this.pixmap = GLX.XCreatePixmap(this.display, (int)GLX.RootWindow(this.display, n2), this.width, this.height, n);
            if (this.pixmap == 0L) {
                throw new GLException("XCreatePixmap failed");
            }
            this.drawable = GLX.glXCreateGLXPixmap(this.display, xVisualInfo, this.pixmap);
            if (this.drawable == 0L) {
                GLX.XFreePixmap(this.display, this.pixmap);
                this.pixmap = 0L;
                throw new GLException("glXCreateGLXPixmap failed");
            }
            boolean bl = this.isDoubleBuffered = X11GLDrawableFactory.glXGetConfig(this.display, xVisualInfo, 5, new int[1], 0) != 0;
            if (DEBUG) {
                System.err.println("Created pixmap " + X11OffscreenGLDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11OffscreenGLDrawable.toHexString(this.drawable) + ", display " + X11OffscreenGLDrawable.toHexString(this.display));
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    public void destroy() {
        if (this.pixmap != 0L) {
            long l;
            if (DEBUG) {
                System.err.println("Destroying pixmap " + X11OffscreenGLDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11OffscreenGLDrawable.toHexString(this.drawable) + ", display " + X11OffscreenGLDrawable.toHexString(this.display));
            }
            this.lockToolkit();
            if (DEBUG && (l = GLX.glXGetCurrentContext()) != 0L) {
                System.err.println("WARNING: found context " + X11OffscreenGLDrawable.toHexString(l) + " current during pixmap destruction");
            }
            GLX.glXMakeCurrent(this.display, 0L, 0L);
            GLX.glXDestroyGLXPixmap(this.display, this.drawable);
            GLX.XFreePixmap(this.display, this.pixmap);
            this.unlockToolkit();
            this.drawable = 0L;
            this.pixmap = 0L;
            this.display = 0L;
        }
    }

    public boolean isDoubleBuffered() {
        return this.isDoubleBuffered;
    }
}

