uniform sampler2D sampler;
varying vec3 normal, viewDir;
varying vec3 lightDir1, lightDir2, lightDir3;
varying vec2 texCoord;

void main(void)
{
   vec4 fvSpecular = vec4(0.2, 0.2, 0.2, 1.0);
   float fSpecularPower = 90.0;

   vec4 color = vec4(-0.2, -0.2, -0.2, 0.0);
   
   
   //diffuse
   vec3 n = normalize(normal);
   
   vec3 l2 = normalize(lightDir2);
   float fNDotL2 = max(dot(n, l2), 0.0);
   color += vec4(0.5, 0.7, 0.6, 1.0) * 0.4 * fNDotL2;
   
   vec3 l3 = normalize(lightDir3);
   float fNDotL3 = max(dot(n, l3), 0.0);
   color += vec4(0.4, 0.6, 0.4, 1.0) * 0.25 * fNDotL3;
   
    float avg_spec_map = (color.r + color.g + color.b) / 3.0;
    avg_spec_map *= 4.0;
    avg_spec_map = clamp(avg_spec_map, 0.0, 1.0);
    
       
   vec3 l1 = normalize(lightDir1);
   float fNDotL1 = max(dot(n, l1), 0.0);
   color += vec4(0.6, 0.6, 0.6, 1.0) * 1.0 * fNDotL1;

   
   //specular
   vec3 r = normalize( ( ( 2.0 * n ) * fNDotL1 ) - l1 ); 
   vec3 v = normalize( viewDir );
   float fRdotV = max( 0.0, dot( r, v ) );
   color += fvSpecular * (pow(fRdotV, fSpecularPower)) * avg_spec_map;
   
   r = normalize( ( ( 2.0 * n ) * fNDotL2 ) - l2 ); 
   v = normalize( viewDir );
   fRdotV = max( 0.0, dot( r, v ) );
   color += fvSpecular * (pow(fRdotV, fSpecularPower)) * avg_spec_map;
   
   r = normalize( ( ( 2.0 * n ) * fNDotL3 ) - l3 ); 
   v = normalize( viewDir );
   fRdotV = max( 0.0, dot( r, v ) );
   color += fvSpecular * (pow(fRdotV, fSpecularPower)) * avg_spec_map;
  
   color.rgb *= 2.0;
  
   gl_FragColor = color + (texture2D(sampler, texCoord)) * color;
}