float4x4 	wvpMatrix 	: WorldViewProjection;
float4x4 	wMatrix 	: World;
float3		lightPos	: Light0;
float		time		: Time;
float4x4	cameraMatrix	: Camera;
float4		viewVec			: ViewDir;

float4x4	projMatrix = float4x4( 	0.5f, 0.0f, 0.0f, 0.0f,
									0.0f, -0.5f, 0.0f, 0.0f,
									0.0f, 0.0f, 0.5f, 0.0f,
									0.5f, 0.5f, 0.0f, 1.0f  );
texture	texture_0
<
	string UIName = "Reflection texture";
>;
texture	texture_1
<
	string UIName = "Displacement texture";
>;

float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.7f, 0.7f, 1.0f };

float3		specularColor
<
	string UIName = "Specular Material Color";
> = { 1.0f, 1.0f, 1.0f };

float		specularPower
<
	string UIName = "Specular Power";
> = 10.0f;

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler2D texture_1Sampler = sampler_state 
{
    texture = <texture_1>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};


struct VertexInput {
    float3 position	: POSITION;
    float3 Normal	: NORMAL;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput {
    float4	position	: POSITION;
    float4 	uvCoords	: TEXCOORD0;
    half3 	lightDir	: TEXCOORD1;
    half3 	worldNormal	: TEXCOORD2;
    float2 	realUV 		: TEXCOORD3;
    float3 	viewDir		: TEXCOORD4;
};

VertexOutput VS_Water(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    half3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
    float4x4 comboMatrix = mul( wvpMatrix, projMatrix );
	OUT.uvCoords = mul(float4(IN.position,1.0f), comboMatrix);
	OUT.realUV = IN.uvCoord*50.0f;
	OUT.viewDir = reflect( normalize( OUT.lightDir ), normalize(mul(worldNormal, cameraMatrix)) );
	
    return OUT;
}

float4 PS_Water(VertexOutput IN) : COLOR {
	float3 disp = tex2D( texture_1Sampler, IN.realUV + time*0.05f );
	IN.uvCoords.x += disp.x * 2.0f - 0.8f;
	IN.uvCoords.y += disp.y * 2.0f - 0.8f;
	//IN.worldNormal.x += disp*2.0f -1.0f;
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	half3 viewDir = normalize(IN.viewDir);
	
	float specularTerm = pow( max(0.0f,dot( viewDir, viewVec )) ,specularPower);
	
	return float4(max(0,dot( normal, lightDir )) * diffuseColor + ambientColor + specularTerm * specularColor,1.0f) * tex2Dproj( texture_0Sampler, IN.uvCoords );
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Water();
		PixelShader = compile ps_2_0 PS_Water();
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
    }
}

