float4x4 	wvpMatrix 	: WorldViewProjection;

float3		ambientColor
<
	string UIName = "Ambient Glow Material Color";
> = { 1.0f, 1.0f, 1.0f };

float		ramp
<
	string UIName = "Glow Offset";
> = 0.0f;

struct VertexInput {
    float3 Position	: POSITION;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
	OUT.color = ambientColor - ramp;
    return OUT;
}

technique fixed<bool quad=true; string material="gaussian";>
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}

