float4x4	wMatrix			: World;
float4x4 	wvpMatrix 		: WorldViewProjection;
half4 		lightPos		: Light0;

texture	texture_0
<
	string UIName = "Base texture";
>;

float4		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f, 1.0f };

float4		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f, 1.0f };

float		clampValue
<
	string UIName = "Clamp offset";
> = { 0.03f };

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
    float3 Normal		: NORMAL;
};

struct VertexOutput {
    float4 	position	: POSITION;
    half3 	lightDir	: TEXCOORD0;
    half3 	worldNormal	: TEXCOORD1;
    float2	uvCoord		: TEXCOORD2;
};

VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    half3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoord = IN.uvCoord;
	
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	float4 texColor = tex2D( texture_0Sampler, IN.uvCoord );
	clip( texColor.a - clampValue );
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	return max(0,dot( normal, lightDir )) * diffuseColor + ambientColor * texColor;
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}

