using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public partial class MeshSelectForm : Form
    {
        public String Mesh
        {
            get { return textBoxMeshName.Text; }
            set
            {
                textBoxMeshName.Text = value;

                // Find the new index to select
                int new_idx = -1;
                int idx = 0;
                foreach (Mesh mesh in listBoxMeshes.Items)
                {
                    if (mesh.name == value)
                    {
                        new_idx = idx;
                        break;
                    }
                    ++idx;
                }
                if (listBoxMeshes.SelectedIndex != new_idx)
                {
                    listBoxMeshes.SelectedIndex = new_idx;
                    panelPreview.Invalidate();
                }
            }
        }

        public MeshSelectForm()
        {
            InitializeComponent();
        }

        public MeshSelectForm(String _mesh)
            : this()
        {
            RefreshMeshes();
            if (_mesh != null)
                Mesh = _mesh;
        }

        private void RefreshMeshes()
        {
            // Is the list of meshes changed
            Mesh[] meshes = Meshes.global_meshes.MeshList;
            bool is_changed = (listBoxMeshes.Items.Count != meshes.Length);
            if (!is_changed)
            {
                for (int i = 0; i < meshes.Length; ++i)
                {
                    if (listBoxMeshes.Items[i] != meshes[i])
                    {
                        is_changed = true;
                        break;
                    }
                }
            }

            // Changed?
            if (is_changed)
            {
                listBoxMeshes.Items.Clear();
                listBoxMeshes.Items.AddRange(meshes);
                listBoxMeshes.SelectedIndex = -1;

                Mesh = Mesh; // Reselect the mesh
                panelPreview.Invalidate();
            }
        }

        private void panelPreview_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            int w = panelPreview.Width;
            int h = panelPreview.Height;

            g.Clear(Color.Black);

            if (w <= 0 || h <= 0)
                return;

            // Nothing on screen?
            if (listBoxMeshes.SelectedIndex == -1)
            {
                Pen pen = new Pen(Color.Red, 3.0f);
                g.DrawLine(pen, 0, 0, w, h);
                g.DrawLine(pen, 0, h, w, 0);
                return;
            }

            // Draw the mesh
            Mesh mesh = listBoxMeshes.SelectedItem as Mesh;
            if (mesh == null)
                return;

            // Get the scale and middle point
            RectangleF bbox = mesh.GetBoundingBox(1.0f, 0.0f);
            if (bbox.Width <= 0.0f || bbox.Height <= 0.0f)
                return;

            float scale_by_x = w / bbox.Width;
            float scale_by_y = h / bbox.Height;
            float scale = Math.Min(scale_by_x, scale_by_y);

            // Draw it
            mesh.Draw(g, w / 2, h / 2, scale, 0.0f, false);
        }

        private void buttonRefresh_Click(object sender, EventArgs e)
        {
            Meshes.global_meshes.Refresh();
            RefreshMeshes();
        }

        private void listBoxMeshes_SelectedIndexChanged(object sender, EventArgs e)
        {
            panelPreview.Invalidate();
            if (listBoxMeshes.SelectedIndex != -1)
                Mesh = ((Mesh)listBoxMeshes.SelectedItem).name;
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }
    }
}