////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.*;

public class CreditsScreen extends MenuBackgroundScreen
{
    private static String[] STRINGS =
    {
        "Stariffic",
        "-----------",
        "Made for the",
        "Assembly 2006",
        "",
        "Available for",
        "J2ME mobiles and",
        "java browsers",
        "",
        "More games at:",
        "http://www.xmunkki.org/",
        "",
        "",
        "- Credits -",
        "Programming & Lead",
        "Jere \"XMunkki\" Sanisalo",
        "",
        "Graphics",
        "Tomi Turunen",
        "",
        "Testing & Levels",
        "Maija \"Dibhda\" Parjanen",
        "",
        "Music",
        "Jetro \"tonic\" Lauha",
        "",
        "Sounds",
        "Jukka Nikkonen",
        "",
    };
    private static final int[] CHEAT_KEYS =
    {
        Canvas.KEY_NUM1,
        Canvas.KEY_NUM9,
        Canvas.KEY_NUM1,
        Canvas.KEY_NUM2,
        Canvas.KEY_NUM7,
        Canvas.KEY_NUM9,
    };
    
    private static final int SCROLL_SPEED = FP.toFP( 2 );
    
    private boolean m_ended;
    private int m_scroll;
    
    private int m_cheat_idx;
    private String m_cheat_txt;
    
    /**
     * Updates the screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public Screen updateFrame( int fp_secs )
    {
        if (m_ended)
            return new MainMenuScreen();
        m_scroll += FP.mul( fp_secs, SCROLL_SPEED );
        return null;
    }
    
    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public void render( Graphics g, int w, int h )
    {
        super.render( g, w, h );
        
        Font f = Font.getFont( Font.FACE_MONOSPACE, Font.STYLE_BOLD, Font.SIZE_LARGE );
        g.setFont( f );
        int text_h = f.getHeight();

        int y = h - FP.toInt(m_scroll*text_h);
        for ( int i = 0; i < STRINGS.length; ++i, y += text_h )
        {
            g.setColor( 0xffffffff );
            MiscUtils.writeCentered( g, STRINGS[i], y, w );
        }
        
        // Show the cheat text
        if ( m_cheat_txt != null )
        {
            g.setColor( 0xffffffff );
            MiscUtils.writeShadowed( g, m_cheat_txt, 2, 2 );
        }   
        
        // End of text?
        if ( y < 0 )
            m_ended = true;
    }

    public void keyPressed( int key, int game_key )
    {
        if ( key == CHEAT_KEYS[ m_cheat_idx ] )
        {
            ++m_cheat_idx;
            if ( m_cheat_idx >= CHEAT_KEYS.length )
            {
                Res.hiscores.all_levels_unlocked = true;
                m_cheat_txt = "All levels open!";
                m_cheat_idx = 0;
            }
            return;
        }
        
        if (game_key == Canvas.FIRE)
            m_ended = true;
    }
}
