/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends Screen {
    private static final int END_PAUSE = FP.toFP(1.5f);
    private String m_level_name;
    private int m_level_idx;
    private Level m_level;
    private int m_impulse = -1;
    private int m_rotate = 0;
    private boolean m_show_menu;
    private int m_end_pause;
    private boolean m_restart;

    public GameScreen(String level_name, int level_idx) {
        this.m_level_name = level_name;
        this.m_level_idx = level_idx;
        this.loadLevel();
    }

    public int GetLevelIndex() {
        return this.m_level_idx;
    }

    public Screen updateFrame(int fp_secs) {
        if (this.m_show_menu) {
            this.m_show_menu = false;
            return new GameMenuScreen(this);
        }
        boolean ended = false;
        if (this.m_level.star.is_at_home || this.m_level.star.is_dead || this.m_restart) {
            ended = true;
        }
        if (ended) {
            this.m_end_pause += fp_secs;
            if (this.m_restart) {
                this.m_end_pause = FP.toFP(10);
            }
            if (this.m_end_pause > END_PAUSE) {
                if (this.m_level.star.is_at_home && !this.m_restart && Res.editor_level_data == null) {
                    Res.hiscores.updateScore(this.m_level_idx, this.m_level.play_time);
                    return new LevelSelectScreen(this.m_level_idx);
                }
                this.loadLevel();
            }
        }
        if (!ended && this.m_impulse != -1) {
            this.m_level.star.addImpulse(this.m_impulse);
            this.m_impulse = -1;
        }
        if (!ended && this.m_rotate != -1) {
            this.m_level.star.addRotation(this.m_rotate);
            this.m_rotate = -1;
        }
        this.m_level.update(fp_secs);
        return null;
    }

    public void restart() {
        this.m_restart = true;
    }

    public void render(Graphics g, int w, int h) {
        g.setColor(-14667760);
        g.fillRect(0, 0, w, h);
        int aspect = FP.toFP(w) / h;
        int scale_x = 0;
        int scale_y = 0;
        int vis_w = this.m_level.screen_width;
        int vis_h = this.m_level.screen_height;
        if (aspect <= this.m_level.screen_aspect) {
            scale_x = scale_y = FP.div(FP.toFP(w), this.m_level.screen_width);
            vis_h = FP.mul(vis_h, FP.div(this.m_level.screen_aspect, aspect));
        } else {
            scale_x = scale_y = FP.div(FP.toFP(h), this.m_level.screen_height);
            vis_w = FP.mul(vis_w, FP.div(aspect, this.m_level.screen_aspect));
        }
        int top_x = this.m_level.star.getX() - (vis_w >> 1);
        int top_y = this.m_level.star.getY() - (vis_h >> 1);
        this.m_level.render(g, top_x, top_y, scale_x, scale_y, vis_w, vis_h, w, h);
        if (!Res.pc_mode) {
            Font f = Font.getFont((int)64, (int)3, (int)0);
            String str = "[#] Menu";
            int str_w = f.stringWidth(str);
            int str_h = f.getHeight();
            g.setColor(-15658735);
            g.setFont(f);
            g.fillRect(0, h - str_h - 2, 4 + str_w, 2 + str_h);
            g.setColor(-1);
            g.drawString(str, 2, h - str_h - 2, 20);
        }
    }

    public void keyPressed(int key, int game_key) {
        switch (key) {
            case 52: {
                this.m_rotate = 2;
                return;
            }
            case 54: {
                this.m_rotate = 0;
                return;
            }
            case 50: {
                this.m_rotate = 3;
                return;
            }
            case 56: {
                this.m_rotate = 1;
                return;
            }
            case 35: 
            case 42: {
                this.m_show_menu = true;
                return;
            }
        }
        if (Res.pc_mode && key == 27) {
            this.m_show_menu = true;
            return;
        }
        switch (game_key) {
            case 2: {
                this.m_rotate = 2;
                return;
            }
            case 5: {
                this.m_rotate = 0;
                return;
            }
            case 1: {
                this.m_rotate = 3;
                return;
            }
            case 6: {
                this.m_rotate = 1;
                return;
            }
        }
    }

    private void loadLevel() {
        this.m_end_pause = 0;
        this.m_restart = false;
        if (Res.editor_level_data != null) {
            this.m_level = new Level(Res.editor_level_data);
        } else {
            int top_score = Res.hiscores.getScore(this.m_level_idx);
            this.m_level = new Level(this.m_level_name, top_score);
        }
        Res.audio.playMusic(null);
        if ((this.m_level_idx & 1) == 0) {
            Res.audio.playMusic(Res.audio.music_game);
        } else {
            Res.audio.playMusic(Res.audio.music_game2);
        }
    }
}

