/*
 * Decompiled with CFR 0.152.
 */
public final class FP {
    public static final int SHIFT = 16;
    public static final int ZERO = 0;
    public static final int ONE = 65536;
    public static final int PI = 205887;
    public static final int PI2 = 411774;
    public static final int PI_HALF = 102943;
    private static final int[] SIN_TABLE;

    static {
        int[] nArray = new int[64];
        nArray[1] = 1608;
        nArray[2] = 3215;
        nArray[3] = 4821;
        nArray[4] = 6423;
        nArray[5] = 8022;
        nArray[6] = 9616;
        nArray[7] = 11204;
        nArray[8] = 12785;
        nArray[9] = 14359;
        nArray[10] = 15923;
        nArray[11] = 17479;
        nArray[12] = 19024;
        nArray[13] = 20557;
        nArray[14] = 22078;
        nArray[15] = 23586;
        nArray[16] = 25079;
        nArray[17] = 26557;
        nArray[18] = 28020;
        nArray[19] = 29465;
        nArray[20] = 30893;
        nArray[21] = 32302;
        nArray[22] = 33692;
        nArray[23] = 35061;
        nArray[24] = 36409;
        nArray[25] = 37736;
        nArray[26] = 39039;
        nArray[27] = 40319;
        nArray[28] = 41575;
        nArray[29] = 42806;
        nArray[30] = 44011;
        nArray[31] = 45189;
        nArray[32] = 46340;
        nArray[33] = 47464;
        nArray[34] = 48558;
        nArray[35] = 49624;
        nArray[36] = 50660;
        nArray[37] = 51665;
        nArray[38] = 52639;
        nArray[39] = 53581;
        nArray[40] = 54491;
        nArray[41] = 55368;
        nArray[42] = 56212;
        nArray[43] = 57022;
        nArray[44] = 57797;
        nArray[45] = 58538;
        nArray[46] = 59243;
        nArray[47] = 59913;
        nArray[48] = 60547;
        nArray[49] = 61144;
        nArray[50] = 61705;
        nArray[51] = 62228;
        nArray[52] = 62714;
        nArray[53] = 63162;
        nArray[54] = 63571;
        nArray[55] = 63943;
        nArray[56] = 64276;
        nArray[57] = 64571;
        nArray[58] = 64826;
        nArray[59] = 65043;
        nArray[60] = 65220;
        nArray[61] = 65358;
        nArray[62] = 65457;
        nArray[63] = 65516;
        SIN_TABLE = nArray;
    }

    public static final int toFP(int val) {
        return val << 16;
    }

    public static final int toFP(float val) {
        return (int)(val * 65536.0f);
    }

    public static final int toInt(int fp) {
        return fp >> 16;
    }

    public static final int toCeilInt(int fp) {
        return fp + 65535 >> 16;
    }

    public static final float toFloat(int fp) {
        return (float)fp / 65536.0f;
    }

    public static final String toString(int fp) {
        return String.valueOf(FP.toFloat(fp));
    }

    public static final int mul(int a, int b) {
        return (int)((long)a * (long)b >> 16);
    }

    public static final int div(int a, int b) {
        return (int)(((long)a << 16) / (long)b);
    }

    public static final int cos(int ang) {
        return FP.sin(ang + 102943);
    }

    public static final int sin(int ang) {
        boolean neg;
        while (ang < 0) {
            ang += 411774;
        }
        while (ang >= 411774) {
            ang -= 411774;
        }
        boolean bl = neg = ang >= 205887;
        if (neg) {
            ang -= 205887;
        }
        int val = ang < 102943 ? SIN_TABLE[FP.div((SIN_TABLE.length - 1) * ang, 102943) >> 16] : 65536 - SIN_TABLE[FP.div((SIN_TABLE.length - 1) * (ang - 102943), 102943) >> 16];
        return neg ? -val : val;
    }

    public static final int sqrt(int x) {
        if (x <= 0) {
            return 0;
        }
        int x_shift = 0;
        while (x >> x_shift > 131071) {
            x_shift += 2;
        }
        x <<= 14 - x_shift;
        x_shift >>= 1;
        int root = 0;
        int remHi = 0;
        int remLo = x;
        int count = 30;
        do {
            remHi = remHi << 2 | remLo >> 30 & 3;
            remLo <<= 2;
            int testDiv = ((root <<= 1) << 1) + 1;
            if (remHi < testDiv) continue;
            remHi -= testDiv;
            ++root;
        } while (count-- != 0);
        return root >> 14 - x_shift;
    }

    private FP() {
    }
}

