/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.Collidable;
import StarifficEditorGame.FP;
import StarifficEditorGame.LevelObject;
import StarifficEditorGame.Mesh;
import StarifficEditorGame.Res;
import StarifficEditorGame.Verlet;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ItemObject
extends LevelObject
implements Collidable {
    public static final int ITEM_GRAVITY_DIR = 0;
    public static final int ITEM_COLLECTIBLE = 1;
    private static final int RADIUS = FP.toFP(1.0f);
    private static final int HIT_RADIUS = 2 * RADIUS / 4;
    private static final int HIT_RADIUS2 = FP.mul(HIT_RADIUS, HIT_RADIUS);
    private static final int ARROW_LEN = FP.toFP(0.7f);
    private static final int ARROW_SIDE = FP.toFP(0.45f);
    private static final int ARROW_MOVE = FP.toFP(0.4f);
    public int pos_x;
    public int pos_y;
    public int type;
    private int m_gravity_dir;
    private int m_gravity_bounce;
    private static final int g_collectible_mesh_scale = FP.toFP(0.1f);
    private static int[] g_collectible_mesh_cache;
    private boolean m_collected;
    private Mesh m_collectible_mesh;
    private int m_collectible_mesh_angle;

    public int getType() {
        return this.type;
    }

    public void update(int time_secs) {
        this.m_gravity_bounce += time_secs * 3;
        while (this.m_gravity_bounce >= 411774) {
            this.m_gravity_bounce -= 411774;
        }
        this.m_collectible_mesh_angle = this.m_gravity_bounce;
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        switch (this.type) {
            case 0: {
                this.renderGravity(g, top_x, top_y, scale_x, scale_y);
                break;
            }
            case 1: {
                this.renderCollectible(g, top_x, top_y, scale_x, scale_y);
            }
        }
    }

    private void renderGravity(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        int cx = FP.mul(this.pos_x - top_x, scale_x);
        int cy = FP.mul(this.pos_y - top_y, scale_y);
        int move_sin = Math.abs(FP.sin(this.m_gravity_bounce));
        int move_amt = ARROW_MOVE / 2 - FP.mul(move_sin, ARROW_MOVE);
        move_amt = FP.mul(move_amt, scale_x);
        int dx = 0;
        int dy = 0;
        int nx = 0;
        int ny = 0;
        switch (this.m_gravity_dir) {
            case 2: {
                dx = FP.mul(-ARROW_LEN, scale_x);
                ny = FP.mul(-ARROW_SIDE, scale_x);
                cx -= move_amt;
                break;
            }
            case 0: {
                dx = FP.mul(ARROW_LEN, scale_x);
                ny = FP.mul(ARROW_SIDE, scale_x);
                cx += move_amt;
                break;
            }
            case 3: {
                dy = FP.mul(-ARROW_LEN, scale_y);
                nx = FP.mul(ARROW_SIDE, scale_y);
                cy -= move_amt;
                break;
            }
            case 1: {
                dy = FP.mul(ARROW_LEN, scale_y);
                nx = FP.mul(-ARROW_SIDE, scale_y);
                cy += move_amt;
                break;
            }
            default: {
                return;
            }
        }
        if (this.level.gravity_dir == this.m_gravity_dir) {
            g.setColor(-11184811);
        } else {
            int c = 68 + FP.toInt(187 * move_sin);
            g.setColor(0xFF000000 | c << 16 | c << 8);
        }
        g.fillTriangle(FP.toInt(cx + dx), FP.toInt(cy + dy), FP.toInt(cx - dx + nx), FP.toInt(cy - dy + ny), FP.toInt(cx - dx - nx), FP.toInt(cy - dy - ny));
    }

    private void renderCollectible(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        if (this.m_collected) {
            return;
        }
        if (this.m_collectible_mesh != null) {
            g_collectible_mesh_cache = this.m_collectible_mesh.render(g, g_collectible_mesh_scale, this.m_collectible_mesh_angle, this.pos_x - top_x, this.pos_y - top_y, scale_x, scale_y, g_collectible_mesh_cache);
        }
    }

    public void load(DataInputStream in) throws IOException {
        this.pos_x = in.readInt();
        this.pos_y = in.readInt();
        this.type = in.readByte();
        this.m_gravity_dir = in.readByte();
        if (this.type == 1) {
            this.m_collectible_mesh = Res.meshes.find("star");
        }
    }

    public void resolveCollision(Verlet v) {
        if (this.type == 0 && this.level.gravity_dir == this.m_gravity_dir) {
            return;
        }
        if (this.type == 1 && this.m_collected) {
            return;
        }
        int dx = v.pos[0] - this.pos_x;
        int dy = v.pos[1] - this.pos_y;
        if (Math.abs(dx) >= HIT_RADIUS || Math.abs(dy) >= HIT_RADIUS) {
            return;
        }
        int dist2 = FP.mul(dx, dx) + FP.mul(dy, dy);
        if (dist2 >= HIT_RADIUS2) {
            return;
        }
        if (this.type == 0) {
            this.level.setGravity(this.m_gravity_dir);
            Res.audio.playSound(Res.audio.sound_grav);
        }
        if (this.type == 1) {
            this.m_collected = true;
            --this.level.collectibles_left;
            Res.audio.playSound(Res.audio.sound_item);
        }
    }
}

