using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace StarifficEditor
{
    public class LevelManifest
    {
        private class Entry
        {
            public String name;
            public String dest_name;

            public float time_bronze;
            public float time_silver;
            public float time_gold;
        }

        private List<Entry> m_entries;

        public LevelManifest()
        {
            m_entries = new List<Entry>();
        }

        public void AddLevel(Level level, String dest_name)
        {
            Entry e = new Entry();
            e.name = level.options.Name;
            e.dest_name = dest_name;

            e.time_bronze = level.options.TimeBronze;
            e.time_silver = level.options.TimeSilver;
            e.time_gold = level.options.TimeGold;

            m_entries.Add(e);
        }

        public bool Export(String filename)
        {
            // Write the file
            try
            {
                using (FileStream file_out = new FileStream(filename, FileMode.Create, FileAccess.Write))
                {
                    JavaBinaryWriter fout = new JavaBinaryWriter(file_out);

                    fout.Write( (int)(DateTime.Now.Ticks / 10000000L) ); // Some semirandom manifest id

                    fout.Write((short)m_entries.Count);
                    foreach (Entry e in m_entries)
                    {
                        fout.Write(e.name);
                        fout.Write(e.dest_name);

                        fout.WriteFixed(e.time_bronze);
                        fout.WriteFixed(e.time_silver);
                        fout.WriteFixed(e.time_gold);
                    }
                }
            }
            catch (Exception)
            {
                return false;
            }

            return true;
        }
    }
}
