////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import java.io.*;
import java.util.*;
import javax.microedition.lcdui.*;

/** 
 * The game star.
 */
public class Star extends LevelObject
{
    public boolean is_at_home;
    public boolean is_dead;
    
    private Verlet m_verlet_center;
    private Verlet m_verlet_top;
    private Verlet m_verlet_topleft;
    private Verlet m_verlet_topright;
    private Verlet m_verlet_bottomleft;
    private Verlet m_verlet_bottomright;
    private Verlet[] m_verlets;
    
    private int m_dist_to_center;
    private int m_dist_to_extent;
    private int m_dist_split;
    
    private int[] m_intpos_center;
    private int[] m_intpos_top;
    private int[] m_intpos_topleft;
    private int[] m_intpos_topright;
    private int[] m_intpos_bottomleft;
    private int[] m_intpos_bottomright;

    private int[] m_intpos_middle1;
    private int[] m_intpos_middle2;
    private int[] m_intpos_middle3;
    private int[] m_intpos_middle4;
    private int[] m_intpos_middle5;
    
    private Vector m_hit_objects;
    
    private int m_particle_shine_delay;
    
    private int m_draw_scale = FP.ONE;
    
    public Star()
    {
        m_verlet_center = new Verlet();
        m_verlet_top = new Verlet();
        m_verlet_topleft = new Verlet();
        m_verlet_topright = new Verlet();
        m_verlet_bottomleft = new Verlet();
        m_verlet_bottomright = new Verlet();
        m_verlets = new Verlet[]
                               {
                m_verlet_top,
                m_verlet_topright,
                m_verlet_bottomright,
                m_verlet_bottomleft,
                m_verlet_topleft,
                m_verlet_center,
                               };

        m_intpos_center = new int[ 2 ];
        m_intpos_top = new int[ 2 ];
        m_intpos_topleft = new int[ 2 ];
        m_intpos_topright = new int[ 2 ];
        m_intpos_bottomleft = new int[ 2 ];
        m_intpos_bottomright = new int[ 2 ];
        
        m_intpos_middle1 = new int[ 2 ];
        m_intpos_middle2 = new int[ 2 ];
        m_intpos_middle3 = new int[ 2 ];
        m_intpos_middle4 = new int[ 2 ];
        m_intpos_middle5 = new int[ 2 ];
        
        m_hit_objects = new Vector();
        
        reset( Vec2.create() );
    }
    
    /**
     * Returns the x coordinate.
     * 
     * @return Returns the x coordinate.
     */
    public int getX()
    {
        return m_verlet_center.pos[0];
    }
    
    /**
     * Returns the y coordinate.
     * 
     * @return Returns the y coordinate.
     */
    public int getY()
    {
        return m_verlet_center.pos[1];
    }
    
    /**
     * Resets the star and it's position.
     * 
     * @param pos The position to reset at.
     */
    public void reset( int[] pos )
    {
        int[] temp = Vec2.create();
        
        // Set the verlet positions
        m_verlet_center.resetPos( pos );
        
        Vec2.addScaled( temp, pos, g_star_dirs[0], g_star_size );
        m_verlet_top.resetPos( temp );
        
        Vec2.addScaled( temp, pos, g_star_dirs[1], g_star_size );
        m_verlet_topright.resetPos( temp );
        
        Vec2.addScaled( temp, pos, g_star_dirs[2], g_star_size );
        m_verlet_bottomright.resetPos( temp );
        
        Vec2.addScaled( temp, pos, g_star_dirs[3], g_star_size );
        m_verlet_bottomleft.resetPos( temp );
        
        Vec2.addScaled( temp, pos, g_star_dirs[4], g_star_size );
        m_verlet_topleft.resetPos( temp );
        
        // Create the constraints
        m_dist_to_center = Vec2.dist( m_verlets[0].pos, m_verlet_center.pos );
        m_dist_to_extent = Vec2.dist( m_verlets[0].pos, m_verlets[1].pos );
        m_dist_split = Vec2.dist( m_verlets[0].pos, m_verlets[2].pos );
    }
    
    /**
     * Marks the star as being completed (went home).
     */
    public void completed()
    {
        if ( is_at_home || is_dead )
            return;
        is_at_home = true;

        // Play the sound
        Res.audio.playSound( Res.audio.sound_win );
    }
    
    /**
     * Kills the star.
     */
    public void kill()
    {
        if ( is_dead || is_at_home )
            return;
        is_dead = true;
        
        // Add death particles
        for ( int i = 0; i < 32; ++i )
        {
            int v = Res.random.nextInt( 5 );
            int t = Res.random.nextInt( FP.ONE );
            
            Vec2.sub( g_temp_vec, m_verlets[v].pos, m_verlet_center.pos );
            
            m_verlet_center.getVelocity( g_temp_vec2 );
            Vec2.scale( g_temp_vec2, FP.toFP(30) );
            g_temp_vec2[0] += -FP.ONE*2 + Res.random.nextInt( FP.ONE*4 );
            g_temp_vec2[1] += -FP.ONE*3 + Res.random.nextInt( FP.ONE*4 );
            
            Vec2.addScaled( g_temp_vec, m_verlet_center.pos, g_temp_vec, t );
            level.particles.addParticle( g_temp_vec, g_temp_vec2, 0xffcccc00, FP.ONE * 3 );
        }

        // Play the sound
        Res.audio.playSound( Res.audio.sound_die );
    }
    
    /**
     * Adds an impulse to the given corner.
     * 
     * @param idx The corner index.
     */
    public void addImpulse( int idx )
    {
        Vec2.sub( g_temp_vec, m_verlets[ idx ].pos, m_verlet_center.pos );
        Vec2.normalize( g_temp_vec );
        Vec2.scale( g_temp_vec, g_impulse_force );
        
        m_verlets[ idx ].addVelocity( g_temp_vec );
        
        m_verlet_center.addVelocity( g_temp_vec );
    }
    
    /**
     * Adds rotation force to each star verlet.
     * 
     * @param dir The rotation direction; Level.DIR_*
     */
    public void addRotation( int dir )
    {
        boolean inv_force = false;
        
        switch (level.gravity_dir)
        {
        case Level.DIR_DOWN:
            if (dir == Level.DIR_LEFT) inv_force = true;
            else if (dir == Level.DIR_RIGHT) inv_force = false;
            else return;
            break;

        case Level.DIR_UP:
            if (dir == Level.DIR_LEFT) inv_force = false;
            else if (dir == Level.DIR_RIGHT) inv_force = true;
            else return;
            break;

        case Level.DIR_LEFT:
            if (dir == Level.DIR_UP) inv_force = true;
            else if (dir == Level.DIR_DOWN) inv_force = false;
            else return;
            break;

        case Level.DIR_RIGHT:
            if (dir == Level.DIR_UP) inv_force = false;
            else if (dir == Level.DIR_DOWN) inv_force = true;
            else return;
            break;
        }
        
        int force = g_rotation_force;
        if (inv_force)
            force = -force;
        
        for (int i = 0; i < 5; ++i)
        {
            Vec2.sub( g_temp_vec, m_verlets[ i ].pos, m_verlet_center.pos );
            Vec2.normalize( g_temp_vec );
            Vec2.scale( g_temp_vec, force );
//          Vec2.set( g_temp_vec2, g_temp_vec );
            Vec2.makeNormal( g_temp_vec );
//          Vec2.addScaled( g_temp_vec, g_temp_vec, g_temp_vec2, FP.toFP(0.f) );
            
            m_verlets[ i ].addVelocity( g_temp_vec );
        }
    }
    
    /**
     * Bumps the star via the given verlet, normal and power.
     */
    public void bump(Verlet v, int nx, int ny, int power)
    {
//      v.bump( nx, ny, power );
//      if ( v != m_verlet_center ) m_verlet_center.bump( nx, ny, power );
        
        int power_sec = (power * 8) / 10; 
        for ( int i = 0; i < m_verlets.length; ++i )
        {
            Verlet ver = m_verlets[i];
            ver.bump( nx, ny, (ver==v) ? power : power_sec );
        }

        // Play the sound
        Res.audio.playSound( Res.audio.sound_bump );
    }
    
    /**
     * Updates the star.
     * 
     * @param time_secs
     */
    public void update( int time_secs )
    {
        // Finished??
        if ( is_at_home )
        {
            m_draw_scale = FP.mul( m_draw_scale, g_end_shrink_mul );
            if ( m_draw_scale < 1000 )
                m_draw_scale = 0;
            
            // Add a particle?
            m_particle_shine_delay -= time_secs;
            while ( m_particle_shine_delay < 0 )
            {
                for ( int i = 0; i < 3; ++i )
                {
                    g_temp_vec[0] = -FP.ONE*5 + Res.random.nextInt( FP.ONE*5*2 );
                    g_temp_vec[1] = -FP.ONE*5 + Res.random.nextInt( FP.ONE*5*2 );
                    
                    level.particles.addParticle( m_verlet_center.pos, g_temp_vec, 0xffffff20, FP.ONE );
                }
                m_particle_shine_delay += g_particle_add_time;
            }
            return;
        }
        
        // Integrate the verlets
        int time_2 = FP.mul( time_secs, time_secs );
        
        for ( int i = 0; i < m_verlets.length; ++i )
            m_verlets[ i ].integrate( time_2, level.gravity_vec );
        
        // Fix the integrity (if points go "through" to the wrong side)
        for ( int i = 0; i < 5; ++i )
        {
            int idx1 = (i+2) % 5;
//          int idx2 = (i+3) % 5;

            lineConstraint( m_verlets[ i ], m_verlets[ idx1 ], m_dist_split );
//			lineConstraint( m_verlets[ i ], m_verlets[ idx2 ], m_dist_split );
        }
        
        // Distances from center
        for ( int i = 0; i < 5; ++i )
        {
            lineConstraint( m_verlets[ i ], m_verlet_center, m_dist_to_center );
        }
        
        // Distances from each other
        for ( int i = 0; i < 5; ++i )
        {
            int i2 = (i+1) % 5;
            
			lineConstraint( m_verlets[ i ], m_verlets[ i2 ], m_dist_to_extent );
        }
        
        // Find the visible objects for the border constraints
        updateBoundingBox();
        level.regionFetch( bounding_box, m_hit_objects );

        // Border constraints
        for ( int i = 0; i < m_verlets.length; ++i )
        {
			borderConstraint( m_verlets[ i ] );
        }
        borderConstraint( m_verlet_center );
        
        // Update the bbox
        updateBoundingBox();
        
        // Add moving particles?
        if (!is_at_home && !is_dead)
        {
            m_particle_shine_delay -= time_secs;
            while ( m_particle_shine_delay < 0 )
            {
/*                m_verlet_center.getVelocity(g_temp_vec);
                
                m_particles.addParticle( m_verlet_center.pos, g_temp_vec, 0xffcccc00, FP.ONE );*/
                m_particle_shine_delay += g_particle_add_time;
            }
        }
    }
    
    private void lineConstraint( Verlet v1, Verlet v2, int req_dist )
    {
		Vec2.sub( g_temp_vec, v2.pos, v1.pos );
        int delta_len = Vec2.normalize( g_temp_vec );
        if ( delta_len <= 0 )
            return;
        delta_len = (req_dist - delta_len) >> 1;
        
        for ( int j = 0; j < 2;++j )
        {
            v1.pos[ j ] -= FP.mul( g_temp_vec[ j ], delta_len );
            v2.pos[ j ] += FP.mul( g_temp_vec[ j ], delta_len );
        }
    }
    
    private static final int[] g_tangent_horiz = { 0x10000, 0 };
    private static final int[] g_tangent_vert = { 0, 0x10000 };
    private static final int g_friction_amount = FP.toFP( 0.95f );
    private void borderConstraint( Verlet v )
    {
        int amt = m_hit_objects.size();
        for ( int i = 0; i < amt; ++i )
        {
            LevelObject obj = (LevelObject) m_hit_objects.elementAt(i);
            if (!(obj instanceof Collidable))
                continue;
            
        	((Collidable) obj).resolveCollision(v);
        }
    }
    
    /**
     * Updates the bounding box for the star.
     */
    private void updateBoundingBox()
    {
        bounding_box.x1 = bounding_box.x2 = m_verlet_center.pos[0];
        bounding_box.y1 = bounding_box.y2 = m_verlet_center.pos[1];
        
        int size2 = g_star_size;
        bounding_box.x1 -= size2;
        bounding_box.y1 -= size2;
        bounding_box.x2 += size2;
        bounding_box.y2 += size2;
    }
    
    /**
     * Renders the level object.
     */
    public void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        if ( is_dead )
            return;
        
        // Get the integer values
        Vec2.getScaledInt( m_intpos_center, m_verlet_center.pos, top_x, top_y, scale_x, scale_y );
        Vec2.getScaledInt( m_intpos_top, m_verlet_top.pos, top_x, top_y, scale_x, scale_y );
        Vec2.getScaledInt( m_intpos_topleft, m_verlet_topleft.pos, top_x, top_y, scale_x, scale_y );
        Vec2.getScaledInt( m_intpos_topright, m_verlet_topright.pos, top_x, top_y, scale_x, scale_y );
        Vec2.getScaledInt( m_intpos_bottomleft, m_verlet_bottomleft.pos, top_x, top_y, scale_x, scale_y );
        Vec2.getScaledInt( m_intpos_bottomright, m_verlet_bottomright.pos, top_x, top_y, scale_x, scale_y );
        
        getMidPoint( m_intpos_middle1, m_verlet_topleft, m_verlet_top, g_star_mid_scale, top_x, top_y, scale_x, scale_y );
        getMidPoint( m_intpos_middle2, m_verlet_top, m_verlet_topright, g_star_mid_scale, top_x, top_y, scale_x, scale_y );
        getMidPoint( m_intpos_middle3, m_verlet_topright, m_verlet_bottomright, g_star_mid_scale, top_x, top_y, scale_x, scale_y );
        getMidPoint( m_intpos_middle4, m_verlet_bottomright, m_verlet_bottomleft, g_star_mid_scale, top_x, top_y, scale_x, scale_y );
        getMidPoint( m_intpos_middle5, m_verlet_bottomleft, m_verlet_topleft, g_star_mid_scale, top_x, top_y, scale_x, scale_y );

        // Scale?
        if ( m_draw_scale != FP.ONE )
        {
            if ( m_draw_scale <= 0 )
                return;
            scaleIntPoint( m_intpos_top, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_topleft, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_topright, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_bottomleft, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_bottomright, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_middle1, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_middle2, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_middle3, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_middle4, m_intpos_center, m_draw_scale );
            scaleIntPoint( m_intpos_middle5, m_intpos_center, m_draw_scale );
        }
        
        // Draw the star extends
		g.setColor( 0xffffff00 );
        g.fillTriangle( m_intpos_middle5[0],m_intpos_middle5[1],  m_intpos_middle1[0],m_intpos_middle1[1],  m_intpos_topleft[0],m_intpos_topleft[1] );
        g.fillTriangle( m_intpos_middle1[0],m_intpos_middle1[1],  m_intpos_middle2[0],m_intpos_middle2[1],  m_intpos_top[0],m_intpos_top[1] );
        g.fillTriangle( m_intpos_middle2[0],m_intpos_middle2[1],  m_intpos_middle3[0],m_intpos_middle3[1],  m_intpos_topright[0],m_intpos_topright[1] );
        g.fillTriangle( m_intpos_middle3[0],m_intpos_middle3[1],  m_intpos_middle4[0],m_intpos_middle4[1],  m_intpos_bottomright[0],m_intpos_bottomright[1] );
        g.fillTriangle( m_intpos_middle4[0],m_intpos_middle4[1],  m_intpos_middle5[0],m_intpos_middle5[1],  m_intpos_bottomleft[0],m_intpos_bottomleft[1] );
        
        // Draw the interior
        g.setColor( 0xffffff00 );
        g.fillTriangle( m_intpos_middle1[0],m_intpos_middle1[1],  m_intpos_middle2[0],m_intpos_middle2[1],  m_intpos_middle3[0],m_intpos_middle3[1] );
        g.fillTriangle( m_intpos_middle1[0],m_intpos_middle1[1],  m_intpos_middle3[0],m_intpos_middle3[1],  m_intpos_middle4[0],m_intpos_middle4[1] );
        g.fillTriangle( m_intpos_middle1[0],m_intpos_middle1[1],  m_intpos_middle4[0],m_intpos_middle4[1],  m_intpos_middle5[0],m_intpos_middle5[1] );

        // Outline the borders
        g.setColor( 0xff333300 );
        g.drawLine( m_intpos_top[0], m_intpos_top[1], m_intpos_middle1[0], m_intpos_middle1[1] );
        g.drawLine( m_intpos_top[0], m_intpos_top[1], m_intpos_middle2[0], m_intpos_middle2[1] );
        g.drawLine( m_intpos_topright[0], m_intpos_topright[1], m_intpos_middle2[0], m_intpos_middle2[1] );
        g.drawLine( m_intpos_topright[0], m_intpos_topright[1], m_intpos_middle3[0], m_intpos_middle3[1] );
        g.drawLine( m_intpos_bottomright[0], m_intpos_bottomright[1], m_intpos_middle3[0], m_intpos_middle3[1] );
        g.drawLine( m_intpos_bottomright[0], m_intpos_bottomright[1], m_intpos_middle4[0], m_intpos_middle4[1] );
        g.drawLine( m_intpos_bottomleft[0], m_intpos_bottomleft[1], m_intpos_middle4[0], m_intpos_middle4[1] );
        g.drawLine( m_intpos_bottomleft[0], m_intpos_bottomleft[1], m_intpos_middle5[0], m_intpos_middle5[1] );
        g.drawLine( m_intpos_topleft[0], m_intpos_topleft[1], m_intpos_middle5[0], m_intpos_middle5[1] );
        g.drawLine( m_intpos_topleft[0], m_intpos_topleft[1], m_intpos_middle1[0], m_intpos_middle1[1] );
        
        // Draw the face
        if (true)
        {
            int mouth_size = FP.mul(g_star_mouth_size, scale_x);
            if ( m_draw_scale != FP.ONE )
                mouth_size = FP.mul( mouth_size, m_draw_scale );
            mouth_size = FP.toInt( mouth_size );
            
            int mouth_size2 = mouth_size / 2;
            int mouth_size4 = mouth_size / 4;
            int x, y;

            if ( mouth_size <= 0 ) mouth_size = 1;
            if ( mouth_size2 <= 0 ) mouth_size2 = 1;
            if ( mouth_size4 <= 0 ) mouth_size4 = 1;
            
            // Eye 1
            g.setColor( 0xffffffff );
            x = (m_intpos_center[0] + m_intpos_middle1[0]*2)/3;
            y = (m_intpos_center[1] + m_intpos_middle1[1]*2)/3;
            g.fillArc( x-mouth_size2, y-mouth_size2, mouth_size, mouth_size, 0, 360 );
            g.setColor( 0xff000000 );
            g.fillArc( x-mouth_size4, y-mouth_size4, mouth_size2, mouth_size2, 0, 360 );
            
            // Eye 2
            g.setColor( 0xffffffff );
            x = (m_intpos_center[0] + m_intpos_middle2[0]*2)/3;
            y = (m_intpos_center[1] + m_intpos_middle2[1]*2)/3;
            g.fillArc( x-mouth_size2, y-mouth_size2, mouth_size, mouth_size, 0, 360 );
            g.setColor( 0xff000000 );
            g.fillArc( x-mouth_size4, y-mouth_size4, mouth_size2, mouth_size2, 0, 360 );
            
            // Mouth
            g.setColor( 0xff222200 );
            x = (m_intpos_center[0]*6 + m_intpos_middle1[0] + m_intpos_middle2[0]) / 8;
            y = (m_intpos_center[1]*6 + m_intpos_middle1[1] + m_intpos_middle2[1]) / 8;
//          x = (m_intpos_center[0]*3 + m_intpos_middle4[0]*2)/5;
//          y = (m_intpos_center[1]*3 + m_intpos_middle4[1]*2)/5;
            g.fillArc( x-mouth_size4, y-mouth_size4, mouth_size2, mouth_size2, 0, 360 );
        }
        
        // Number backgrounds
/*        g.setFont( Font.getFont( Font.FACE_MONOSPACE, 0, Font.SIZE_SMALL ) );
        int font_w = g.getFont().charWidth( '2' );
        int font_h = g.getFont().getHeight();
        int font_w2 = font_w/2;
        int font_h2 = font_h/2;
        
        g.setColor( 0x9f202020);
        g.fillRect( m_intpos_top[0] - font_w2, m_intpos_top[1] - font_h2, font_w, font_h );
        g.fillRect( m_intpos_topleft[0] - font_w2, m_intpos_topleft[1] - font_h2, font_w, font_h );
        g.fillRect( m_intpos_topright[0] - font_w2, m_intpos_topright[1] - font_h2, font_w, font_h );
        g.fillRect( m_intpos_bottomleft[0] - font_w2, m_intpos_bottomleft[1] - font_h2, font_w, font_h );
        g.fillRect( m_intpos_bottomright[0] - font_w2, m_intpos_bottomright[1] - font_h2, font_w, font_h );
        
        // Draw the numbers
        g.setColor( 0xffffffff );
        g.drawString( "2", m_intpos_top[ 0 ] - font_w2, m_intpos_top[ 1 ] - font_h2, Graphics.LEFT | Graphics.TOP );
        g.drawString( "4", m_intpos_topleft[ 0 ] - font_w2, m_intpos_topleft[ 1 ] - font_h2, Graphics.LEFT | Graphics.TOP );
        g.drawString( "6", m_intpos_topright[ 0 ] - font_w2, m_intpos_topright[ 1 ] - font_h2, Graphics.LEFT | Graphics.TOP );
        g.drawString( "7", m_intpos_bottomleft[ 0 ] - font_w2, m_intpos_bottomleft[ 1 ] - font_h2, Graphics.LEFT | Graphics.TOP );
        g.drawString( "9", m_intpos_bottomright[ 0 ] - font_w2, m_intpos_bottomright[ 1 ] - font_h2, Graphics.LEFT | Graphics.TOP );*/
        
        // Debugs
//		renderDebug( g );
    }
    
    private void getMidPoint( int[] dest, Verlet v1, Verlet v2, int scale, int top_x, int top_y, int scale_x, int scale_y )
    {
        int[] center = m_verlet_center.pos;
        
        scale >>= 1;
        dest[ 0 ] = center[0] + FP.mul( (v1.pos[0]-center[0]) + (v2.pos[0]-center[0]), scale ); 
        dest[ 1 ] = center[1] + FP.mul( (v1.pos[1]-center[1]) + (v2.pos[1]-center[1]), scale ); 
        
        dest[ 0 ] = FP.toInt( FP.mul(dest[ 0 ]-top_x, scale_x) );
        dest[ 1 ] = FP.toInt( FP.mul(dest[ 1 ]-top_y, scale_y) );
    }
    
    private void scaleIntPoint( int[] pt, int[] center, int scale )
    {
        pt[0] = center[0] + FP.toInt(scale * (pt[0] - center[0]));
        pt[1] = center[1] + FP.toInt(scale * (pt[1] - center[1]));
    }
    
    /**
     * Debug rendering.
     */
    private void renderDebug( Graphics g )
    {
        // Lines to center
        g.setColor( 0xff20ef70 );
        g.drawLine( m_intpos_top[0], m_intpos_top[1], m_intpos_center[0], m_intpos_center[1] );
        g.drawLine( m_intpos_topleft[0], m_intpos_topleft[1], m_intpos_center[0], m_intpos_center[1] );
        g.drawLine( m_intpos_topright[0], m_intpos_topright[1], m_intpos_center[0], m_intpos_center[1] );
        g.drawLine( m_intpos_bottomleft[0], m_intpos_bottomleft[1], m_intpos_center[0], m_intpos_center[1] );
        g.drawLine( m_intpos_bottomright[0], m_intpos_bottomright[1], m_intpos_center[0], m_intpos_center[1] );
        
        // Border lines
        g.setColor( 0xff3080ff );
        g.drawLine( m_intpos_top[0], m_intpos_top[1], m_intpos_topright[0], m_intpos_topright[1] );
        g.drawLine( m_intpos_topright[0], m_intpos_topright[1], m_intpos_bottomright[0], m_intpos_bottomright[1] );
        g.drawLine( m_intpos_bottomright[0], m_intpos_bottomright[1], m_intpos_bottomleft[0], m_intpos_bottomleft[1] );
        g.drawLine( m_intpos_bottomleft[0], m_intpos_bottomleft[1], m_intpos_topleft[0], m_intpos_topleft[1] );
        g.drawLine( m_intpos_topleft[0], m_intpos_topleft[1], m_intpos_top[0], m_intpos_top[1] );

        // Border lines
        g.setColor( 0xff3080ff );
        g.drawLine( m_intpos_top[0], m_intpos_top[1], m_intpos_bottomright[0], m_intpos_bottomright[1] );
        g.drawLine( m_intpos_topright[0], m_intpos_topright[1], m_intpos_bottomleft[0], m_intpos_bottomleft[1] );
        g.drawLine( m_intpos_bottomright[0], m_intpos_bottomright[1], m_intpos_topleft[0], m_intpos_topleft[1] );
        g.drawLine( m_intpos_bottomleft[0], m_intpos_bottomleft[1], m_intpos_top[0], m_intpos_top[1] );
        g.drawLine( m_intpos_topleft[0], m_intpos_topleft[1], m_intpos_topright[0], m_intpos_topright[1] );

        // Corners
        g.setColor( 0xffff0000);
        g.fillRect( m_intpos_center[0] - 1, m_intpos_center[1] - 1, 3, 3 );
        g.fillRect( m_intpos_top[0] - 1, m_intpos_top[1] - 1, 3, 3 );
        g.fillRect( m_intpos_topleft[0] - 1, m_intpos_topleft[1] - 1, 3, 3 );
        g.fillRect( m_intpos_topright[0] - 1, m_intpos_topright[1] - 1, 3, 3 );
        g.fillRect( m_intpos_bottomleft[0] - 1, m_intpos_bottomleft[1] - 1, 3, 3 );
        g.fillRect( m_intpos_bottomright[0] - 1, m_intpos_bottomright[1] - 1, 3, 3 );

        // Interior corners
        g.setColor( 0xff8f0000);
        g.fillRect( m_intpos_middle1[0] - 1, m_intpos_middle1[1] - 1, 3, 3 );
        g.fillRect( m_intpos_middle2[0] - 1, m_intpos_middle2[1] - 1, 3, 3 );
        g.fillRect( m_intpos_middle3[0] - 1, m_intpos_middle3[1] - 1, 3, 3 );
        g.fillRect( m_intpos_middle4[0] - 1, m_intpos_middle4[1] - 1, 3, 3 );
        g.fillRect( m_intpos_middle5[0] - 1, m_intpos_middle5[1] - 1, 3, 3 );
    }
    
    /**
     * Loads the object from the stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    public void load(DataInputStream in) throws IOException
    {
        // Read the starting position
        int pos_x = in.readInt();
        int pos_y = in.readInt();
        reset( Vec2.create(pos_x, pos_y) );
    }
    
    private static final int[] g_temp_vec = new int[ 2 ];
    private static final int[] g_temp_vec2 = new int[ 2 ];
    
    private static final int g_star_size = FP.toFP( 1 );
    private static final int g_star_center_ball_size = FP.mul( g_star_size, FP.toFP( 0.4f ) );
    private static final int g_star_mid_scale = FP.toFP( 0.5f );
    private static final int g_star_mouth_size = FP.toFP( 0.4f );
    
    private static final int g_impulse_force = FP.toFP( 0.35f );
    private static final int g_rotation_force = FP.toFP( 0.35f );
    
    private static final int g_particle_add_time = FP.toFP( 0.1f );
    private static final int g_end_shrink_mul = FP.toFP( 0.85f );
    
    private static final int[][] g_star_dirs =
    {
            { 0, -65536 },
            { 62328, -20251 },
            { 38521, 53019 },
            { -38521, 53019 },
            { -62328, -20251 },
    };
}
