/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class Graphics {
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    private java.awt.Graphics m_g;
    private Font m_font;
    private int m_color = -16777216;
    private Color m_color_o;
    private int[] m_poly_x = new int[3];
    private int[] m_poly_y = new int[3];

    public Graphics(java.awt.Graphics g) {
        this.m_g = g;
        this.m_font = Font.getFont(0, 0, 0);
        this.setColor(-16777216);
    }

    public void setColor(int color) {
        this.m_color = color;
        this.m_color_o = new Color(color, true);
    }

    public int getColor() {
        return this.m_color;
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void fillRect(int x, int y, int w, int h) {
        this.m_g.setColor(this.m_color_o);
        this.m_g.fillRect(x, y, w, h);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.m_poly_x[0] = x1;
        this.m_poly_x[1] = x2;
        this.m_poly_x[2] = x3;
        this.m_poly_y[0] = y1;
        this.m_poly_y[1] = y2;
        this.m_poly_y[2] = y3;
        this.m_g.setColor(this.m_color_o);
        this.m_g.fillPolygon(this.m_poly_x, this.m_poly_y, 3);
    }

    public void drawArc(int x, int y, int w, int h, int ang1, int ang2) {
        this.m_g.setColor(this.m_color_o);
        this.m_g.drawArc(x, y, w, h, ang1, ang2);
    }

    public void fillArc(int x, int y, int w, int h, int ang1, int ang2) {
        this.m_g.setColor(this.m_color_o);
        this.m_g.fillArc(x, y, w, h, ang1, ang2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_g.setColor(this.m_color_o);
        this.m_g.drawLine(x1, y1, x2, y2);
    }

    public void drawImage(Image img, int x, int y, int handle) {
        if ((handle & 1) != 0) {
            x -= img.getWidth() / 2;
        }
        if ((handle & 8) != 0) {
            x -= img.getWidth();
        }
        if ((handle & 2) != 0) {
            y -= img.getHeight() / 2;
        }
        if ((handle & 0x20) != 0) {
            y -= img.getHeight();
        }
        this.m_g.drawImage(img.m_bitmap, x, y, null);
    }

    public void drawString(String str, int x, int y, int handle) {
        this.m_g.setColor(this.m_color_o);
        this.m_g.setFont(this.m_font.font);
        this.m_g.drawString(str, x, y + this.m_font.getBaselinePosition());
    }
}

