/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.BoundingBox;
import StarifficEditorGame.FP;
import StarifficEditorGame.Goal;
import StarifficEditorGame.ItemObject;
import StarifficEditorGame.LevelObject;
import StarifficEditorGame.MeshObject;
import StarifficEditorGame.MiscUtils;
import StarifficEditorGame.ParticleSystem;
import StarifficEditorGame.Res;
import StarifficEditorGame.Star;
import StarifficEditorGame.Vec2;
import StarifficEditorGame.WallRectangle;
import StarifficEditorGame.WallSphere;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Level {
    public static final int DIR_RIGHT = 0;
    public static final int DIR_DOWN = 1;
    public static final int DIR_LEFT = 2;
    public static final int DIR_UP = 3;
    public int screen_width;
    public int screen_height;
    public int screen_aspect;
    public BoundingBox level_bbox;
    public LevelObject[] objects;
    public Star star;
    public Goal goal;
    public ParticleSystem particles;
    private int m_fetch_cache_number;
    public int time_bronze;
    public int time_silver;
    public int time_gold;
    public int current_top_score = FP.toFP(-1);
    public int play_time;
    public int collectibles_left;
    public int gravity;
    public int gravity_dir = 1;
    public int[] gravity_vec = Vec2.create(0, this.gravity);
    private int m_grid_x;
    private int m_grid_y;
    private int m_grid_slot_size;
    private int m_grid_w;
    private int m_grid_h;
    private LevelObject[][][] m_grid;
    private int m_search_x1;
    private int m_search_x2;
    private int m_search_y1;
    private int m_search_y2;
    private BoundingBox m_screen_box = new BoundingBox();
    private Vector m_screen_objs = new Vector();

    public Level(byte[] data) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            this.loadLevel(new DataInputStream(in));
            ((InputStream)in).close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error loading the level: " + t);
        }
    }

    public Level(String res_name, int top_score) {
        try {
            InputStream in = Res.getResourceAsStream(res_name);
            this.loadLevel(new DataInputStream(in));
            in.close();
            this.current_top_score = top_score;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error loading the level: " + t);
        }
    }

    public void setGravity(int dir) {
        this.gravity_dir = dir;
        switch (dir) {
            case 0: {
                this.gravity_vec[0] = this.gravity;
                this.gravity_vec[1] = 0;
                break;
            }
            case 1: {
                this.gravity_vec[0] = 0;
                this.gravity_vec[1] = this.gravity;
                break;
            }
            case 2: {
                this.gravity_vec[0] = -this.gravity;
                this.gravity_vec[1] = 0;
                break;
            }
            case 3: {
                this.gravity_vec[0] = 0;
                this.gravity_vec[1] = -this.gravity;
            }
        }
    }

    public void regionFetch(BoundingBox bbox, Vector dest_list) {
        int cache;
        dest_list.removeAllElements();
        if (!this.getBoundingBoxRegion(bbox)) {
            return;
        }
        if ((cache = ++this.m_fetch_cache_number) < 0) {
            this.m_fetch_cache_number = 1;
            cache = 1;
            int i = 0;
            while (i < this.objects.length) {
                this.objects[i].region_fetch_cache = 0;
                ++i;
            }
        }
        int y = this.m_search_y1;
        while (y <= this.m_search_y2) {
            LevelObject[][] list = this.m_grid[y];
            int x = this.m_search_x1;
            while (x <= this.m_search_x2) {
                LevelObject[] objs = list[x];
                int i = 0;
                while (i < objs.length) {
                    LevelObject obj = objs[i];
                    if (obj.region_fetch_cache != cache) {
                        obj.region_fetch_cache = cache;
                        if (bbox.intersects(obj.bounding_box)) {
                            dest_list.addElement(obj);
                        }
                    }
                    ++i;
                }
                ++x;
            }
            ++y;
        }
    }

    private boolean getBoundingBoxRegion(BoundingBox box) {
        this.m_search_x1 = FP.toInt(FP.div(box.x1 - this.m_grid_x, this.m_grid_slot_size));
        this.m_search_y1 = FP.toInt(FP.div(box.y1 - this.m_grid_y, this.m_grid_slot_size));
        this.m_search_x2 = FP.toCeilInt(FP.div(box.x2 - this.m_grid_x, this.m_grid_slot_size));
        this.m_search_y2 = FP.toCeilInt(FP.div(box.y2 - this.m_grid_y, this.m_grid_slot_size));
        if (this.m_search_x1 >= this.m_grid_w || this.m_search_y1 >= this.m_grid_h || this.m_search_x2 < 0 || this.m_search_y2 < 0) {
            return false;
        }
        if (this.m_search_x1 < 0) {
            this.m_search_x1 = 0;
        }
        if (this.m_search_y1 < 0) {
            this.m_search_y1 = 0;
        }
        if (this.m_search_x2 >= this.m_grid_w) {
            this.m_search_x2 = this.m_grid_w - 1;
        }
        if (this.m_search_y2 >= this.m_grid_h) {
            this.m_search_y2 = this.m_grid_h - 1;
        }
        return this.m_search_x1 <= this.m_search_x2 && this.m_search_y1 <= this.m_search_y2;
    }

    public void update(int fp_secs) {
        int iters = 1;
        int time_iter = fp_secs / iters;
        if (!this.star.is_at_home) {
            this.play_time += fp_secs;
        }
        while (iters-- > 0) {
            int i = 0;
            while (i < this.objects.length) {
                this.objects[i].update(time_iter);
                ++i;
            }
        }
        this.particles.update(fp_secs, this.gravity_vec);
        if (!(this.star.is_at_home || this.star.is_dead || this.level_bbox.contains(this.star.getX(), this.star.getY()))) {
            this.star.kill();
        }
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y, int vis_w, int vis_h, int scr_w, int scr_h) {
        this.m_screen_box.x1 = top_x;
        this.m_screen_box.y1 = top_y;
        this.m_screen_box.x2 = top_x + vis_w;
        this.m_screen_box.y2 = top_y + vis_h;
        this.regionFetch(this.m_screen_box, this.m_screen_objs);
        this.m_screen_objs.addElement(this.star);
        Level.sort(this.m_screen_objs);
        int size = this.m_screen_objs.size();
        int i = 0;
        while (i < size) {
            LevelObject obj = (LevelObject)this.m_screen_objs.elementAt(i);
            obj.render(g, top_x, top_y, scale_x, scale_y);
            ++i;
        }
        this.particles.render(g, top_x, top_y, scale_x, scale_y);
        Font f = Font.getFont(64, 3, 0);
        g.setFont(f);
        String time_str = MiscUtils.timeToString(this.play_time);
        g.setColor(-15658735);
        g.fillRect(2, 2, 2 + f.stringWidth(time_str), 2 + f.getHeight());
        g.setColor(-1);
        g.drawString(time_str, 2, 2, 20);
        int time = this.current_top_score;
        if (time < 0) {
            time = this.time_bronze + FP.toFP(99);
        }
        if ((time_str = time <= this.time_gold ? "Best: " + MiscUtils.timeToString(time) : (time <= this.time_silver ? "Gold: " + MiscUtils.timeToString(this.time_gold) : (time <= this.time_bronze ? "Silver: " + MiscUtils.timeToString(this.time_silver) : "Bronze: " + MiscUtils.timeToString(this.time_bronze)))) != null) {
            int str_w = f.stringWidth(time_str);
            g.setColor(-15658735);
            g.fillRect(scr_w - str_w - 2, 2, 2 + str_w, 2 + f.getHeight());
            g.setColor(-1);
            g.drawString(time_str, scr_w - str_w - 2, 2, 20);
        }
        if (this.collectibles_left > 0) {
            String str = "Stars: " + this.collectibles_left;
            int y = f.getHeight();
            g.setColor(-15658735);
            g.fillRect(2, y + 2, 2 + f.stringWidth(str), 2 + f.getHeight());
            g.setColor(-1);
            g.drawString(str, 2, y + 2, 20);
        }
    }

    private static void sort(Vector objs) {
        boolean swapped;
        int size;
        int gap = size = objs.size();
        do {
            swapped = false;
            if ((gap = 10 * gap / 13) == 9 || gap == 10) {
                gap = 11;
            } else if (gap < 1) {
                gap = 1;
            }
            int i = 0;
            while (i < size - gap) {
                LevelObject o1 = (LevelObject)objs.elementAt(i);
                LevelObject o2 = (LevelObject)objs.elementAt(i + gap);
                if (o1.draw_index > o2.draw_index) {
                    swapped = true;
                    objs.setElementAt(o1, i + gap);
                    objs.setElementAt(o2, i);
                }
                ++i;
            }
        } while (swapped || gap > 1);
    }

    private void loadLevel(DataInputStream in) throws IOException {
        this.screen_width = in.readInt();
        this.screen_height = in.readInt();
        this.screen_aspect = in.readInt();
        this.gravity = in.readInt();
        this.setGravity(1);
        this.time_bronze = in.readInt();
        this.time_silver = in.readInt();
        this.time_gold = in.readInt();
        int x = in.readInt();
        int y = in.readInt();
        int w = in.readInt();
        int h = in.readInt();
        this.level_bbox = new BoundingBox(x, y, w, h);
        int level_obj_count = in.readShort();
        this.objects = new LevelObject[level_obj_count];
        int i = 0;
        while (i < level_obj_count) {
            int type = in.readByte() & 0xFF;
            LevelObject obj = null;
            switch (type) {
                case 0: {
                    obj = new Star();
                    break;
                }
                case 1: {
                    obj = new Goal();
                    break;
                }
                case 10: {
                    obj = new WallRectangle();
                    break;
                }
                case 11: {
                    obj = new WallSphere();
                    break;
                }
                case 20: {
                    obj = new MeshObject();
                    break;
                }
                case 30: {
                    obj = new ItemObject();
                }
            }
            if (obj == null) {
                throw new Error("Unknown level object: " + type);
            }
            obj.level = this;
            obj.draw_index = i;
            int x2 = in.readInt();
            int y2 = in.readInt();
            int w2 = in.readInt();
            int h2 = in.readInt();
            obj.bounding_box = new BoundingBox(x2, y2, w2, h2);
            if (obj instanceof Star) {
                if (this.star != null) {
                    throw new Error("More than one starting position found!");
                }
                this.star = obj;
            }
            if (obj instanceof Goal) {
                if (this.goal != null) {
                    throw new Error("More than one ending position found!");
                }
                this.goal = (Goal)obj;
            }
            obj.load(in);
            this.objects[i] = obj;
            if (obj instanceof ItemObject && ((ItemObject)obj).getType() == 1) {
                ++this.collectibles_left;
            }
            ++i;
        }
        this.m_grid_x = in.readInt();
        this.m_grid_y = in.readInt();
        this.m_grid_slot_size = in.readInt();
        this.m_grid_w = in.readShort();
        this.m_grid_h = in.readShort();
        this.m_grid = new LevelObject[this.m_grid_h][this.m_grid_w][];
        y = 0;
        while (y < this.m_grid_h) {
            int x3 = 0;
            while (x3 < this.m_grid_w) {
                LevelObject[] objs = new LevelObject[in.readShort()];
                int i2 = 0;
                while (i2 < objs.length) {
                    short idx = in.readShort();
                    objs[i2] = this.objects[idx];
                    ++i2;
                }
                this.m_grid[y][x3] = objs;
                ++x3;
            }
            ++y;
        }
        this.particles = new ParticleSystem(32);
        if (this.star == null) {
            throw new Error("No starting location found!");
        }
        if (this.goal == null) {
            throw new Error("No ending location found!");
        }
    }
}

