/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import utils.Cache;

public class Sound {
    private static final String WAV = "audio/x-wav";
    private static final String MIDI = "audio/midi";
    static /* synthetic */ Class class$0;

    public static void playWAV(String name) {
        Sound.playWAV(name, true);
    }

    public static void playWAV(String name, boolean cache) {
        Sound.play(name, ".wav", WAV, cache, 1);
    }

    public static void stopWAV() {
        Sound.stop(WAV);
    }

    public static void removeWAV() {
        Cache.remove(WAV);
    }

    public static void playMIDI(String name, boolean cache) {
        Sound.play(name, ".mid", MIDI, cache, -1);
    }

    public static void stopMIDI() {
        Sound.stop(MIDI);
    }

    private static void play(String name, String end, String contentType, boolean cache, int loop) {
        if (!Cache.contains(contentType, name)) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("utils.Sound");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream in = clazz.getResourceAsStream("/" + name + end);
                Player p = Manager.createPlayer((InputStream)in, (String)contentType);
                p.setLoopCount(loop);
                p.addPlayerListener((PlayerListener)new MyPlayerListener(cache, contentType, name));
                p.realize();
                p.prefetch();
                Cache.add(contentType, name, p);
            }
            catch (MediaException pe) {
                pe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        Player p = (Player)Cache.get(contentType, name);
        try {
            System.err.println("play");
            if (p.getState() == 400) {
                p.deallocate();
            }
            p.realize();
            p.prefetch();
            p.setMediaTime(0L);
            p.start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    private static void stop(String prefix) {
        if (!Cache.contains(prefix)) {
            return;
        }
        Enumeration e = Cache.get(prefix).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Player player = (Player)Cache.get(prefix).get(name);
            if (player.getState() != 400) continue;
            try {
                player.stop();
                player.close();
                Cache.remove(prefix, name);
            }
            catch (MediaException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void removeWAV(String name) {
        Cache.remove(WAV);
    }

    private static class MyPlayerListener
    implements PlayerListener {
        private boolean cache;
        private String contentType;
        private String name;

        public MyPlayerListener(boolean cache, String contentType, String name) {
            this.cache = cache;
            this.contentType = contentType;
            this.name = name;
        }

        public void playerUpdate(Player p, String type, Object obj) {
            if (type == "endOfMedia") {
                // empty if block
            }
        }
    }
}

