/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.CellRace;
import cellrace.CellRaceListener;
import cellrace.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Setup {
    private int playerNr = 2;
    private char[][] names = new char[CellRace.MAX_PLAYERS][3];
    private final SetupMain setupMain;
    private final SetupPlayer setupPlayer;
    private static final int STATE_MAIN = 0;
    private static final int STATE_PLAYER = 1;
    private static final int STATE_EXIT = 2;
    private int currentState = 0;
    private CellRaceListener listener;
    private static String DB_NAME = "settings";

    public Setup(CellRaceListener listener) {
        int i = 0;
        while (i < this.names.length) {
            this.names[i] = new char[]{'a', 'a', 'a'};
            ++i;
        }
        this.listener = listener;
        this.setupMain = new SetupMain();
        this.setupPlayer = new SetupPlayer();
        this.loadSetup();
    }

    public int getPlayerNr() {
        return this.playerNr;
    }

    public String[] getPlayerNames() {
        String[] ret = new String[this.getPlayerNr()];
        int i = 0;
        while (i < this.getPlayerNr()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.names[i][0]);
            sb.append(this.names[i][1]);
            sb.append(this.names[i][2]);
            ret[i] = sb.toString();
            ++i;
        }
        return ret;
    }

    public void enable() {
        this.currentState = 0;
    }

    public Canvas currentCanvas() {
        switch (this.currentState) {
            case 0: {
                return this.setupMain;
            }
            case 1: {
                return this.setupPlayer;
            }
            case 2: {
                return null;
            }
        }
        return this.setupMain;
    }

    private void loadSetup() {
        try {
            RecordStore db = RecordStore.openRecordStore((String)DB_NAME, (boolean)true);
            if (db.getNumRecords() > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(db.getRecord(1));
                DataInputStream dis = new DataInputStream(bais);
                this.playerNr = dis.readByte();
                int i = 0;
                while (i < CellRace.MAX_PLAYERS) {
                    bais = new ByteArrayInputStream(db.getRecord(2 + i));
                    dis = new DataInputStream(bais);
                    this.names[i][0] = dis.readChar();
                    this.names[i][1] = dis.readChar();
                    this.names[i][2] = dis.readChar();
                    ++i;
                }
                dis.close();
                bais.close();
            }
            db.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSetup() {
        try {
            RecordStore.deleteRecordStore((String)DB_NAME);
            RecordStore db = RecordStore.openRecordStore((String)DB_NAME, (boolean)true);
            db.addRecord(new byte[]{(byte)this.getPlayerNr()}, 0, 1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int i = 0;
            while (i < CellRace.MAX_PLAYERS) {
                dos.writeChar(this.names[i][0]);
                dos.writeChar(this.names[i][1]);
                dos.writeChar(this.names[i][2]);
                byte[] b = baos.toByteArray();
                db.addRecord(b, 0, b.length);
                baos.reset();
                ++i;
            }
            dos.close();
            baos.close();
            db.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class SetupMain
    extends Canvas {
        public SetupMain() {
            this.setFullScreenMode(true);
            System.err.println("width=" + this.getWidth() + " height=" + this.getHeight());
        }

        protected void paint(Graphics g) {
            g.drawImage(Utils.creteBackground(this.getWidth(), this.getHeight(), Utils.createImage("", "grass"), Utils.createImage("", "road")), 0, 0, 20);
            Image title = Utils.createThumbnail("title", "title", this.getWidth(), -1);
            int height = title.getHeight() + 10;
            g.drawImage(title, 0, 0, 20);
            Image numberof = Utils.writeLine("menu", "number of", 0);
            g.drawImage(numberof, 0, height, 20);
            Image players = Utils.writeLine("menu", "players", 0);
            g.drawImage(players, 0, height += numberof.getHeight(), 20);
            Image nr = Utils.writeLine("menu", "" + Setup.this.getPlayerNr(), 0);
            g.setColor(-1);
            g.drawRect(2, height += players.getHeight(), this.getWidth() - 4, nr.getHeight() + 4);
            g.drawRect(3, height + 1, this.getWidth() - 6, nr.getHeight() + 2);
            g.drawImage(nr, this.getWidth() / 2 - nr.getWidth() / 2, height + 2, 20);
        }

        protected void keyPressed(int keyCode) {
            if (keyCode == this.getKeyCode(6)) {
                if (Setup.this.playerNr > 1) {
                    Setup setup = Setup.this;
                    setup.playerNr = setup.playerNr - 1;
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(1)) {
                if (Setup.this.playerNr < CellRace.MAX_PLAYERS) {
                    Setup setup = Setup.this;
                    setup.playerNr = setup.playerNr + 1;
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(2)) {
                Setup.this.currentState = 2;
                Setup.this.saveSetup();
                Setup.this.listener.refreshCanvas();
                this.repaint();
            } else if (keyCode == 49) {
                Setup.this.playerNr = 1;
                this.repaint();
            } else if (keyCode == 50) {
                Setup.this.playerNr = 2;
                this.repaint();
            } else if (keyCode == 51) {
                Setup.this.playerNr = 3;
                this.repaint();
            } else if (keyCode == 52) {
                Setup.this.playerNr = 4;
                this.repaint();
            } else if (keyCode == 53) {
                Setup.this.playerNr = 5;
                this.repaint();
            } else if (keyCode == 54) {
                Setup.this.playerNr = 6;
                this.repaint();
            } else if (keyCode == this.getKeyCode(8) || keyCode == this.getKeyCode(5)) {
                Setup.this.currentState = 1;
                Setup.this.listener.refreshCanvas();
                this.repaint();
            }
            System.err.println("Code " + keyCode);
        }
    }

    public class SetupPlayer
    extends Canvas {
        private int player = 0;
        private int charPos = 0;

        public SetupPlayer() {
            this.setFullScreenMode(true);
        }

        protected void paint(Graphics g) {
            g.drawImage(Utils.creteBackground(this.getWidth(), this.getHeight(), Utils.createImage("", "grass"), Utils.createImage("", "road")), 0, 0, 20);
            Image title = Utils.createThumbnail("", "title", this.getWidth(), -1);
            int height = title.getHeight() + 10;
            g.drawImage(title, 0, 0, 20);
            Image numberof = Utils.writeLine("menu", "name of", 0);
            g.drawImage(numberof, 0, height, 20);
            Image players = Utils.writeLine("menu", "player " + (this.player + 1), 0);
            g.drawImage(players, 0, height += numberof.getHeight(), 20);
            Image c1 = Utils.writeLine("menu", "" + Setup.this.names[this.player][0], this.charPos == 0 ? 0x60000000 : 0);
            Image c2 = Utils.writeLine("menu", "" + Setup.this.names[this.player][1], this.charPos == 1 ? 0x60000000 : 0);
            Image c3 = Utils.writeLine("menu", "" + Setup.this.names[this.player][2], this.charPos == 2 ? 0x60000000 : 0);
            g.drawImage(c1, 10, (height += players.getHeight()) + 2, 20);
            g.drawImage(c2, 10 + c1.getWidth(), height + 2, 20);
            g.drawImage(c3, 10 + c1.getWidth() + c2.getWidth(), height + 2, 20);
            g.setColor(-1);
            g.drawRect(2, height, this.getWidth() - 4, c1.getHeight() + 4);
            g.drawRect(3, height + 1, this.getWidth() - 6, c1.getHeight() + 2);
        }

        protected void keyPressed(int keyCode) {
            if (keyCode == this.getKeyCode(6)) {
                if (Setup.this.names[this.player][this.charPos] > 'a') {
                    char[] cArray = Setup.this.names[this.player];
                    int n = this.charPos;
                    cArray[n] = (char)(cArray[n] - '\u0001');
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(1)) {
                if (Setup.this.names[this.player][this.charPos] < 'z') {
                    char[] cArray = Setup.this.names[this.player];
                    int n = this.charPos;
                    cArray[n] = (char)(cArray[n] + '\u0001');
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(5)) {
                if (this.charPos < 2) {
                    ++this.charPos;
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(2)) {
                if (this.charPos > 0) {
                    --this.charPos;
                }
                this.repaint();
            } else if (keyCode == this.getKeyCode(8)) {
                if (this.player <= Setup.this.playerNr) {
                    ++this.player;
                    this.charPos = 0;
                    this.repaint();
                }
                if (this.player == Setup.this.playerNr) {
                    this.player = 0;
                    Setup.this.currentState = 0;
                    Setup.this.listener.refreshCanvas();
                }
            }
        }
    }
}

