float4x4 comboMatrix : WorldViewProjection;

texture texture_0;

sampler texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput
{
	float3 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput
{
	float4 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color 	: COLOR;
};


VertexOutput VS_VertexTransform( VertexInput IN )
{
	VertexOutput OUT;
	
	OUT.position = mul( float4(IN.position, 1.0f), comboMatrix );
	OUT.uvCoord = IN.uvCoord;
	OUT.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );
	
	return OUT;
};


technique Textured
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		
		Texture[0] = <texture_0>;
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;
		
		ZEnable = false;
		
		ColorVertex = true;	
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
	}
}