float texFix = (1.0f/512.0f)*0.5f;
float amount;

texture texture_0;

struct VertexInput {
    float3 Position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
};

struct VertexOutput {
    float4 HPosition	: POSITION;
    float2 uvCoord		: TEXCOORD0;
    float4 color		: COLOR;
};

VertexOutput VS_QuadProjection(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord + texFix;
    OUT.color = amount;
    return OUT;
}

technique Textured
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadProjection();
		PixelShader = NULL;
		
		ZEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = one;
		
		texture[0] = <texture_0>;
		addressu[0] = CLAMP;
		addressv[0] = CLAMP;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
    }
}

technique DoMotionBlur< bool quad = true; string material="motionBlur"; >
{
	
}

technique DoMotionBlur2< bool quad = true; string material="motionBlur2"; >
{
	
}