float4x4 comboMatrix : WorldViewProjection;

float4	materialColor = { 1.0f, 1.0f, 1.0f, 1.0f };

struct VertexOutput
{
	float4 position 	: POSITION;
	float4 color		: COLOR;
};

VertexOutput VS_VertexTransform( float3 position : POSITION )
{
	VertexOutput OUT;
	OUT.position = mul( float4(position, 1.0f), comboMatrix );
	OUT.color = materialColor;
	return OUT;
}

technique PosMaterial< bool quad=true; string material="gaussian"; >
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader  = NULL;
	}
}