/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;

class KimonoCanvas
extends FullCanvas {
    public static final int imageHeight = 128;
    public static final int imageWidth = 128;
    public static final int imagePixels = 16384;
    public static final int imageDataType = 444;
    public static final int colorClampMax = 16;
    public short[] imageBuffer = null;
    public static Graphics currentGraphics = null;
    private DirectGraphics dgHandle = null;
    private int interlace = -1;
    private KimonoFPS fpsCounter;

    public void setInterlace(int n) {
        this.interlace = n;
    }

    public static short colorConvert(int n, int n2, int n3) {
        short s = (short)(n << 8);
        s = (short)(s | (short)(n2 << 4));
        s = (short)(s | (short)n3);
        return s;
    }

    public short colorConvertClamp(int n, int n2, int n3) {
        return KimonoCanvas.colorConvert(n > 16 ? 16 : n, n2 > 16 ? 16 : n2, n3 > 16 ? 16 : n3);
    }

    public KimonoCanvas() {
        this.init(true);
    }

    public void init(boolean bl) {
        if (bl) {
            this.imageBuffer = new short[16384];
            for (int i = 0; i < 16384; ++i) {
                this.imageBuffer[i] = KimonoCanvas.colorConvert(0, 0, 0);
            }
        }
    }

    public void flipPage(DirectGraphics directGraphics) {
        if (this.interlace < 0) {
            directGraphics.drawPixels(this.imageBuffer, false, 0, 128, 0, 0, 128, 128, 0, 444);
        } else {
            for (int i = 0; i < 128; i += 2) {
                directGraphics.drawPixels(this.imageBuffer, false, (i + this.interlace) * 128, 128, 0, i + this.interlace, 128, 1, 0, 444);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.dgHandle == null) {
            this.dgHandle = DirectUtils.getDirectGraphics((Graphics)graphics);
        }
        currentGraphics = graphics;
        this.flipPage(this.dgHandle);
    }
}

