// Viewport.h: interface for the CViewport class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIEWPORT_H__D67B4A46_4DFD_42FE_9005_F5DCF8DE1561__INCLUDED_)
#define AFX_VIEWPORT_H__D67B4A46_4DFD_42FE_9005_F5DCF8DE1561__INCLUDED_

#include "Font.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gl/gl.h>
#include "vector.h"
#include "Color.h"

#define MAX_VIEWPORT_NAME_LEN	256
#define MAX_SCENE_RECORDS		1024

class CViewport
{
public:
	void printf(CVector &pos, CColor &color, char *str, ...);
	int nrenders;
	CVector & pixelToCartesianDistance(CVector &v);
	CVector & pixelToCartesianCoords(CVector &v);
	inline HDC getDC() { return hdc; }
	inline bool isFpsShowing() { return show_fps; }
	void showFps(bool s);
	bool getFullScreen();
	int firstheight;
	int firstwidth;
	int getHeight();
	int getWidth();
	bool setFullScreen(bool fs);
	void hide();
	bool show();
	bool set(HWND wnd, int cb, int zb, int sb);
	void clear(int flags = GL_COLOR_BUFFER_BIT);
	void setResizable(bool s);
	void swapBuffers();
	inline HWND getHwnd() { return hwnd; }
	bool isClosed();
	CViewport(char *);
	void resize(int w, int h);
	bool set(int w, int h, bool fs, bool show = true);
	bool set(int w, int h, int cb, bool fs, bool show = true);
	bool set(int w, int h, int cb, int zb, int sb, bool fs, bool show = true);
	CViewport();
	virtual ~CViewport();

private:
	float print_counter;
	int current_fps;
	int frames;
	float fps_acum;
	bool show_fps;
	float fps[20];
	int oldmousey;
	int oldmousex;
	RECT backrect;
	int backstyleex;
	int backstyle;
	bool visible;
	bool resizeable;
	bool vp_closed;
	char name[MAX_VIEWPORT_NAME_LEN];
	char temp_str[MAX_VIEWPORT_NAME_LEN + 128], temp_printf_str[512];
	HDC hdc;
	HGLRC hrc;
	int sbits;
	int zbits;
	int cbits;
	int height;
	int width;
	bool fullscreen;

	HWND hwnd;
	PIXELFORMATDESCRIPTOR pfd;
	bool CreateDefaultWindow(int w, int h, int b, bool fs);
	void DestroyDefaultWindow();
	void SetPixelFormat(int cb, int zb, int sb);
	static LRESULT CALLBACK WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
protected:
	CTextFont font;
};

#endif // !defined(AFX_VIEWPORT_H__D67B4A46_4DFD_42FE_9005_F5DCF8DE1561__INCLUDED_)
