// Vector.h: interface for the CVector class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VECTOR_H__50D4D93F_7B1C_4142_8711_D71400A604CE__INCLUDED_)
#define AFX_VECTOR_H__50D4D93F_7B1C_4142_8711_D71400A604CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMatrix;
class CVector4;

class CVector
{
public:
	CVector operator - ();
	CVector & rotate(CVector &p, CVector &vd, float a);
	float module();
	CVector & normalize();
	CVector(float x, float y, float z = 0);
	float x, y, z;
	CVector();
	virtual ~CVector();
	void operator = (CVector &v);
	CVector &operator = (CVector4 &v);
	CVector operator + (CVector &v);
	CVector operator - (CVector &v);
	CVector operator * (float f);
	float operator * (CVector &v);
	CVector operator * (CMatrix &m);
	CVector operator % (CVector &v);
	void operator += (CVector &v);
	void operator -= (CVector &v);
	bool operator !=(CVector &v);
	bool operator ==(CVector &v);
};

#endif // !defined(AFX_VECTOR_H__50D4D93F_7B1C_4142_8711_D71400A604CE__INCLUDED_)
