// Timer.cpp: implementation of the CTimer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Timer.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTimer::CTimer()
{
	support = QueryPerformanceFrequency(&frequency) != 0;
}

CTimer::~CTimer()
{

}

double CTimer::getElapsedTime()
{
	LARGE_INTEGER current_ticks;
	QueryPerformanceCounter(&current_ticks);
	LARGE_INTEGER t_ticks;
	t_ticks.QuadPart = current_ticks.QuadPart - ticks.QuadPart;
	ticks.QuadPart = current_ticks.QuadPart;
	return t_ticks.QuadPart / (double)frequency.QuadPart;
}

void CTimer::reset()
{
	QueryPerformanceCounter(&ticks);
}
