// Matrix4.cpp: implementation of the CMatrix4 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Matrix4.h"
#include <string.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMatrix4 temp_matrix;

CMatrix4::CMatrix4()
{
	memset(value, 0, sizeof(value));
	value[0][0] = 1;
	value[1][1] = 1;
	value[2][2] = 1;
	value[3][3] = 1;
}

CMatrix4::~CMatrix4()
{

}

void CMatrix4::operator =(CMatrix4 &m)
{
	// long but fast...
	value[0][0] = m.value[0][0];
	value[0][1] = m.value[0][1];
	value[0][2] = m.value[0][2];
	value[0][3] = m.value[0][3];
	value[1][0] = m.value[1][0];
	value[1][1] = m.value[1][1];
	value[1][2] = m.value[1][2];
	value[1][3] = m.value[1][3];
	value[2][0] = m.value[2][0];
	value[2][1] = m.value[2][1];
	value[2][2] = m.value[2][2];
	value[2][3] = m.value[2][3];
	value[3][0] = m.value[3][0];
	value[3][1] = m.value[3][1];
	value[3][2] = m.value[3][2];
	value[3][3] = m.value[3][3];
}

CMatrix4 CMatrix4::operator *(CMatrix4 &m)
{
	CMatrix4 matrix;
	matrix.value[0][0] = value[0][0] * m.value[0][0] + value[0][1] * m.value[1][0] + value[0][2] * m.value[2][0] + value[0][3] * m.value[3][0];
	matrix.value[0][1] = value[0][0] * m.value[0][1] + value[0][1] * m.value[1][1] + value[0][2] * m.value[2][1] + value[0][3] * m.value[3][1];
	matrix.value[0][2] = value[0][0] * m.value[0][2] + value[0][1] * m.value[1][2] + value[0][2] * m.value[2][2] + value[0][3] * m.value[3][2];
	matrix.value[0][3] = value[0][0] * m.value[0][3] + value[0][1] * m.value[1][3] + value[0][2] * m.value[2][3] + value[0][3] * m.value[3][3];
	matrix.value[1][0] = value[1][0] * m.value[0][0] + value[1][1] * m.value[1][0] + value[1][2] * m.value[2][0] + value[1][3] * m.value[3][0];
	matrix.value[1][1] = value[1][0] * m.value[0][1] + value[1][1] * m.value[1][1] + value[1][2] * m.value[2][1] + value[1][3] * m.value[3][1];
	matrix.value[1][2] = value[1][0] * m.value[0][2] + value[1][1] * m.value[1][2] + value[1][2] * m.value[2][2] + value[1][3] * m.value[3][2];
	matrix.value[1][3] = value[1][0] * m.value[0][3] + value[1][1] * m.value[1][3] + value[1][2] * m.value[2][3] + value[1][3] * m.value[3][3];
	matrix.value[2][0] = value[2][0] * m.value[0][0] + value[2][1] * m.value[1][0] + value[2][2] * m.value[2][0] + value[2][3] * m.value[3][0];
	matrix.value[2][1] = value[2][0] * m.value[0][1] + value[2][1] * m.value[1][1] + value[2][2] * m.value[2][1] + value[2][3] * m.value[3][1];
	matrix.value[2][2] = value[2][0] * m.value[0][2] + value[2][1] * m.value[1][2] + value[2][2] * m.value[2][2] + value[2][3] * m.value[3][2];
	matrix.value[2][3] = value[2][0] * m.value[0][3] + value[2][1] * m.value[1][3] + value[2][2] * m.value[2][3] + value[2][3] * m.value[3][3];
	matrix.value[3][0] = value[3][0] * m.value[0][0] + value[3][1] * m.value[1][0] + value[3][2] * m.value[2][0] + value[3][3] * m.value[3][0];
	matrix.value[3][1] = value[3][0] * m.value[0][1] + value[3][1] * m.value[1][1] + value[3][2] * m.value[2][1] + value[3][3] * m.value[3][1];
	matrix.value[3][2] = value[3][0] * m.value[0][2] + value[3][1] * m.value[1][2] + value[3][2] * m.value[2][2] + value[3][3] * m.value[3][2];
	matrix.value[3][3] = value[3][0] * m.value[0][3] + value[3][1] * m.value[1][3] + value[3][2] * m.value[2][3] + value[3][3] * m.value[3][3];
	return matrix;	
}

CVector4 &CMatrix4::operator *(CVector4 &v)
{
	res_vector.x = value[0][0] * v.x + value[0][1] * v.y + value[0][2] * v.z + value[0][3] * v.w;
	res_vector.y = value[1][0] * v.x + value[1][1] * v.y + value[1][2] * v.z + value[1][3] * v.w;
	res_vector.z = value[2][0] * v.x + value[2][1] * v.y + value[2][2] * v.z + value[2][3] * v.w;
	res_vector.w = value[3][0] * v.x + value[3][1] * v.y + value[3][2] * v.z + value[3][3] * v.w;
	return res_vector;
}

CVector4 & CMatrix4::operator *(CVector &v)
{
	res_vector.x = value[0][0] * v.x + value[0][1] * v.y + value[0][2] * v.z + value[0][3];
	res_vector.y = value[1][0] * v.x + value[1][1] * v.y + value[1][2] * v.z + value[1][3];
	res_vector.z = value[2][0] * v.x + value[2][1] * v.y + value[2][2] * v.z + value[2][3];
	res_vector.w = value[3][0] * v.x + value[3][1] * v.y + value[3][2] * v.z + value[3][3];
	return res_vector;
}

CMatrix4 & CMatrix4::transpose()
{
	CMatrix4 m;
	for (int y = 0; y < 4; y ++)
		for (int x = 0; x < 4; x ++)
			m.value[y][x] = value[x][y];
	*this = m;
	return *this;
}

CMatrix4::CMatrix4(CVector4 &v1, CVector4 &v2, CVector4 &v3, CVector4 &v4)
{
	value[0][0] = v1.x;
	value[0][1] = v1.y;
	value[0][2] = v1.z;
	value[0][3] = v1.w;
	value[1][0] = v2.x;
	value[1][1] = v2.y;
	value[1][2] = v2.z;
	value[1][3] = v2.w;
	value[2][0] = v3.x;
	value[2][1] = v3.y;
	value[2][2] = v3.z;
	value[2][3] = v3.w;
	value[3][0] = v4.x;
	value[3][1] = v4.y;
	value[3][2] = v4.z;
	value[3][3] = v4.w;
}

float CMatrix4::trace()
{
	return value[0][0] + value[1][1] + value[2][2] + value[3][3];
}
