.386
.MODEL TINY
ASSUME CS:INTRO,DS:INTRO

INTRO SEGMENT PARA USE16
   org  0100h

STARTUPCODE
   finit
   mov ax,3508h
   int 21h
   push ds
   push bx
   push es  ; Actual timer saving...
   mov ah,25h
   mov dx,offset(Timer)
   int 21h
   mov al,036h
   out 043h,al
   out 040h,al
   mov al,0e9h
   out 040h,al   ; New timer setting -> 29702 ~= 59659 ~= 1193180/20

   mov ax,ds
   add ax,4096
   mov es,ax    ; Virtual screen 1
   add ax,4096
   mov fs,ax    ; Virtual screen 2

   mov ax,0a000h
   mov gs,ax    ; Video screen memory address

   mov ax,13h
   int 10h      ; Video mode setting

   mov bx, VSSIZE
clear:
   dec bx
   mov es:[bx], byte ptr bg_col
   mov fs:[bx], byte ptr bg_col
   jnz clear     ; Clearance of virtual screen  

   ; bx already set to 0 due to previous loop (fact not used now)
   mov bx,N_EFF  ; Init stage counter
mainloop:
   mov al,Sync
framewait:
   cmp al,Sync
   je  framewait ; Timer delay

   dec counter        ; Decrement number of cycles to show the current effect
   jns noeffectchange ; if -1 then change effect
   sub bx,6      ; Decrement the stage counter
   js  finish    ; If this was last effect then end
   mov dx,[effects_table+bx]   ; Load next effect address
   push word ptr [effects_table+bx+4] ; Load next effect cycles
   pop  counter
   pusha
   call [effects_table+bx+2] ; Call next effect initialization
   popa
noeffectchange:
   pusha
   call dx  ; Call the effect
   mov bx, VSSIZE
dump:
   dec bx
   mov al, es:[bx]
   mov es:[bx], byte ptr bg_col
   mov gs:[bx], al
   jnz dump     ; Dump of virtual screen into real one
   popa

   in  al,60h
   dec al
   jnz mainloop  ; Detect pressed key and, if not ESC, continue execution
finish:
   mov ax,2508h
   pop ds
   pop dx
   int 21h         ; Restore original timer
   pop ds
   mov ax,3h       ; Set standart textmode
   int 10h
   int 20h         ; End

Random proc near
   mov ax,1351
   mul seed
   add ax,4971
   mov seed,ax
   ret
Random endp

Timer proc near
   push ax
   inc Sync
   mov al,20h
   out 20h,al
   pop ax
   iret
Timer endp

Null proc near
   ret
Null endp

; Funcin para establecer un color
;
; al: N. Color  ah: R  cl: G  ch: B

SetCol proc Near
   pusha
   mov dx,3c8h
   out dx,al
   inc dx
   mov al,ah
   out dx,al
   mov al,cl
   out dx,al
   mov al,ch
   out dx,al
   popa
   ret
SetCol endp

SetCol2 proc Near
   call SetCol
   pusha
   add al,128
   add ah,189
   add cl,189
   add ch,189
   sar ah,2
   sar cl,2
   sar ch,2
   call SetCol
   popa
   ret
SetCol2 endp

Quad proc near
   mov bx,100
quad_next_line:
   dec bx
   mov cx,160
quad_next_row:
   dec cx
   mov ax,320
   mul bx
   mov di,ax
   add di,cx
   mov bp,di
   mov al,fs:[bp+di]
   add al,128
   mov es:[di],al
   mov es:[di+160],al
   mov es:[di+32000],al
   mov es:[di+32160],al
   or  cx,cx
   jnz quad_next_row
   or  bx,bx
   jnz quad_next_line

   mov bx,VSSIZE
quad_2nd:
   mov al,fs:[bx-1]
   cmp al,bg_col
   je  quad_no_point
   mov es:[bx-1],al
quad_no_point:
   mov fs:[bx-1], byte ptr bg_col
   dec bx
   jnz quad_2nd
   ret
Quad endp

Bluepal proc near
   mov ax,0407fh
   mov cx,03f40h
nexthighblue:
   dec ah
   dec cx
   call SetCol2
   dec ax
   cmp al,03fh
   jne nexthighblue
nextlowblue:
   call SetCol2
   dec ch
   dec ax
   jnz nextlowblue
   ret
Bluepal endp

Triangle proc near ; si should point to the beginning of the triangle struc
   pusha
   mov ax,[tri_buff+2] ; Let's set initially y1 as ymin and y2 as ymax
   mov cx,[tri_buff+7]
   cmp ax,cx
   jle y1miny2
   xchg ax,cx    ; If wrong, let's exchange them
y1miny2:
   mov bx,[tri_buff+12]
   cmp ax,bx  ; Then compare y3
   jle y3nomin
   mov ax,bx
y3nomin:
   cmp cx,bx
   jge y3nomax
   mov cx,bx
y3nomax:

   mov bx,199
   or  cx,cx
   js  triangleend
   cmp cx,bx
   jl  ymxfixed
   mov cx,bx
ymxfixed:
   cmp ax,bx
   jg  triangleend
   or  ax,ax
   jns ymnfixed
   xor ax,ax
ymnfixed:

   mov dx,320 ; x min
   neg bx     ; x max

   mov si,offset(tri_buff)
   mov di,offset(tri_buff)+10
   jmp trifillentrypoint

fillingloop:
   pusha

   mov cx,3
nextpair:
   push cx
   push ax
   mov cx,[si+2]
   cmp ax,cx
   jle blockif1end
   cmp ax,[di+2]
   jg  blockend
blockif1end:
   cmp ax,cx
   jge blockif2end
   cmp ax,[di+2]
   jl  blockend
blockif2end:
   sub cx,[di+2]
   jz  blockend   ; Is current y between y1 and y3? Is y1-y3 != 0?
   push dx
   sub ax,[di+2]   ; Calculation of midpoint and its color 
   push ax
   mov dx,[si]
   sub dx,[di]
   imul dx
   idiv cx
   add ax,[di]
   pop  dx
   push ax
   push dx

   xor  ax,ax
   mov  dx,ax
   mov  al,[si+4]
   mov  dl,[di+4]
   sub  ax,dx
   pop  dx
   imul dx
   idiv cx
   add  al,[di+4]

   mov cx,bp
   pop bp
   pop dx

   cmp bp,dx   ; Update of data if needed 
   jge blockxmx
   mov dx,bp
   mov cl,al
blockxmx:
   cmp bp,bx
   jle blockendup
   mov bx,bp
   mov ch,al
blockendup:
   mov bp,cx
blockend:
   mov si,di
   sub di,5
   pop ax
   pop cx
   loop nextpair

   push dx
   mov dx,320
   mul dx
   mov di,ax
   pop dx

   mov cx,bx
   sub cx,dx

   or  bx,bx
   js  horizend
   cmp bx,319
   jle xmxlt320
   mov bx,319
xmxlt320:
   cmp dx,320
   jge horizend
   or  dx,dx
   js  xmnlt0
   add di,dx
   sub bx,dx
xmnlt0:

   mov ax,bp
   xor dx,dx
   mov dl,ah
   mov ah,dh
   sub dx,ax

nextpoint:
   jcxz putcmn
   mov ax,bx
   push dx
   imul dx
   idiv cx
   pop dx
   add ax,bp
putcmn:
   cmp fs:[di+bx],byte ptr bg_col
   je  putcmn_2
   cmp al,fs:[di+bx]
   jle commoninc
putcmn_2:
   mov fs:[di+bx],al
commoninc:
   dec bx
   jns nextpoint
horizend:
   popa
   inc ax
trifillentrypoint:
   cmp cx,ax
   jge fillingloop
triangleend:
   popa
   ret   
Triangle endp

Calc_point proc near
   fild y
   fmul sin_x
   fild z
   fmul cos_x
   fadd
   fild y
   fmul cos_x
   fild z
   fmul sin_x
   fsub
   fistp y
   fist  z

   fmul sin_y
   fild x
   fmul cos_y
   fadd
   fild z
   fmul cos_y
   fild x
   fmul sin_y
   fsub
   fistp z
   fist  x

   fmul cos_z
   fild y
   fmul sin_z
   fsub
   fild x
   fmul sin_z
   fild y
   fmul cos_z
   fadd
   fistp y
   fistp x

   mov ax,[si+10]
   add z,ax
   jns continue_calc_point
   mov z,0
continue_calc_point:
   inc z

   mov ax,64
   imul y
   idiv z
   add ax,[si+8]
   mov y,ax

   mov ax,64
   imul x
   idiv z
   add ax,[si+6]
   mov x,ax

end_calc_point:
   ret
Calc_point endp

Letters proc near
  mov  bx,offset(atomic_chain)
atomic_next_letter:
  mov  si,[bx]
  or   si,si
  jz   atomic_end

  mov  di,[bx+2]
  mov  bp,10
atomic_change:
  cmp  counter,0
  jz   atomic_no_change
  mov  ax,[si+bp]
  imul counter
  sub  ax,[si+bp]
  add  ax,[di+bp]
  idiv counter
  mov  [si+bp],ax
atomic_no_change:
  sub  bp,2
  jns  atomic_change

  mov  di,si
  add  bx,4
  add  di,14

  mov  bp,8
calc_angles_next:
  sar  bp,1
  fild word ptr [si+bp]
  add  bp,bp
  fmul cons
  fsincos
  fstp [cos_x+bp]
  fstp [sin_x+bp]
  sub  bp,4
  jns  calc_angles_next

  mov  cx,[si+12]
atomic_next_triangle:

  xor  bp,bp
atomic_next_point:
  mov  ax,[di]
  mov  x,ax
  mov  ax,[di+2]
  mov  y,ax
  mov  z,0
  call Calc_point

  mov  ax,x
  mov  [tri_buff+bp],ax
  mov  ax,y
  mov  [tri_buff+2+bp],ax

  mov  ax,256
  sub  ax,z
  sar  ax,1
  jns  nocolfix
  xor  ax,ax
nocolfix:
  mov  [tri_buff+4+bp],ax

  add  bp,5
  add  di,4
  cmp  bp,15
  jne  atomic_next_point

  call Triangle

  loop atomic_next_triangle
  jmp atomic_next_letter
atomic_end:
  call Quad
  ret
Letters endp

Letters_next proc near
  mov bx,offset(A_pos)
  mov cx,6
  cmp [bx],word ptr 0
  je  letters_next_loop2
letters_next_loop:
  mov [bx],word ptr 0
  mov [bx+2],word ptr 0
  mov [bx+4],word ptr 0
  add bx,12
  loop letters_next_loop
  ret
letters_next_loop2:
  mov [bx+10],word ptr 0
  add bx,12
  loop letters_next_loop2
  ret
Letters_next endp

                  ; Effects should be ordered reversely
                  ; Effect         + Init                + Cycles (1s = 20 c)
   effects_table dw offset(Letters), offset(Bluepal),      200

   N_EFF   EQU 6*1   ; -> 6*Number of effects
   VSSIZE  EQU 64000 ; -> Vscreen size
   bg_col  EQU 127
   seed    dw  54031
   counter dw  0

; Circle vars
  x_center dw 160
  y_center dw 100
  radius   dw 10
  circ_col db 5

; Atom points
atom_points:
    dw 0    ; Giro x
    dw 0    ; Giro y
    dw 0    ; Giro z
    dw 160  ; Addition to x
    dw 100  ; Addition to y
    dw  75  ; Addition to z
    dw -21, 25, 37
    db 128
    dw -21, 25,-37
    db 128
    dw  43, 25, 0
    db 129
    dw   0,-50, 0
    db 129
    dw   0,  0, 0
    db  75

; 3D Letters
atomic_chain  dw offset(A), offset(A_pos)
              dw offset(T), offset(T_pos)
              dw offset(O), offset(O_pos)
              dw offset(M), offset(M_pos)
              dw offset(I), offset(I_pos)
              dw offset(C), offset(C_pos), 0

A_pos dw 0,0,0,0,100,50
T_pos dw 0,0,0,0,100,50
O_pos dw 0,0,0,0,100,50
M_pos dw 0,0,0,0,100,50
I_pos dw 0,0,0,0,100,50
C_pos dw 0,0,0,0,100,50

A:
    dw 220   ; Giro x
    dw 0  ; Giro y
    dw 0   ; Giro z
    dw 480  ; Addition to x
    dw 100  ; Addition to y
    dw 50    ; Addition to z
    dw 8
    dw -110,-25, -110, 25, -100, 25
    dw -110,-25, -100,-25, -100, 25
    dw -110,-25,  -80,-25, -110,-15
    dw -110,-15,  -80,-25,  -80,-15
    dw -110, -5,  -80, -5, -110,  5
    dw -110,  5,  -80, -5,  -80,  5
    dw  -90,-25,  -80,-25,  -90, 25
    dw  -90, 25,  -80,-25,  -80, 25
    
T:
    dw 240    ; Giro x
    dw 0    ; Giro y
    dw 0    ; Giro z
    dw 480   ; Addition to x
    dw 100     ; Addition to y
    dw 50    ; Addition to z
    dw 4
    dw  -70,-25,  -70,-15,  -40,-25
    dw  -70,-15,  -40,-15,  -40,-25
    dw  -60,-25,  -50,-25,  -60, 25
    dw  -60, 25,  -50,-25,  -50, 25
        
O:
    dw 260  ; Giro x
    dw 0  ; Giro y
    dw 0  ; Giro z
    dw 480  ; Addition to x
    dw 100  ; Addition to y
    dw 50  ; Addition to z
    dw 8
    dw  -30,-25,  -20,-25,  -30, 25
    dw  -20,-25,  -20, 25,  -30, 25
    dw  -30,-25,  -30,-15,    0,-25
    dw  -30,-15,    0,-15,    0,-25
    dw  -30, 25,  -30, 15,    0, 25
    dw  -30, 15,    0, 15,    0, 25
    dw  -10,-25,    0,-25,  -10, 25
    dw    0,-25,    0, 25,  -10, 25
        
M:
    dw 280   ; Giro x
    dw 0  ; Giro y
    dw 0  ; Giro z
    dw 480  ; Addition to x
    dw 100  ; Addition to y
    dw 50 ; Addition to z
    dw 7
    dw   10,-25,   20,-25,   10, 25
    dw   20,-25,   20, 25,   10, 25
    dw   20,-25,   10,-15,   33,-12
    dw   40,-25,   50,-15,   27,-12
    dw   20,-15,   40,-15,   30, -5
    dw   40,-25,   50,-25,   40, 25
    dw   50,-25,   50, 25,   40, 25
         
I:
    dw 300   ; Giro x
    dw 0   ; Giro y
    dw 0  ; Giro z
    dw 480  ; Addition to x
    dw 100  ; Addition to y
    dw 50   ; Addition to z
    dw 2
    dw   60,-25,   70,-25,   60, 25
    dw   70,-25,   70, 25,   60, 25
         
C:
    dw 320  ; Giro x
    dw 0   ; Giro y
    dw 0  ; Giro z
    dw 480  ; Addition to x
    dw 100  ; Addition to y
    dw 50   ; Addition to z
    dw 6
    dw   80,-25,   90,-25,   80, 25
    dw   90,-25,   90, 25,   80, 25
    dw   80,-25,   80,-15,  110,-25
    dw   80,-15,  110,-15,  110,-25
    dw   80, 25,   80, 15,  110, 25
    dw   80, 15,  110, 15,  110, 25

   cons    dd 0.01745

   sin_x   dd ?
   sin_y   dd ?
   sin_z   dd ?
   cos_x   dd ?
   cos_y   dd ?
   cos_z   dd ?

   x       dw ?
   y       dw ?
   z       dw ?

   Sync    db ?
tri_buff   dw ?,?
           db ?
           dw ?,?
           db ?
           dw ?,?
           db ?
    temp   dw ?
    temp2  dw ?
    radius2  dw ?

INTRO ENDS
      END
