/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.GLContext;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class GLCanvas
extends Canvas
implements GLEnum,
GLUEnum,
ComponentListener,
WindowListener,
MouseListener {
    protected GLContext glj = null;
    public GLFunc gl = null;
    public GLUFunc glu = null;
    protected Dimension size = null;
    protected boolean mustResize = false;
    protected boolean cvsInitialized = false;
    protected boolean needCvsDispose = false;
    protected boolean doubleBuffer = true;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected boolean createOwnWindow = false;
    protected GLContext sharedGLContext;
    protected Window topLevelWindow = null;
    protected long _f_dur = 0L;

    static {
        if (!GLContext.loadNativeLibraries(null, null, null)) {
            System.out.println("GLCanvas could not load def. native libs.");
        }
    }

    public GLCanvas(int n, int n2) {
        this(n, n2, null, null);
    }

    public GLCanvas(int n, int n2, String string, String string2) {
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.size = new Dimension(n, n2);
        this.setSize(this.size);
        this.addComponentListener(this);
        this.addMouseListener(this);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint(100L);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.glj != null && this.glj.gljIsInit() && componentEvent.getComponent() == this) {
            this.mustResize = true;
            this.repaint();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void cvsDispose() {
        block2: {
            this.cvsInitialized = false;
            if (this.glj == null || !this.glj.gljIsInit()) break block2;
            try {
                this.glj.gljFree();
                this.doCleanup();
                this.glj.setEnabled(false);
                this.glj.gljDestroy();
                this.needCvsDispose = false;
            }
            catch (Exception exception) {
                this.needCvsDispose = true;
            }
        }
    }

    public final int cvsGetHeight() {
        return this.getSize().height;
    }

    public final int cvsGetWidth() {
        return this.getSize().width;
    }

    public boolean cvsIsInit() {
        return this.cvsInitialized;
    }

    public void display() {
    }

    public void doCleanup() {
    }

    public final GLContext getGLContext() {
        return this.glj;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public final Window getTopLevelWindow() {
        return this.topLevelWindow;
    }

    public void init() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public final synchronized void paint(Graphics graphics) {
        if (this.glj == null) {
            this.preInit();
            this.glj = new GLContext(this, this.gl, this.glu, this.createOwnWindow, this.doubleBuffer, this.stereoView, this.rgba, this.stencilBits, this.accumSize, this.sharedGLContext);
            if (this.glj != null) {
                this.createOwnWindow = this.glj.isOwnWindowCreated();
                this.doubleBuffer = this.glj.isDoubleBuffer();
                this.stencilBits = this.glj.getStencilBitNumber();
                this.accumSize = this.glj.getAccumSize();
                this.stereoView = this.glj.isStereoView();
                this.rgba = this.glj.isRGBA();
            }
            this.init();
            Container container = this.getParent();
            Container container2 = null;
            while (container != null) {
                container2 = container;
                container = container.getParent();
            }
            if (container2 instanceof Window) {
                this.topLevelWindow = (Window)container2;
                this.topLevelWindow.addComponentListener(this);
            } else {
                this.topLevelWindow = null;
                System.out.println("toplevel is not a Window: " + container2);
            }
            if (this.topLevelWindow != null) {
                this.topLevelWindow.addWindowListener(this);
            } else {
                System.out.println("no parent found for " + this.getName());
                System.out.flush();
            }
            if (this.glj != null && this.glj.gljIsInit()) {
                this.cvsInitialized = true;
            }
        }
        this.sDisplay();
    }

    public void preInit() {
    }

    public void reshape(int n, int n2) {
        this.gl.glViewport(0, 0, n, n2);
    }

    public final synchronized void sDisplay() {
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (!this.cvsIsInit()) {
            return;
        }
        if (this.mustResize && (bl = this.glj.gljMakeCurrent())) {
            this.size = this.getSize();
            this.glj.gljResize(this.size.width, this.size.height);
            this.reshape(this.size.width, this.size.height);
            this.mustResize = false;
            this.invalidate();
            this.repaint(100L);
        }
        if (bl) {
            this.display();
        }
        this._f_dur = System.currentTimeMillis() - l;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint(100L);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.needCvsDispose) {
            this.cvsDispose();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent().equals(this.topLevelWindow)) {
            this.cvsDispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

