*=$1001
        .byte $0b,$12,$0a,$00,$9e
        .text "4109"
        .byte 0,0,0

; 2048  lookuptables
;  512  charset
;  256  texture
;  768  koodi+vapaa

; charsetin plle voisi mys koodailla jonkin pIkKUEfEkTiN
; tai sitten alkulogon

; 64 char mode (512 bytes for chars) in 8x8 matrix
; 4x8 pix per char => 32x64 pixels per image

lda #255      ; gfx mode
sta 36869
lda #8+6      ; scr cols
sta 36879
lda #$1f    ; aux col, volume
sta 36878

ldx #0                 ; clrscr
cll lda #2
    sta 38400,x
    sta 38400+256,x
    lda #32+128
    sta 7680,x
    sta 7680+256,x
    dex
    bne cll

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        sei
        lda #<irq       ; set irq
        sta $314
        lda #>irq
        sta $315

        lda #0          ; reset lowtimer
        sta 162

        lda #$c0
        sta $912e       ; enable tym
        cli
        
;;;;;;;;;;;;;;;;

        lda #5

dzug    pha
        tax
        lda minney-1,x
        sta dmp0+1
        lda minnex-1,x
        sta 251
        sta 253
        lda minnea-1,x
        jsr dm9
          pla
          tax
          dex
          beq dru0
          txa
          pha
        jsr waitr
          pla
        jmp dzug

dru0 ldy #seqsar3-seqs+15
     sty ch2ptr+1
     jsr waitr ;;;;;;;;

lda #33
sta txp7+1
jsr waitr

;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;

        sei
        lda #<60095
        sta $314
        lda #>60095
        sta $315
        cli

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; load next part

ldn  lda #240
     sta 36869
     sta 36878

      ldx #0
ldl0  lda loader,x
      jsr 65490
      inx
      cpx #15-3
      bne ldl0
ldl1  lda loader,x
      sta 631-15+3,x
      inx
      cpx #19-3
      bne ldl1
      lda #4
      sta 198
rts

loader  .byte 147,17,17
        .byte 76,79+32,34
        .text "3*"
        .byte 34
        .text ",8"
        .byte 19

        .byte 13,82,85+32,13  ;KORJAA 83->82

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

waitr   lda #0
        beq txp0

        lda #0
        sta waitr+1
        rts

        nop      ; hiukka alignia bugin takia
        nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; texturepyritys.

txp0  lda #1
      sta texture

        lda txp1+1
txp2    eor #0
        sta txp1+1

txp7    ldx #0
txp1    ldy #16
        bpl txl

txl2    lda texture,y
        sta texture,x
        dey
        dex
        bne txl2
        jmp txl3

txl     lda texture,y
        sta texture,x
txl9    iny
        inx
        bne txl

txl3  lda texture
      sta txp0+1
      lda #0
      sta texture

; ruudulla: byte# = y+int(x/4)*8, lookup# = x&3

; lookup0 = tavun vasemmanpuoleisimmat
;       1 = toiset jne
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; tUNNEL iNNERLOOP

ldx #0

luup ldy lookup0,x  ; *...
     lda texture,y
     asl
     asl

ldy lookup1,x  ; .*..
ora texture,y
asl
asl

ldy lookup2,x  ; ..*.
ora texture,y
asl
asl

ldy lookup3,x  ; ...*
ora texture,y
sta 7168,x

ldy lookup0+256,x  ; *..
lda texture,y
asl
asl

ldy lookup1+256,x  ; .*..
ora texture,y
asl
asl

ldy lookup2+256,x  ; ..*.
ora texture,y
asl
asl

ldy lookup3+256,x  ; ...*
ora texture,y
sta 7168+256,x

inx
bne luup

jmp waitr

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; dRAWMASK

dm9     sta 252
        clc
        adc #120
        sta 254

        ldy #9
        lda #73+128
        sta (251),y
        dey

        lda #64+128
dml9    sta (251),y
        dey
        bne dml9

        lda #85+128
        sta (251),y

        tya
        ldy #22
        clc

dml1    pha

        ;;;;;;

        tax
        lda #93+128
        sta (251),y
        iny
        txa

dml0    sta (251),y
        tax
dmp0    lda #16+4
        sta (253),y
        txa

        iny
        adc #8
        cmp #64
        clc
        bmi dml0

        tax
        lda #93+128
        sta (251),y
        txa

        ;;;;;;

        tya
        adc #22-9
        tay

        pla
        adc #1
        cmp #8
        clc
        bmi dml1

        ;;;;;;

        lda #74+128
        sta (251),y
        iny

        lda #64+128
dml8    sta (251),y
        iny
        cpy #207
        bne dml8

        lda #75+128
        sta (251),y
        rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

irq     lda $9124       ; akn  tartteeko???

        ;;;

        lda #1
        bit 162
        bne irqo0

        ;;; ch2 arpeggio

ch2a    ldx #0
        lda #2
        bit 162
        bne ch2o9
ch2b    ldx #0
ch2o9   stx 36876

        ;;; zax rt every 4

        lda #3         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        bit 162
        bne irqo0
       
irqo2   jsr ch0ptr

        ;;; dezigntik every 16

        lda 162
        and #15
        cmp #8
        bne irqo0

        inc dznxt+1     ; dznxt+1 = slowtimer

dzptr   ldx #0          ; dizajntick whenever [dznxt+1] = [dzptr+1]
        lda dzdata,x
dznxt   cmp #0
        bne irqo0

        inx             ; readbyte => choff value       
        lda dzdata,x    ;            & ch ptr valuezzz!!
        bpl dzo1
        sta waitr+1     ; dzekkaa bitit 64/32/16.
                        ; niiden mukaan uusia arvoja sequille/rotolle
dzo1    bit imm64
        beq dzo2

        tay
        inx
        lda dzdata,x
        sta txp1+1
        inx
        lda dzdata,x
        sta txp2+1
        tya


dzo2    and #15
        sta choff+1
        inx

        stx dzptr+1

irqo0   jmp 60095       ; exit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ch0ptr  ldx #0
        inc ch0ptr+1
        lda seqs,x
        beq ch0sta      ; 0->nosound
        bmi ch0rst      ; >127 -> reset

        clc
choff   adc #0
        tay
        lda frex-1,y
ch0sta  sta 36874
        sta 36875

;;;;;;;;;;;;;;;;;;;;;;;;;;

ch2ptr  ldx #seqsar-seqs
        inc ch2ptr+1
        lda seqs,x
        beq ch2sta
        cmp #$ff
        beq ch2rst
        
        clc
        tax
        and #15        
        adc choff+1
        tay
        lda frex-1,y
        sta ch2a+1
        txa
        lsr
        lsr
        lsr
        lsr
        clc
        adc choff+1
        tay
        lda frex-1,y
        sta ch2b+1

        rts               

ch0rst  eor #$80
        sta ch0ptr+1
        jmp ch0ptr
        
;ch1rst  eor #$80        ; seqjump to seqs+x&127
;        sta ch1ptr+1
;        jmp ch1ptr

ch2sta  sta ch2a+1
        sta ch2b+1
        rts
ch2rst  lda ch2ptr+1
        sbc #17
        sta ch2ptr+1
        jmp ch2ptr

;;;

;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;

k=7680
l=7680+22-10
m=7680+22-10+((23-10)*22)
n=7680+((23-10)*22)
o=7680+(22-16)+(6*22)

minnex .byte <o, <n, <m, <l, <k
minnea .byte >o, >n, >m, >l, >k
minney .byte 8+3, 8+2, 8+4, 8+5, 8+7

frex    .byte 135,143,147,151,159,163,167,175,179,183,187,191,195
        .byte 199,201,203,207,209,212,215,217,219,221,223,225

seqs    .byte 1,0,4,0,8,0,1,0,13,0,8,0,4,0,13,0,128

seqsar3 .byte $8d,$8d,$8d,0,$11,0,$88,0,$dd,$dd,0,0,$bb,0,$bb,0,255
seqsar  .byte $11,0,$11,0,$11,0,$11,0,$6d,$6d,$6d,0,0,0,$6d,0,255

; c c# d d# e f f# g g# a a# b
; 1 2  3 4  5 6 7  8 9 10 11 12


dzdata  .byte        8,128+5,  12,128+7,  16,0, 24,5, 28,128+7
imm32   .byte 32,64+3,240,0,      40,5+3+64,32,32+16, 44,7+3,
        .byte 48,64+0+3,1,0,      56,5+3+64,16+1,1, 60,7+3,  62,3,
imm64   .byte 64,128+32+64+0,241,0, 72,7, 76,5,
        .byte 80,0+64,17,0, 88,7, 92,5,
        .byte 96,5+64,240,0,  104,5+7,
        .byte 112,5+64,254,0,  120,0+128+64,17,255-1
        .byte 128,128

; c c+ d d+ e f f+ g
; c e c c+ g e c g

;note <127:  actual_note = note+1+off    1..127 ==  2..128
;note >127:  actual_note = note+off     -1..127 == -1..128

;;;;;;;;;

*=7168-2048-256

texture .byte 1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .byte 1,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0
        .byte 0,0,0,0,0,3,0,3,0,0,0,2,2,0,0,3
        .byte 3,0,0,2,0,0,3,3,0,2,2,2,2,2,0,3
        .byte 0,0,2,2,2,0,0,0,0,0,2,2,2,0,0,3
        .byte 0,2,2,2,2,0,0,0,0,0,0,2,0,0,0,0
        .byte 0,0,0,2,2,0,0,3,0,0,1,0,0,0,0,0
        .byte 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0
        .byte 0,1,1,1,1,0,3,3,0,1,1,1,0,0,0,0
        .byte 2,0,1,1,1,3,3,3,0,0,1,1,0,0,0,2
        .byte 2,2,0,1,0,0,0,0,0,0,3,0,0,0,0,2
        .byte 2,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0
        .byte 2,0,0,0,0,2,0,0,0,0,0,0,3,3,0,0
        .byte 0,0,0,0,2,2,2,2,0,0,0,3,3,0,0,0
        .byte 1,1,0,0,0,2,2,2,0,0,0,0,0,0,0,0
        .byte 1,1,1,0,0,0,2,0,0,0,0,0,0,0,0,0


lookup0 .byte  197,181,181,182,182,166,166,166,150,150,150,134,134,135,119,119,119,103,103,87,87,71,71,71,56,56,40,40,24,24,8,8
.byte  248,248,232,232,216,216,200,200,183,183,183,167,167,151,151,135,135,135,119,118,118,102,102,102,86,86,86,70,70,69,69,53
.byte  230,230,214,214,215,215,199,199,199,183,184,184,168,168,152,153,153,137,137,121,121,106,90,90,74,74,58,42,43,27,11,11
.byte  251,251,235,219,218,202,186,186,170,170,154,137,137,121,121,105,105,104,88,88,72,72,71,55,55,55,39,39,38,38,22,22
.byte  23,23,7,7,8,8,248,248,249,249,233,234,218,218,219,203,203,188,188,173,157,157,142,126,127,111,80,64,48,32,16,1
.byte  241,224,208,192,176,160,159,143,142,126,109,109,93,76,76,59,59,43,42,42,26,25,9,9,8,8,248,248,247,247,231,231
.byte  71,72,72,72,73,73,57,58,58,58,59,43,44,44,45,30,31,31,0,1,243,244,229,215,200,186,172,142,112,82,51,20
.byte  228,195,162,128,126,92,74,56,39,21,4,3,241,240,239,239,238,221,220,220,219,203,202,202,202,201,185,185,184,184,184,183
.byte  136,136,136,136,137,137,138,138,138,139,139,140,141,141,142,143,128,145,146,148,150,152,154,157,161,166,173,0,0,0,0,0
.byte  0,0,0,0,0,93,86,81,109,106,104,102,100,98,97,112,127,126,125,125,124,123,123,122,122,122,121,121,120,120,120,120
.byte  199,200,200,200,200,217,217,217,218,218,234,235,235,236,253,253,14,15,15,16,33,34,51,68,85,103,120,137,170,187,220,252
.byte  12,44,75,90,121,136,151,165,180,195,210,209,224,255,255,254,13,13,28,27,27,26,42,42,41,41,41,56,56,56,56,55
.byte  247,247,247,7,7,8,8,24,24,25,41,41,41,58,58,74,75,91,91,108,108,124,141,141,157,174,190,206,206,222,239,255
.byte  15,31,46,62,62,78,94,109,125,125,140,156,156,171,171,187,186,202,202,217,217,217,233,232,232,248,248,247,247,7,7,7
.byte  38,38,38,54,54,55,55,71,71,71,87,87,88,104,104,120,120,120,137,137,153,153,169,169,185,201,202,218,218,234,250,250
.byte  10,10,26,42,42,58,57,73,89,89,105,105,121,121,136,136,136,152,152,168,167,167,183,183,183,199,199,198,198,214,214,214

lookup1 .byte  197,198,198,182,182,182,182,166,166,166,151,151,151,135,135,119,119,119,104,104,88,88,72,72,56,56,40,40,24,24,8,8
.byte  248,248,232,232,216,216,200,200,184,184,168,168,152,152,135,135,135,119,119,103,103,103,86,86,86,70,70,70,70,54,54,53
.byte  246,230,231,231,231,215,215,215,200,200,200,184,184,185,169,169,153,154,138,138,122,122,107,91,91,75,59,59,44,28,28,12
.byte  252,236,236,220,203,203,187,171,171,155,138,138,122,122,106,105,89,89,73,72,72,56,56,56,39,39,39,23,23,23,22,6
.byte  39,23,23,24,24,24,8,9,9,249,250,250,250,235,235,220,220,205,205,190,190,175,159,128,113,113,98,82,67,35,19,3
.byte  243,227,211,179,162,146,129,129,112,111,95,78,78,61,61,44,44,27,27,10,10,10,9,249,249,248,232,232,232,231,231,215
.byte  88,88,88,88,89,89,89,74,74,75,75,76,76,61,62,62,63,32,33,35,20,22,7,249,252,223,194,182,153,125,65,18
.byte  226,177,141,105,70,50,47,12,9,247,230,228,211,209,208,207,206,206,205,188,188,187,187,186,186,169,169,169,168,168,168,168
.byte  152,152,152,152,153,153,153,154,154,171,171,172,172,173,174,175,160,177,178,179,181,199,201,220,223,227,248,15,0,0,0,0
.byte  0,0,0,0,255,8,19,47,44,57,55,69,67,66,65,80,95,94,93,92,92,91,91,106,106,105,105,105,104,104,104,104
.byte  215,215,216,216,216,232,233,233,233,234,250,251,251,11,12,12,29,30,46,63,48,64,81,82,99,116,132,165,182,198,215,247
.byte  7,39,54,70,85,116,132,147,162,161,176,192,207,222,238,237,252,252,251,11,11,10,26,25,25,25,24,40,40,40,39,39
.byte  6,7,7,7,23,23,24,40,40,40,56,57,57,73,73,90,90,106,106,123,123,139,140,156,172,172,188,205,221,237,237,253
.byte  13,29,29,45,61,76,92,92,108,124,123,139,139,154,154,170,170,185,185,201,201,200,216,216,216,232,231,231,247,247,247,246
.byte  38,54,54,54,54,70,70,71,87,87,87,103,103,103,119,120,136,136,136,152,152,168,168,185,185,201,201,217,233,233,249,249
.byte  9,9,25,25,41,57,57,73,73,88,88,104,104,120,120,120,136,135,151,151,151,167,167,167,183,182,182,198,198,198,198,214

lookup2 .byte  214,198,198,198,198,182,182,183,167,167,167,151,151,151,135,136,120,120,120,104,104,88,88,73,73,57,57,41,25,25,9,9
.byte  249,249,233,233,217,201,201,185,185,168,168,152,152,136,136,136,120,119,103,103,103,87,87,87,71,70,70,54,54,54,54,38
.byte  246,247,247,247,231,231,232,216,216,216,200,201,201,185,185,170,170,154,154,139,139,123,124,108,92,92,76,61,45,29,29,13
.byte  253,237,237,221,205,188,172,172,156,140,139,123,123,106,106,90,90,73,73,57,57,56,40,40,40,24,23,23,7,7,7,6
.byte  39,39,40,40,40,24,25,25,25,26,10,11,11,251,252,252,237,238,222,207,192,176,161,162,147,132,116,85,70,54,39,7
.byte  247,215,198,182,165,132,116,99,82,81,64,48,63,46,30,29,12,12,11,251,251,250,234,233,233,233,232,216,216,216,215,215
.byte  104,104,104,104,105,105,105,106,106,91,91,92,92,93,94,95,80,65,66,67,69,55,57,44,47,19,8,255,0,0,0,0
.byte  0,0,0,0,15,248,227,223,220,201,199,181,179,178,177,160,175,174,173,172,172,171,171,154,154,153,153,153,152,152,152,152
.byte  168,168,168,168,169,169,169,186,186,187,187,188,188,205,206,206,207,208,209,211,228,230,247,9,12,47,50,70,105,141,177,226
.byte  18,65,125,153,182,194,223,252,249,7,22,20,35,33,32,63,62,62,61,76,76,75,75,74,74,89,89,89,88,88,88,88
.byte  215,231,231,232,232,232,248,249,249,9,10,10,10,27,27,44,44,61,61,78,78,95,111,112,129,129,146,162,179,211,227,243
.byte  3,19,35,67,82,98,113,113,128,159,175,190,190,205,205,220,220,235,235,250,250,250,249,9,9,8,24,24,24,23,23,39
.byte  6,22,23,23,23,39,39,39,56,56,56,72,72,73,89,89,105,106,122,122,138,138,155,171,171,187,203,203,220,236,236,252
.byte  12,28,28,44,59,59,75,91,91,107,122,122,138,138,154,153,169,169,185,184,184,200,200,200,215,215,215,231,231,231,230,246
.byte  53,54,54,70,70,70,70,86,86,86,103,103,103,119,119,135,135,135,152,152,168,168,184,184,200,200,216,216,232,232,248,248
.byte  8,8,24,24,40,40,56,56,72,72,88,88,104,104,119,119,119,135,135,151,151,151,166,166,166,182,182,182,182,198,198,197

lookup3 .byte  214,214,214,198,198,199,199,183,183,183,167,167,168,152,152,136,136,136,121,121,105,105,89,89,73,57,58,42,42,26,10,10
.byte  250,250,234,218,218,202,201,185,169,169,153,153,137,137,120,120,120,104,104,88,87,87,71,71,71,55,55,54,54,38,38,38
.byte  7,7,7,247,247,248,248,232,232,233,217,217,217,202,202,186,187,171,171,156,156,140,125,125,109,94,78,62,62,46,31,15
.byte  255,239,222,206,206,190,174,157,141,141,124,108,108,91,91,75,74,58,58,41,41,41,25,24,24,8,8,7,7,247,247,247
.byte  55,56,56,56,56,41,41,41,42,42,26,27,27,28,13,13,254,255,255,224,209,210,195,180,165,151,136,121,90,75,44,12
.byte  252,220,187,170,137,120,103,85,68,51,34,33,16,15,15,14,253,253,236,235,235,234,218,218,217,217,217,200,200,200,200,199
.byte  120,120,120,120,121,121,122,122,122,123,123,124,125,125,126,127,112,97,98,100,102,104,106,109,81,86,93,0,0,0,0,0
.byte  0,0,0,0,0,173,166,161,157,154,152,150,148,146,145,128,143,142,141,141,140,139,139,138,138,138,137,137,136,136,136,136
.byte  183,184,184,184,185,185,201,202,202,202,203,219,220,220,221,238,239,239,240,241,3,4,21,39,56,74,92,126,128,162,195,228
.byte  20,51,82,112,142,172,186,200,215,229,244,243,1,0,31,31,30,45,44,44,43,59,58,58,58,57,73,73,72,72,72,71
.byte  231,231,247,247,248,248,8,8,9,9,25,26,42,42,43,59,59,76,76,93,109,109,126,142,143,159,160,176,192,208,224,241
.byte  1,16,32,48,64,80,111,127,126,142,157,157,173,188,188,203,203,219,218,218,234,233,249,249,248,248,8,8,7,7,23,23
.byte  22,22,38,38,39,39,55,55,55,71,72,72,88,88,104,105,105,121,121,137,137,154,170,170,186,186,202,218,219,235,251,251
.byte  11,11,27,43,42,58,74,74,90,90,106,121,121,137,137,153,153,152,168,168,184,184,183,199,199,199,215,215,214,214,230,230
.byte  53,69,69,70,70,86,86,86,102,102,102,118,118,119,135,135,135,151,151,167,167,183,183,183,200,200,216,216,232,232,248,248
.byte  8,8,24,24,40,40,56,56,71,71,71,87,87,103,103,119,119,119,135,134,134,150,150,150,166,166,166,182,182,181,181,197

